/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.io;

import fr.emac.gind.commons.utils.io.AbstractFileLoader;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DirectoryListener
implements Runnable {
    private static Logger LOG = LoggerFactory.getLogger((String)DirectoryListener.class.getName());
    private WatchService watcher = null;
    private boolean stop = false;
    private File directory = null;
    private ServiceLoader<AbstractFileLoader> commandLoader = ServiceLoader.load(AbstractFileLoader.class);
    private Map<QName, AbstractFileLoader> fileLoaders = new HashMap<QName, AbstractFileLoader>();
    private Object configuration = null;
    private Map<String, File> cachedFiles = new HashMap<String, File>();

    public DirectoryListener(File dir, Object configuration) throws Exception {
        this.configuration = configuration;
        this.directory = dir;
        this.directory.mkdirs();
        Path path = Paths.get(dir.toURI());
        this.initFileLoaders();
        this.watcher = path.getFileSystem().newWatchService();
        path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE);
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public Map<QName, AbstractFileLoader> getFileLoaders() {
        return this.fileLoaders;
    }

    private void initFileLoaders() throws Exception {
        this.fileLoaders.clear();
        this.commandLoader.reload();
        for (AbstractFileLoader command : this.commandLoader) {
            command.setConfiguration(this.configuration);
            this.fileLoaders.put(command.getQName(), command);
        }
    }

    @Override
    public void run() {
        File[] filesAlreadyPresent = FileUtil.getAllFiles(this.directory);
        if (filesAlreadyPresent.length > 0) {
            boolean loaded = false;
            while (!loaded) {
                try {
                    for (File file : filesAlreadyPresent) {
                        this.analyzeFile(file);
                    }
                    loaded = true;
                    LOG.warn("Resources in listener loaded");
                }
                catch (Exception e) {
                    LOG.warn("Problem to load resources in listener");
                    e.printStackTrace();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        while (!this.stop) {
            try {
                WatchKey watckKey = this.watcher.take();
                List<WatchEvent<?>> events = watckKey.pollEvents();
                for (WatchEvent<?> event : events) {
                    File file;
                    if (event.kind() != StandardWatchEventKinds.ENTRY_CREATE) continue;
                    file = new File(this.directory, event.context().toString());
                    this.analyzeFile(file);
                }
                LOG.debug("files detected by listener: " + String.valueOf(this.cachedFiles.keySet()));
                watckKey.reset();
            }
            catch (Exception e) {
                LOG.warn("Error: " + e.getMessage());
            }
        }
    }

    private boolean analyzeFile(File file) {
        block10: {
            HashMap<QName, AbstractFileLoader> fileLoadersSelected = new HashMap<QName, AbstractFileLoader>();
            for (Map.Entry<QName, AbstractFileLoader> fileLoader : this.fileLoaders.entrySet()) {
                if (fileLoader.getValue().listenedDirectories() == null || fileLoader.getValue().listenedDirectories().isEmpty()) {
                    fileLoadersSelected.put(fileLoader.getKey(), fileLoader.getValue());
                    continue;
                }
                if (!fileLoader.getValue().listenedDirectories().contains(this.directory)) continue;
                fileLoadersSelected.put((QName)fileLoader.getKey(), (AbstractFileLoader)fileLoader.getValue());
            }
            try {
                block12: {
                    block11: {
                        if (this.containsInCache(this.cachedFiles, file)) break block10;
                        if (!file.isFile()) break block11;
                        Object doc = null;
                        try {
                            doc = DOMUtil.getInstance().parse(file);
                        }
                        catch (Throwable e) {
                            doc = null;
                        }
                        if (doc == null) break block12;
                        QName name = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
                        AbstractFileLoader fileLoader = (AbstractFileLoader)fileLoadersSelected.get(name);
                        if (fileLoader == null && new QName("http://www.gind.emac.fr/modeler/genericModel", "node").equals(name)) {
                            Element type = DOMUtil.getInstance().findFirstElementByNs(doc.getDocumentElement(), new QName("http://www.gind.emac.fr/modeler/genericModel", "type"));
                            System.out.println("type = " + String.valueOf(type));
                            String nameWithPrefix = type.getTextContent();
                            String nameT = nameWithPrefix.split(":")[1];
                            String prefixT = nameWithPrefix.split(":")[0];
                            String nsT = type.lookupNamespaceURI(prefixT);
                            name = new QName(nsT, nameT);
                            fileLoader = (AbstractFileLoader)fileLoadersSelected.get(name);
                        }
                        if (fileLoader == null) break block12;
                        LOG.debug("Listener " + String.valueOf(fileLoader) + " found");
                        fileLoader.setConfiguration(this.configuration);
                        fileLoader.load(file);
                        String key = file.getName();
                        for (File listenedRepo : fileLoader.listenedDirectories()) {
                            if (!key.contains(listenedRepo.getName())) continue;
                            key = key.replace(listenedRepo.getName(), "");
                        }
                        LOG.debug("file stock in cache with key: " + key);
                        this.cachedFiles.put(key, file);
                        LOG.debug("File loaded " + fileLoader.getClass().getSimpleName() + ": " + String.valueOf(file));
                        break block12;
                    }
                    for (Map.Entry<QName, AbstractFileLoader> fileLoader : fileLoadersSelected.values()) {
                        LOG.debug("Listener " + String.valueOf(fileLoader) + " found");
                        ((AbstractFileLoader)((Object)fileLoader)).setConfiguration(this.configuration);
                        ((AbstractFileLoader)((Object)fileLoader)).load(file);
                        String key = file.getName();
                        for (File listenedRepo : ((AbstractFileLoader)((Object)fileLoader)).listenedDirectories()) {
                            if (!key.contains(listenedRepo.getName())) continue;
                            key = key.replace(listenedRepo.getName(), "");
                        }
                        LOG.debug("file stock in cache with key: " + key);
                        this.cachedFiles.put(key, file);
                        LOG.debug("File loaded using " + fileLoader.getClass().getSimpleName() + ": " + String.valueOf(file));
                    }
                }
                return true;
            }
            catch (Exception e) {
                LOG.warn("Impossible to load file: " + String.valueOf(file));
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean containsInCache(Map<String, File> cachedFiles, File file) {
        return cachedFiles.keySet().stream().anyMatch(key -> file.toString().contains((CharSequence)key));
    }
}

