/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml.resolver;

import fr.emac.gind.commons.utils.xml.resolver.ClasspathURIResolver;
import fr.emac.gind.commons.utils.xml.resolver.DefaultURIResolver;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;

public class URIMultipleResolvers
implements URIResolver {
    protected List<URIResolver> resolvers = new ArrayList<URIResolver>();

    public URIMultipleResolvers() {
        this(new DefaultURIResolver(), new ClasspathURIResolver());
    }

    public URIMultipleResolvers(URIResolver ... resolvers) {
        for (URIResolver resolver : resolvers) {
            this.resolvers.add(resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Source res = null;
        for (URIResolver resolver : this.resolvers) {
            try {
                URIResolver uRIResolver = resolver;
                synchronized (uRIResolver) {
                    res = resolver.resolve(href, base);
                    if (res != null) {
                        break;
                    }
                }
            }
            catch (TransformerException transformerException) {
            }
        }
        return res;
    }

    public URIResolver[] getURIResolvers() {
        return this.resolvers.toArray(new URIResolver[this.resolvers.size()]);
    }
}

