/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.net;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)IPUtil.class.getName());

    public static List<String> getIpAddresses() throws RuntimeException {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface networkInterface = n.nextElement();
                Enumeration<InetAddress> a = networkInterface.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress addr = a.nextElement();
                    if (!InetAddressValidator.getInstance().isValid(addr.getHostAddress()) || IPUtil.isVirtualNetworkInterface(networkInterface)) continue;
                    ips.add(addr.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            throw new UncheckedException(e);
        }
        return ips;
    }

    private static boolean isVirtualNetworkInterface(NetworkInterface networkInterface) {
        return networkInterface.isVirtual() || networkInterface.getDisplayName().toLowerCase().contains("virtual");
    }

    public static String getFirtValidIpAddress() throws RuntimeException {
        List<String> ips = IPUtil.getIpAddresses();
        Collections.sort(ips, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String ip : ips.reversed()) {
            if (ip.startsWith("127.")) continue;
            return ip;
        }
        for (String ip : ips) {
            if (!ip.startsWith("127.")) continue;
            return ip;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            LOG.warn("port already used: " + port);
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static int getFirstAvailablePortFrom(int firstPort) {
        int port = firstPort;
        while (!IPUtil.available(port)) {
            ++port;
        }
        return port;
    }

    public static String createPrettyAddressFomContext(Map<String, Object> context) {
        String host = context.get("host").toString();
        int port = Integer.parseInt(context.get("port").toString());
        String base_uri = "http://0.0.0.0:" + port;
        Integer proxify = null;
        if (context.get("proxy-port") != null) {
            proxify = Integer.parseInt(context.get("proxy-port").toString());
        }
        TRANSPORT_PROTOCOL protocol = TRANSPORT_PROTOCOL.HTTP;
        if (context.get("protocol") != null) {
            protocol = TRANSPORT_PROTOCOL.fromString(context.get("protocol").toString());
        }
        String pretty_address = IPUtil.createPrettyHost(host, port, protocol, proxify);
        return pretty_address;
    }

    public static String createPrettyHost(String host, Integer port, TRANSPORT_PROTOCOL protocol, Integer proxify) throws RuntimeException {
        Object prettyHost = null;
        if (host.equals("0.0.0.0") || host.equals("localhost") || host.equals("127.0.0.1")) {
            prettyHost = IPUtil.getFirtValidIpAddress();
            if (port != null) {
                prettyHost = (String)prettyHost + ":" + port;
            }
        } else {
            prettyHost = IPUtil.isIP(host) ? (proxify != null && proxify > 0 ? host + ":" + proxify : host + ":" + port) : host;
        }
        if (protocol != null) {
            return String.valueOf((Object)protocol) + "://" + (String)prettyHost;
        }
        return prettyHost;
    }

    public static boolean isIP(String input) {
        String regex = "(?:[0-9]{1,3}\\.){3}[0-9]{1,3}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        String ss = input.replace(".", "");
        return m.find() && IPUtil.isNumeric(ss) && input.length() - ss.length() > 2;
    }

    private static boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum TRANSPORT_PROTOCOL {
        HTTP("http"),
        HTTPS("https");

        private final String text;

        private TRANSPORT_PROTOCOL(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static TRANSPORT_PROTOCOL fromString(String text) {
            for (TRANSPORT_PROTOCOL b : TRANSPORT_PROTOCOL.values()) {
                if (!b.text.equalsIgnoreCase(text)) continue;
                return b;
            }
            return null;
        }
    }
}

