/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.uri;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class URIHelper {
    public static URI filePathToUri(String path) {
        URI uri;
        try {
            path = path.replaceAll("\\\\", "/");
            uri = new URI(path);
        }
        catch (URISyntaxException e1) {
            uri = new File(path).toURI();
            uri.normalize();
        }
        return uri;
    }

    public static URI resolve(URI baseURI, String systemId) throws MalformedURLException, URISyntaxException {
        URI res = null;
        if (baseURI == null) {
            if (systemId == null) {
                return null;
            }
            return URI.create(systemId);
        }
        if ("jar".equals(baseURI.getScheme())) {
            res = new URL(baseURI.toURL(), systemId).toURI();
        } else if (baseURI.isAbsolute()) {
            res = baseURI.resolve(systemId);
        }
        return res;
    }

    public static Map<String, String> getParamsInQuery(URI uri) {
        HashMap<String, String> map = new HashMap<String, String>();
        String query = uri.getQuery();
        if (query != null & query.trim().length() > 0) {
            for (String param : query.split("&")) {
                String[] keyVal = param.split("=");
                String key = null;
                String value = null;
                if (keyVal.length == 0 || keyVal.length > 2) {
                    throw new UncheckedException("Error to analyse query of this uri: " + String.valueOf(uri));
                }
                key = keyVal[0];
                if (keyVal.length == 2) {
                    value = keyVal[1];
                }
                map.put(key, value);
            }
        }
        return map;
    }
}

