/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.xml.resolver;

import fr.emac.gind.commons.utils.uri.URIHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

public class DefaultURIResolver
implements URIResolver {
    @Override
    public Source resolve(String hRef, String baseURI) throws TransformerException {
        try {
            URI uri;
            URI base = null;
            if (baseURI != null) {
                base = URI.create(baseURI);
            }
            if ((uri = URIHelper.resolve(base, hRef)) != null && uri.isAbsolute()) {
                return new SAXSource(new InputSource(uri.toURL().openStream()));
            }
        }
        catch (MalformedURLException e) {
            throw new TransformerException(e);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
        catch (URISyntaxException e) {
            throw new TransformerException(e);
        }
        return null;
    }
}

