/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.gis.distance.impl;

import fr.emac.gind.commons.gis.distance.api.DistanceTimeItf;
import fr.emac.gind.distance.data.GJaxbLeg;
import fr.emac.gind.distance.data.GJaxbLocalization;
import fr.emac.gind.distance.data.GJaxbPair;
import fr.emac.gind.distance.data.GJaxbRoute;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistanceTimeInternal
implements DistanceTimeItf {
    private static Logger LOG = LoggerFactory.getLogger((String)DistanceTimeInternal.class.getName());
    private double vMoy = 16.0;

    @Override
    public GJaxbPair findJourney(GJaxbLocalization departure, GJaxbLocalization destination) throws Exception {
        GJaxbPair pair = new GJaxbPair();
        pair.setLocalizationStart(new GJaxbPair.LocalizationStart());
        pair.getLocalizationStart().setLocalization(departure);
        pair.setLocalizationEnd(new GJaxbPair.LocalizationEnd());
        pair.getLocalizationEnd().setLocalization(destination);
        double phi1 = departure.getPoint().getLatitude() * Math.PI / 180.0;
        double lambda1 = departure.getPoint().getLongitude() * Math.PI / 180.0;
        double altitude1 = departure.getPoint().isSetAltitude() ? departure.getPoint().getAltitude() : 0.0;
        double phi2 = destination.getPoint().getLatitude() * Math.PI / 180.0;
        double lambda2 = destination.getPoint().getLongitude() * Math.PI / 180.0;
        double altitude2 = destination.getPoint().isSetAltitude() ? destination.getPoint().getAltitude() : 0.0;
        double dist = 6380.0 * Math.acos(Math.sin(phi1) * Math.sin(phi2) + Math.cos(phi1) * Math.cos(phi2) * Math.cos(lambda1 - lambda2));
        dist = Math.sqrt(Math.pow(dist, 2.0) + Math.pow(altitude1 - altitude2, 2.0));
        double VMoy = this.vMoy;
        double time = dist / (VMoy /= 3600.0);
        JSONArray travel = new JSONArray();
        Object jsonString = "{\"lat\":";
        jsonString = (String)jsonString + departure.getPoint().getLatitude();
        jsonString = (String)jsonString + ",\"lng\":";
        jsonString = (String)jsonString + departure.getPoint().getLongitude();
        jsonString = (String)jsonString + "}";
        travel.put((Object)new JSONObject((String)jsonString));
        jsonString = "{\"lat\":";
        jsonString = (String)jsonString + destination.getPoint().getLatitude();
        jsonString = (String)jsonString + ",\"lng\":";
        jsonString = (String)jsonString + destination.getPoint().getLongitude();
        jsonString = (String)jsonString + "}";
        travel.put((Object)new JSONObject((String)jsonString));
        GJaxbRoute route = new GJaxbRoute();
        GJaxbLeg leg = new GJaxbLeg();
        leg.setDuration(time);
        leg.setDistance(dist * 1000.0);
        route.getLeg().add(leg);
        route.setSummary(travel.toString());
        pair.getRoute().add(route);
        return pair;
    }

    public double getvMoy() {
        return this.vMoy;
    }

    public void setvMoy(double vMoy) {
        this.vMoy = vMoy;
    }
}

