/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.gis.distance.impl;

import fr.emac.gind.commons.gis.distance.api.DistanceTimeItf;
import fr.emac.gind.distance.data.GJaxbLeg;
import fr.emac.gind.distance.data.GJaxbLocalization;
import fr.emac.gind.distance.data.GJaxbPair;
import fr.emac.gind.distance.data.GJaxbRoute;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistanceTimeMapQuest
implements DistanceTimeItf {
    private static Logger LOG = LoggerFactory.getLogger((String)DistanceTimeMapQuest.class.getName());
    public static long MAPQUEST_CALLS = 0L;
    private String mapQuestKey = null;

    public DistanceTimeMapQuest(String key) {
        this.mapQuestKey = key;
    }

    @Override
    public GJaxbPair findJourney(GJaxbLocalization departure, GJaxbLocalization destination) throws Exception {
        GJaxbPair pair = new GJaxbPair();
        pair.setLocalizationStart(new GJaxbPair.LocalizationStart());
        pair.getLocalizationStart().setLocalization(departure);
        pair.setLocalizationEnd(new GJaxbPair.LocalizationEnd());
        pair.getLocalizationEnd().setLocalization(destination);
        Object link = "http://www.mapquestapi.com/directions/v2/route?";
        link = (String)link + "&key=" + this.mapQuestKey;
        link = (String)link + "&outFormat=json";
        link = (String)link + "&from=" + departure.getPoint().getLatitude() + "," + departure.getPoint().getLongitude();
        link = (String)link + "&to=" + destination.getPoint().getLatitude() + "," + destination.getPoint().getLongitude();
        link = (String)link + "&locale=fr_FR";
        Client client = ClientBuilder.newClient();
        client.property("jersey.config.client.connectTimeout", (Object)0);
        client.property("jersey.config.client.readTimeout", (Object)0);
        Object url = link;
        LOG.info("try to send: " + (String)url);
        WebTarget webTarget = client.target((String)url);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        Response response = invocationBuilder.get();
        ++MAPQUEST_CALLS;
        if (response.getStatus() != 200) {
            String error = (String)response.readEntity(String.class);
            LOG.debug("Error from Server .... \n");
            LOG.debug(error);
            throw new Exception("Failed on OSM Server (HTTP error code : " + response.getStatus() + ") : " + error);
        }
        String output = (String)response.readEntity(String.class);
        LOG.debug("MapQuest response (" + MAPQUEST_CALLS + ") " + output);
        JSONObject jsonAPI = new JSONObject(output);
        if (jsonAPI.getJSONObject("route") != null && jsonAPI.getJSONObject("route").getJSONArray("legs") != null && jsonAPI.getJSONObject("route").getJSONArray("legs").length() > 0 && jsonAPI.getJSONObject("route").getJSONArray("legs").getJSONObject(0) != null && jsonAPI.getJSONObject("route").getJSONArray("legs").getJSONObject(0).getJSONArray("maneuvers") != null) {
            JSONArray journey = jsonAPI.getJSONObject("route").getJSONArray("legs").getJSONObject(0).getJSONArray("maneuvers");
            JSONArray travel = new JSONArray();
            String departureString = "{\"lat\":" + departure.getPoint().getLatitude() + ",\"lng\":" + departure.getPoint().getLongitude() + "}";
            travel.put((Object)new JSONObject(departureString));
            for (int i = 0; i < journey.length(); ++i) {
                JSONObject move = journey.getJSONObject(i);
                Object jsonString = "{\"lat\":";
                jsonString = (String)jsonString + move.getJSONObject("startPoint").getDouble("lat");
                jsonString = (String)jsonString + ",\"lng\":";
                jsonString = (String)jsonString + move.getJSONObject("startPoint").getDouble("lng");
                jsonString = (String)jsonString + "}";
                travel.put((Object)new JSONObject((String)jsonString));
            }
            String destinationString = "{\"lat\":" + destination.getPoint().getLatitude() + ",\"lng\":" + destination.getPoint().getLongitude() + "}";
            travel.put((Object)new JSONObject(destinationString));
            GJaxbRoute route = new GJaxbRoute();
            GJaxbLeg leg = new GJaxbLeg();
            leg.setDuration(Double.parseDouble(jsonAPI.getJSONObject("route").get("time").toString()));
            leg.setDistance(1000.0 * Double.parseDouble(jsonAPI.getJSONObject("route").get("distance").toString()));
            route.getLeg().add(leg);
            route.setSummary(travel.toString());
            pair.getRoute().add(route);
        } else {
            LOG.warn("no route for " + departure.getName() + " -> " + destination.getName());
        }
        return pair;
    }
}

