/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.launcher;

import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.launcher.utils.CommandReader;
import fr.emac.gind.launcher.utils.Locker;
import fr.emac.gind.launcher.utils.SystemExitHook;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLauncher {
    private static Logger LOG = LoggerFactory.getLogger((String)AbstractLauncher.class.getName());
    private static final int BANNER_SIZE = 70;
    private static final String NO_CONSOLE = "noconsole";
    private static final String START_COMMAND = "start";
    private static final String SHUTDOWN_COMMAND = "shutdown";
    private static final String VERSION_COMMAND = "version";
    private Configuration conf = null;
    private static boolean useHook = true;
    private boolean isStarted = false;
    protected final Locker locker = new Locker(new File("."));
    protected SystemExitHook systemExitHook = new SystemExitHook(this.locker, this);
    protected CommandReader console = new CommandReader(this);

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setIsStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    protected void showBanner() {
        int size = 70;
        if (this.getName().length() > 70) {
            size = this.getName().length() + 70;
        }
        this.print("-", size);
        System.out.print("\n");
        System.out.print("|");
        this.print(" ", (size - 2 - this.getName().length()) / 2);
        System.out.print(this.getName());
        this.print(" ", (size - 2 - this.getName().length()) / 2);
        System.out.print("|");
        System.out.print("\n");
        this.print("-", size);
        System.out.print("\n");
        this.version();
    }

    private void print(String token, int size) {
        for (int i = 0; i < size; ++i) {
            System.out.print(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(String[] args) {
        this.isStarted = false;
        ArrayList<String> command = new ArrayList<String>();
        try {
            this.conf = new File(Configuration.CONFIG_PATH, "unified_config.properties").exists() ? new Configuration(new File(Configuration.CONFIG_PATH, "unified_config.properties").toURI().toURL()) : new Configuration(new File(Configuration.CONFIG_PATH, Configuration.CONFIG_NAME).toURI().toURL());
            if (this.conf == null) {
                throw new Exception("Impossible to find configuration file of component !!!");
            }
            LOG.info("Configuration detected at: " + String.valueOf(this.conf.getUrl()));
            boolean console = true;
            if (args == null || args.length == 0) {
                command.add(START_COMMAND);
            }
            if (args != null) {
                for (String arg : args) {
                    command.add(arg);
                    if (!NO_CONSOLE.equals(arg)) continue;
                    console = false;
                }
            }
            if (command.contains(SHUTDOWN_COMMAND)) {
                this.setIsStarted(false);
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                this.start();
                this.setIsStarted(true);
                if (console) {
                    this.console.read();
                } else {
                    while (this.isStarted()) {
                        try {
                            Thread.sleep(600000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                this.printUsage();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                br.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            this.shutdown();
        }
    }

    public void start() throws Exception {
        if (useHook) {
            if (this.locker.isLocked()) {
                throw new Exception("Can not start server, remove lock file from root path or stop server");
            }
            this.locker.lock();
        }
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
        String host = this.conf.getHost();
        if (host == null) {
            throw new Exception("Wrong host parameter!!!");
        }
        this.startRunner(this.conf);
        this.showBanner();
        if (useHook) {
            this.systemExitHook.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractLauncher.this.locker.isLocked()) {
                        try {
                            AbstractLauncher.this.shutdown();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            System.exit(-1);
                        }
                    }
                }
            }, 0L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void shutdown() {
        SystemExitHook.systemexist = true;
        this.systemExitHook.run();
    }

    public void version() {
    }

    protected void printUsage() {
        System.out.println(" -start                  start " + this.getName());
        System.out.println(" -shutdowm               shutdown " + this.getName());
        System.out.println(" -version                get " + this.getName() + " version");
    }

    public CommandReader getConsole() {
        return this.console;
    }

    protected void printSpecificStartMessage() {
    }

    public abstract void startRunner(Configuration var1) throws Exception;

    public abstract void stopRunner() throws Exception;

    public abstract String getName();

    public abstract String getPromptName();

    public abstract String getInfo();

    public boolean interpret(String command) {
        return false;
    }

    public static void setUseHook(boolean useHook) {
        AbstractLauncher.useHook = useHook;
    }
}

