/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.launcher;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    public static ModeType MODE = ModeType.PROD;
    public static Boolean PYTHON_ACTIVATED = false;
    private static Logger LOG = LoggerFactory.getLogger((String)Configuration.class.getName());
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();
    public static String CONFIG_PATH = "../conf/";
    public static String CONFIG_NAME = "config.properties";
    private URL url = null;

    public Configuration(URL url) throws Exception {
        this(Configuration.getConfiguationMap(url));
        this.url = url;
    }

    public boolean existConfig() throws Exception {
        return new File(this.url.toURI()).exists();
    }

    public Configuration(Map<String, String> data) throws Exception {
        this.properties = new HashMap<String, String>(data);
    }

    public URL getUrl() {
        return this.url;
    }

    public static Map<String, String> getConfiguationMap(URL url) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url == null) {
            throw new Exception("Url config cannot be null !!!");
        }
        Properties props = new Properties();
        props.load(url.openStream());
        for (Object k : props.keySet()) {
            map.put(k.toString().trim(), props.get(k).toString().trim());
        }
        return map;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getMapObjects() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.putAll(this.properties);
        return res;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Integer getPort() {
        return Integer.valueOf(this.getProperties().get("port"));
    }

    public String getHost() {
        return String.valueOf(this.getProperties().get("host"));
    }

    public String getVersion() {
        return String.valueOf(this.getProperties().get("version"));
    }

    public void setHost(String host) {
        this.properties.put("port", String.valueOf(host));
    }

    public void setPort(int port) {
        this.properties.put("host", String.valueOf(port));
    }

    public void setVersion(String version) {
        this.properties.put("version", String.valueOf(version));
    }

    public static enum ModeType {
        PROD,
        DEV;

    }
}

