/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.launcher;

import fr.emac.gind.launcher.AbstractLauncher;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Logger LOG;
    private static ServiceLoader<AbstractLauncher> launcherLoader;
    private static List<AbstractLauncher> launchers;
    private static List<Class<? extends AbstractLauncher>> launchersToIgnore;
    private static AbstractLauncher mainLauncher;

    public static void main(String[] args) throws Exception {
        LOG.info("Start application ...");
        System.setProperty("file.encoding", "UTF-8");
        launchers = Main.getLaunchers();
        mainLauncher = launchers.get(0);
        mainLauncher.launch(args);
        LOG.info("Application started");
    }

    public static void stop() throws Exception {
        mainLauncher.stopRunner();
        mainLauncher.setIsStarted(false);
    }

    public static List<AbstractLauncher> getLaunchers() {
        ArrayList<AbstractLauncher> launchers = new ArrayList<AbstractLauncher>();
        launcherLoader.reload();
        for (AbstractLauncher command : launcherLoader) {
            if (Main.contains(launchersToIgnore, command.getClass())) continue;
            LOG.info("Load launcher in class: " + String.valueOf(command.getClass()));
            launchers.add(command);
        }
        ArrayList<AbstractLauncher> validLaunchers = new ArrayList<AbstractLauncher>();
        for (AbstractLauncher launch : launchers) {
            if (Main.contains(launchersToIgnore, launch.getClass())) continue;
            LOG.info("Load launcher in class: " + String.valueOf(launch.getClass()));
            validLaunchers.add(launch);
        }
        launchers.clear();
        launchers.addAll(validLaunchers);
        if (launchers.size() > 1) {
            ArrayList<AbstractLauncher> launchertoRemove = new ArrayList<AbstractLauncher>();
            for (AbstractLauncher l1 : launchers) {
                for (AbstractLauncher l2 : launchers) {
                    if (Main.isSubClass(l1, l2)) {
                        launchertoRemove.add(l2);
                    }
                    if (!Main.isSubClass(l2, l1)) continue;
                    launchertoRemove.add(l1);
                }
            }
            for (AbstractLauncher l1 : launchertoRemove) {
                launchers.remove(l1);
            }
        }
        assert (launchers.size() != 0) : "No launcher found";
        assert (launchers.size() == 1) : "Several launchers found: " + String.valueOf(launchers);
        return launchers;
    }

    private static boolean contains(List<Class<? extends AbstractLauncher>> launchersToIgnore, Class<? extends AbstractLauncher> clazz) {
        for (Class<? extends AbstractLauncher> launch : launchersToIgnore) {
            if (!launch.getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubClass(AbstractLauncher l1, AbstractLauncher l2) {
        try {
            if (!l1.getClass().equals(l2.getClass()) && l1.getClass().asSubclass(l2.getClass()) != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void addLauncherToIgnore(Class<? extends AbstractLauncher> clazz) {
        launchersToIgnore.add(clazz);
    }

    public static boolean isStarted() {
        if (mainLauncher == null) {
            return false;
        }
        return mainLauncher.isStarted();
    }

    static {
        System.setProperty("logback.configurationFile", "../conf/logback.xml");
        LOG = LoggerFactory.getLogger((String)Main.class.getName());
        launcherLoader = ServiceLoader.load(AbstractLauncher.class);
        launchers = new ArrayList<AbstractLauncher>();
        launchersToIgnore = new ArrayList<Class<? extends AbstractLauncher>>();
        mainLauncher = null;
    }
}

