/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.emac.gind.commons.utils.xml.UniversalNamespaceContextResolver;
import fr.emac.gind.marshaller.AbstractManager;
import fr.emac.gind.marshaller.query.JaxbXPathEvaluator;
import fr.emac.gind.marshaller.query.JaxbXQueryEvaluator;
import fr.emac.gind.marshaller.query.XQueryExpressionException;
import jakarta.xml.bind.Binder;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlTransient
@XmlAccessorType(value=XmlAccessType.NONE)
public class AbstractJaxbObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private transient URI baseURI = null;
    @JsonIgnore
    private transient Binder<Node> binder = null;
    @JsonIgnore
    private transient JAXBElement<?> jaxbElement = null;
    @JsonIgnore
    private transient Object naturalParent = null;
    @JsonIgnore
    private transient Object adoptiveParent;
    @JsonIgnore
    private transient NamespaceContext namespaceContext = null;
    @JsonIgnore
    private transient Map<String, Object> userData;
    @JsonIgnore
    private transient List<String> userDataKeysUsed = new ArrayList<String>();

    public void setUserData(String key, Object data) {
        if (this.getDOMNode() != null) {
            this.getDOMNode().setUserData(key, data, null);
            if (data != null && !this.userDataKeysUsed.contains(key)) {
                this.userDataKeysUsed.add(key);
            } else {
                this.userDataKeysUsed.remove(key);
            }
        } else {
            if (this.userData == null) {
                this.userData = new HashMap<String, Object>();
            }
            this.userData.put(key, data);
        }
    }

    public Object getUserData(String key) {
        if (this.getDOMNode() != null) {
            return this.getDOMNode().getUserData(key);
        }
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    public Map<String, Object> getMapUserData() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (this.getDOMNode() != null) {
            for (String key : this.userDataKeysUsed) {
                res.put(key, this.getDOMNode().getUserData(key));
            }
        }
        if (this.userData != null && !this.userData.isEmpty()) {
            res.putAll(this.userData);
        }
        return res;
    }

    public void clearMapUserData() {
        if (this.getDOMNode() != null) {
            for (String key : this.userDataKeysUsed) {
                this.setUserData(key, null);
            }
        }
        if (this.userData != null && !this.userData.isEmpty()) {
            this.userData.clear();
        }
    }

    public void setMapUserData(Map<String, Object> map) {
        if (this.getDOMNode() != null) {
            map.forEach((k, v) -> this.setUserData((String)k, v));
        } else {
            if (this.userData == null) {
                this.userData = new HashMap<String, Object>();
            }
            this.userData.putAll(map);
        }
    }

    public URI getBaseURI() {
        URI uri = null;
        for (AbstractJaxbObject current = this; current != null; current = current.getNaturalParent()) {
            uri = current.baseURI;
            if (uri == null) continue;
            return uri;
        }
        return uri;
    }

    public final Binder<Node> getBinder() {
        return this.binder;
    }

    final JAXBElement<?> getJAXBElement() {
        return this.jaxbElement;
    }

    public NamespaceContext getNamespaceContext() {
        if (this.isTheTopParent()) {
            if (this.namespaceContext == null && this.getDOMNode() != null) {
                this.namespaceContext = new UniversalNamespaceContextResolver(this.getDOMNode().getOwnerDocument());
            }
            return this.namespaceContext;
        }
        return this.findTopParent().getNamespaceContext();
    }

    @JsonIgnore
    public AbstractJaxbObject findTopParent() {
        if (this.isTheTopParent()) {
            return this;
        }
        AbstractJaxbObject parent = null;
        for (AbstractJaxbObject current = this.getNaturalParent(); current != null; current = current.getNaturalParent()) {
            parent = current;
        }
        return parent;
    }

    @JsonIgnore
    public boolean isTheTopParent() {
        return this.getNaturalParent() == null;
    }

    @JsonIgnore
    public AbstractJaxbObject findParent(QName parentQName) {
        if (this.isTheTopParent()) {
            return null;
        }
        AbstractJaxbObject parent = null;
        for (AbstractJaxbObject current = this.getNaturalParent(); current != null; current = current.getNaturalParent()) {
            if (current.getQName().equals(parentQName)) {
                return current;
            }
            parent = current;
        }
        return parent;
    }

    public final AbstractJaxbObject getNaturalParent() {
        Node parent;
        if (this.getDOMNode() != null && (parent = this.getDOMNode().getParentNode()) != null) {
            return (AbstractJaxbObject)parent.getUserData("jaxb");
        }
        return null;
    }

    public final AbstractJaxbObject getAdoptiveParent() {
        if (this.adoptiveParent instanceof JAXBElement) {
            return (AbstractJaxbObject)((JAXBElement)this.adoptiveParent).getValue();
        }
        return (AbstractJaxbObject)this.adoptiveParent;
    }

    final QName getQName() {
        if (this.getClass().isAnnotationPresent(XmlRootElement.class)) {
            String namespaceURI = this.getClass().getPackage().getAnnotation(XmlSchema.class).namespace();
            return new QName(namespaceURI, this.getClass().getAnnotation(XmlRootElement.class).name());
        }
        if (this.jaxbElement != null) {
            return this.jaxbElement.getName();
        }
        if (this.binder != null) {
            Node node = (Node)this.binder.getXMLNode((Object)this);
            assert (node instanceof Element);
            if (node.getPrefix() == null) {
                return new QName(node.getNamespaceURI(), node.getLocalName());
            }
            return new QName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
        }
        return null;
    }

    public void setBaseURI(URI baseUri) {
        this.baseURI = baseUri;
    }

    @JsonIgnore
    public final Node getDOMNode() {
        Node node = null;
        if (this.getBinder() != null) {
            node = (Node)this.binder.getXMLNode((Object)this);
        }
        return node;
    }

    public final void setBinder(Binder<Node> binder) {
        this.binder = binder;
    }

    public final void setJaxbElement(JAXBElement<?> jaxbElement) {
        this.jaxbElement = jaxbElement;
    }

    public final void setNaturalParent(Object naturalParent) {
        this.naturalParent = naturalParent;
    }

    public final void setAdoptiveParent(AbstractJaxbObject adoptiveParent) {
        this.adoptiveParent = adoptiveParent;
    }

    public String findTargetNamespace() {
        String res = null;
        AbstractJaxbObject parent = this.findTopParent();
        res = parent.getDOMNode().getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        return res;
    }

    public <X extends AbstractJaxbObject> X[] xpathQuery(String xpathStr, Class<X> resultInterfaceClass, NamespaceContext context, AbstractManager<?> manager) throws XPathExpressionException {
        JaxbXPathEvaluator eval = new JaxbXPathEvaluator();
        return eval.selectJaxbObjectNodes(this, xpathStr, resultInterfaceClass, context, manager);
    }

    public <X extends AbstractJaxbObject> X[] xqueryQuery(String xpathStr, Class<X> resultInterfaceClass, NamespaceContext context, AbstractManager<?> manager) throws XQueryExpressionException {
        JaxbXQueryEvaluator eval = new JaxbXQueryEvaluator();
        return eval.selectJaxbObjectNodes(this, xpathStr, resultInterfaceClass, context, manager);
    }
}

