/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller.query;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.xml.UniversalNamespaceContextResolver;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.AbstractManager;
import fr.emac.gind.marshaller.query.QueryNamespaceContext;
import fr.emac.gind.marshaller.query.XPathExpressionException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathConstants;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.xpath.XPathEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class JaxbXPathEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbXPathEvaluator.class);
    private final Configuration configuration = new Configuration();

    public <X extends AbstractJaxbObject> X selectJaxbObjectNode(AbstractJaxbObject jaxbParent, String xpathStr, Class<X> resultInterfaceClass, NamespaceContext context, AbstractManager<?> manager) throws javax.xml.xpath.XPathExpressionException {
        LOG.trace("Executing XPath query '{}'.", (Object)xpathStr);
        XPathEvaluator eval = new XPathEvaluator(this.configuration);
        eval.setNamespaceContext(context);
        try {
            if (jaxbParent != null && jaxbParent.getDOMNode() != null) {
                LOG.trace("Source document:\n {}", (Object)XMLPrettyPrinter.print((Node)jaxbParent.getDOMNode()));
            }
            ArrayList<AbstractJaxbObject> sources = new ArrayList<AbstractJaxbObject>();
            sources.addAll(Arrays.asList(manager.getAdoptedChildren()));
            List<?> models = manager.getModels();
            sources.addAll(models);
            for (AbstractJaxbObject source : sources) {
                Object result;
                if (source == null || source.getDOMNode() == null || !((result = eval.evaluate(xpathStr, (Object)source.getDOMNode(), XPathConstants.NODE)) instanceof Node)) continue;
                Node n = (Node)result;
                AbstractJaxbObject o = (AbstractJaxbObject)source.getBinder().getJAXBNode((Object)n);
                o.setBaseURI(source.getBaseURI());
                if (!resultInterfaceClass.isInstance(o)) {
                    throw new UncheckedException(String.format("XPath expression '%s' ne s\u00e9lectionne pas un unique n\u0153ud JAXB de type '%s'.", xpathStr, resultInterfaceClass.getName()));
                }
                LOG.trace("Executed XPath query successfully. 1 node found.");
                return (X)((AbstractJaxbObject)resultInterfaceClass.cast(o));
            }
            LOG.trace("Executed XPath query successfully. 0 node found.");
            return null;
        }
        catch (Exception jbe) {
            throw new UncheckedException("JAXB unmarshal error: " + jbe.getMessage(), (Throwable)jbe);
        }
    }

    public <X extends AbstractJaxbObject> X[] selectJaxbObjectNodes(AbstractJaxbObject jaxbParent, String xpathStr, Class<X> resultInterfaceClass, final NamespaceContext context, AbstractManager<?> manager) {
        ArrayList<AbstractJaxbObject> listResult = new ArrayList<AbstractJaxbObject>();
        try {
            XPathEvaluator eval = new XPathEvaluator(this.configuration);
            eval.setNamespaceContext(context);
            HashSet<AbstractJaxbObject> sources = new HashSet<AbstractJaxbObject>();
            sources.addAll(Arrays.asList(manager.getAdoptedChildren()));
            sources.addAll(manager.getModels());
            for (final AbstractJaxbObject source : sources) {
                if (source == null) {
                    throw new Exception("Source cannot be null!!!");
                }
                if (source.getDOMNode() != null) {
                    NamespaceResolver resolver = new NamespaceResolver(){
                        UniversalNamespaceContextResolver domResolver;
                        {
                            this.domResolver = new UniversalNamespaceContextResolver(source.getDOMNode().getOwnerDocument());
                        }

                        public Iterator<String> iteratePrefixes() {
                            return ((QueryNamespaceContext)context).iteratePrefixes();
                        }

                        public String getURIForPrefix(String prefix, boolean useDefault) {
                            String res = context.getNamespaceURI(prefix);
                            if (res == null) {
                                res = this.domResolver.getNamespaceURI(prefix);
                            }
                            return res;
                        }
                    };
                    StringConverter.StringToQName converterStringToQName = (StringConverter.StringToQName)this.configuration.getConversionRules().getConverter((AtomicType)BuiltInAtomicType.STRING, (AtomicType)BuiltInAtomicType.QNAME);
                    converterStringToQName.setNamespaceResolver(resolver);
                    StringConverter.StringToQName converterUntypedToQName = (StringConverter.StringToQName)this.configuration.getConversionRules().getConverter((AtomicType)BuiltInAtomicType.UNTYPED_ATOMIC, (AtomicType)BuiltInAtomicType.QNAME);
                    converterUntypedToQName.setNamespaceResolver(resolver);
                    LOG.trace("Executing XPath query '{}' on source '{}'.", (Object)xpathStr, (Object)source.getDOMNode().getNodeName());
                    Object result = eval.evaluate(xpathStr, (Object)source.getDOMNode(), XPathConstants.NODESET);
                    if (!(result instanceof DOMNodeList)) continue;
                    DOMNodeList list = (DOMNodeList)result;
                    for (int i = 0; i < list.getLength(); ++i) {
                        AbstractJaxbObject casted;
                        Node n = list.item(i);
                        AbstractJaxbObject o = (AbstractJaxbObject)source.getBinder().getJAXBNode((Object)n);
                        o.setBaseURI(source.getBaseURI());
                        if (o == null || !resultInterfaceClass.isInstance(o) || listResult.contains(casted = (AbstractJaxbObject)resultInterfaceClass.cast(o))) continue;
                        listResult.add(casted);
                    }
                    continue;
                }
                LOG.trace("No source node!!!");
            }
            LOG.trace("Executed XPath query successfully. {} node(s) found.", (Object)listResult.size());
        }
        catch (Exception e) {
            throw new XPathExpressionException(e);
        }
        return listResult.toArray((AbstractJaxbObject[])Array.newInstance(resultInterfaceClass, listResult.size()));
    }
}

