/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller.xml;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.JaxbNamespacePrefixMapperWithDOM;
import fr.emac.gind.marshaller.JaxbNamespacePrefixMapperWithoutDOM;
import fr.emac.gind.marshaller.SPIJaxbObjectFactory;
import jakarta.xml.bind.Binder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import javax.xml.validation.SchemaFactory;
import org.glassfish.jaxb.runtime.v2.runtime.AssociationMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLJAXBContext {
    private static Logger LOG = LoggerFactory.getLogger((String)XMLJAXBContext.class.getName());
    public static String W3C_XML_SCHEMA_INSTANCE_NS_URI = "http://www.w3.org/2001/XMLSchema";
    protected JAXBContext jaxbContext = null;
    protected List<Class<?>> currentObjectFactories = new ArrayList();
    protected ServiceLoader<SPIJaxbObjectFactory> objectFactoryLoader = ServiceLoader.load(SPIJaxbObjectFactory.class);
    protected static XMLJAXBContext INSTANCE = null;
    protected ThreadLocal<Marshaller> marshaller = new ThreadLocal<Marshaller>(){

        @Override
        protected Marshaller initialValue() {
            Marshaller marshaller = null;
            try {
                marshaller = XMLJAXBContext.this.jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
            catch (JAXBException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return marshaller;
        }
    };

    protected XMLJAXBContext() throws RuntimeException {
        SchemaFactory.newInstance(W3C_XML_SCHEMA_INSTANCE_NS_URI);
        try {
            this.currentObjectFactories.clear();
            this.objectFactoryLoader.reload();
            Iterator<SPIJaxbObjectFactory> it = this.objectFactoryLoader.iterator();
            while (it.hasNext()) {
                try {
                    SPIJaxbObjectFactory spi = it.next();
                    LOG.debug("Load SPI ObjectFactory: {}", (Object)spi.getClass().getName());
                    this.currentObjectFactories.add(spi.getClass());
                }
                catch (Throwable e) {
                    LOG.warn("SPI load failed: {}", (Object)e.getMessage());
                }
            }
            LinkedHashSet bound = new LinkedHashSet();
            for (Class<?> spiClass : this.currentObjectFactories) {
                Class<?> of = XMLJAXBContext.resolveGeneratedObjectFactory(spiClass);
                if (of != null) {
                    LOG.debug("Registered generated ObjectFactory: {}", (Object)of.getName());
                    bound.add(of);
                    continue;
                }
                LOG.warn("No generated ObjectFactory super-class found for SPI {}. Falling back to SPI class itself.", (Object)spiClass.getName());
                bound.add(spiClass);
            }
            if (bound.isEmpty()) {
                throw new IllegalStateException("No generated ObjectFactory discovered from SPI implementations. Ensure your SPI classes extend the XJC-generated ObjectFactory.");
            }
            this.jaxbContext = JAXBContext.newInstance((Class[])bound.toArray(new Class[bound.size()]));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> resolveGeneratedObjectFactory(Class<?> spiClass) {
        for (Class<?> c = spiClass; c != null && c != Object.class; c = c.getSuperclass()) {
            if (!"ObjectFactory".equals(c.getSimpleName())) continue;
            return c;
        }
        return null;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public static XMLJAXBContext getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = new XMLJAXBContext();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return INSTANCE;
    }

    public void clear() {
        INSTANCE = null;
        this.jaxbContext = null;
        System.gc();
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public <T extends AbstractJaxbObject> T unmarshallDocument(URL url, Class<T> clazz) throws Exception {
        T jaxbObj = null;
        Document doc = null;
        try {
            assert (url != null);
            InputSource is = new InputSource(url.openStream());
            if (is.getSystemId() == null) {
                is.setSystemId(url.toString());
            }
            doc = DOMUtil.getInstance().parse(is);
            jaxbObj = this.unmarshallDocument(doc, clazz);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return jaxbObj;
    }

    public <T extends AbstractJaxbObject> T unmarshallDocument(Document doc, Class<T> clazz) throws Exception {
        try {
            Binder binder = this.jaxbContext.createBinder();
            JAXBElement rootElt = binder.unmarshal((Object)doc.getDocumentElement(), clazz);
            AbstractJaxbObject root = (AbstractJaxbObject)rootElt.getValue();
            root.setBinder((Binder<Node>)binder);
            doc.getDocumentElement().setUserData("binder", binder, null);
            if (doc.getBaseURI() != null) {
                root.setBaseURI(URI.create(doc.getBaseURI()));
            }
            AssociationMap assoc = (AssociationMap)ReflectionHelper.getPrivateFieldValue(binder.getClass(), (Object)binder, (String)"assoc");
            Map byElement = (Map)ReflectionHelper.getPrivateFieldValue(assoc.getClass(), (Object)assoc, (String)"byElement");
            for (Map.Entry e : byElement.entrySet()) {
                Node n = (Node)((AssociationMap.Entry)e.getValue()).element();
                n.setUserData("binder", binder, null);
                AbstractJaxbObject obj = (AbstractJaxbObject)((AssociationMap.Entry)e.getValue()).inner();
                if (obj == null) continue;
                obj.setBinder((Binder<Node>)binder);
                if (doc.getBaseURI() == null) continue;
                obj.setBaseURI(URI.create(doc.getBaseURI()));
            }
            return (T)root;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public <T extends AbstractJaxbObject> T unmarshallDocument(Node doc) throws Exception {
        try {
            Binder binder = this.jaxbContext.createBinder();
            Object rootElt = binder.unmarshal((Object)doc);
            AbstractJaxbObject root = null;
            root = rootElt instanceof JAXBElement ? (AbstractJaxbObject)((JAXBElement)rootElt).getValue() : (AbstractJaxbObject)rootElt;
            root.setBinder((Binder<Node>)binder);
            doc.setUserData("binder", binder, null);
            if (doc.getBaseURI() != null) {
                root.setBaseURI(URI.create(doc.getBaseURI()));
            }
            AssociationMap assoc = (AssociationMap)ReflectionHelper.getPrivateFieldValue(binder.getClass(), (Object)binder, (String)"assoc");
            Map byElement = (Map)ReflectionHelper.getPrivateFieldValue(assoc.getClass(), (Object)assoc, (String)"byElement");
            for (Map.Entry e : byElement.entrySet()) {
                Node n = (Node)((AssociationMap.Entry)e.getValue()).element();
                n.setUserData("binder", binder, null);
                AbstractJaxbObject obj = (AbstractJaxbObject)((AssociationMap.Entry)e.getValue()).inner();
                obj.setBinder((Binder<Node>)binder);
                if (doc.getBaseURI() == null) continue;
                obj.setBaseURI(URI.create(doc.getBaseURI()));
            }
            return (T)root;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public <E extends AbstractJaxbObject> Document marshallAnyType(QName tag, E jaxbElmt, Class<E> clazz) throws Exception {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().newDocument();
            JAXBElement element = new JAXBElement(tag, clazz, jaxbElmt);
            Marshaller marshall = this.marshaller.get();
            if (jaxbElmt.getDOMNode() != null) {
                marshall.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)new JaxbNamespacePrefixMapperWithDOM(jaxbElmt.getNamespaceContext()));
            } else {
                marshall.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)new JaxbNamespacePrefixMapperWithoutDOM());
            }
            marshall.marshal((Object)element, (Node)doc);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return doc;
    }

    public Document marshallAnyElement(AbstractJaxbObject jaxbElmt) throws Exception {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().newDocument();
            Marshaller marshall = this.marshaller.get();
            if (jaxbElmt.getDOMNode() != null) {
                marshall.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)new JaxbNamespacePrefixMapperWithDOM(jaxbElmt.getNamespaceContext()));
            } else {
                marshall.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)new JaxbNamespacePrefixMapperWithoutDOM());
            }
            marshall.marshal((Object)jaxbElmt, (Node)doc);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return doc;
    }

    public Document marshallAnyElement(JAXBElement<?> jaxbElmt) throws Exception {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().newDocument();
            Marshaller marshall = this.marshaller.get();
            marshall.marshal(jaxbElmt, (Node)doc);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return doc;
    }
}

