/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.marshaller;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.commons.utils.xml.resolver.URIMultipleResolvers;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.JaxbObjectAdopter;
import fr.emac.gind.marshaller.query.JaxbXPathEvaluator;
import fr.emac.gind.marshaller.query.JaxbXQueryEvaluator;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManager<M extends AbstractJaxbObject> {
    private static Logger LOG = LoggerFactory.getLogger((String)AbstractManager.class.getName());
    protected List<M> models = null;
    private JaxbObjectAdopter adopter = null;
    private Map<QName, Class<? extends AbstractJaxbObject>> jaxbSpecificImportResolver = null;
    protected URIResolver resolver = null;
    private Map<URI, AbstractJaxbObject> adoptedChildrenCache = null;
    protected AbstractManager<?> parentManager = null;
    protected JaxbXPathEvaluator eval = new JaxbXPathEvaluator();
    protected Mode mode = Mode.FULL;

    public AbstractManager(Mode mode, M ... models) throws Exception {
        this(mode, (URIResolver)new URIMultipleResolvers(), null, null, (AbstractJaxbObject[])models);
    }

    public AbstractManager(M ... models) throws Exception {
        this(Mode.FULL, (URIResolver)new URIMultipleResolvers(), null, null, (AbstractJaxbObject[])models);
    }

    public AbstractManager(Mode mode, URIResolver resolver, AbstractManager<?> parent, Map<QName, Class<? extends AbstractJaxbObject>> jaxbSpecificImportResolver, M ... models) throws Exception {
        this.mode = mode;
        this.resolver = resolver;
        this.parentManager = parent;
        this.adopter = new JaxbObjectAdopter(resolver, this.getTopParent());
        this.jaxbSpecificImportResolver = jaxbSpecificImportResolver;
        this.models = Arrays.asList(models);
        this.init();
    }

    public Map<QName, Class<? extends AbstractJaxbObject>> getJaxbSpecificImportResolver() {
        return this.jaxbSpecificImportResolver;
    }

    protected AbstractManager<?> getParent() {
        return this.parentManager;
    }

    public boolean isTopParent() {
        return this.getParent() == null;
    }

    public AbstractManager<?> getTopParent() {
        if (this.isTopParent()) {
            return this;
        }
        AbstractManager<?> parent = null;
        for (AbstractManager<?> current = this.getParent(); current != null; current = current.getParent()) {
            parent = current;
        }
        return parent;
    }

    public abstract void init() throws Exception;

    protected void addExternalChilds(Map<String, Class<? extends AbstractJaxbObject>> xpaths, String publicIdMethod, String systemIdMethod, NamespaceContext nscontext, Class<? extends AbstractJaxbObject> importedClazz) throws Exception {
        for (AbstractJaxbObject model : this.models) {
            if (model == null) {
                throw new Exception("Model cannot be null !!!");
            }
            if (model.getBaseURI() != null) {
                this.addAdoptedChildren(model.getBaseURI(), model.findTopParent());
            }
            if (this.mode != Mode.FULL) continue;
            this.addExternalChilds(model, xpaths, publicIdMethod, systemIdMethod, nscontext, importedClazz, new HashMap<QName, AbstractJaxbObject>());
        }
    }

    private synchronized void addExternalChilds(AbstractJaxbObject model, Map<String, Class<? extends AbstractJaxbObject>> xpaths, String publicIdMethod, String systemIdMethod, NamespaceContext nscontext, Class<? extends AbstractJaxbObject> importedClazz, Map<QName, AbstractJaxbObject> cacheImportModel) throws Exception {
        try {
            LOG.debug("add child: " + String.valueOf(model.getQName()));
            for (Map.Entry<String, Class<? extends AbstractJaxbObject>> xpath : xpaths.entrySet()) {
                AbstractJaxbObject[] impts;
                for (AbstractJaxbObject impt : impts = model.xpathQuery(xpath.getKey(), xpath.getValue(), nscontext, this.getTopParent())) {
                    AbstractJaxbObject importedModel;
                    Method publicIdM = ReflectionHelper.getDeclaredMethod(impt.getClass(), (String)publicIdMethod, (Class[])new Class[0]);
                    Method systemIdM = ReflectionHelper.getDeclaredMethod(impt.getClass(), (String)systemIdMethod, (Class[])new Class[0]);
                    if (this.adopter.isAlreadyAdopted(impt, (String)publicIdM.invoke((Object)impt, new Object[0]), (String)systemIdM.invoke((Object)impt, new Object[0])) || cacheImportModel.get((importedModel = this.adopter.adoptChild(impt, (String)publicIdM.invoke((Object)impt, new Object[0]), (String)systemIdM.invoke((Object)impt, new Object[0]), importedClazz)).getQName()) != null) continue;
                    cacheImportModel.put(importedModel.getQName(), importedModel);
                    this.addExternalChilds(importedModel, xpaths, publicIdMethod, systemIdMethod, nscontext, importedClazz, cacheImportModel);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public <X extends AbstractJaxbObject> X[] xpathQuery(String xpathStr, Class<X> resultInterfaceClass, NamespaceContext context) {
        ArrayList<AbstractJaxbObject> listResult = new ArrayList<AbstractJaxbObject>();
        for (AbstractJaxbObject model : this.models) {
            List<AbstractJaxbObject> temp = Arrays.asList(this.eval.selectJaxbObjectNodes(model, xpathStr, resultInterfaceClass, context, this.getTopParent()));
            for (AbstractJaxbObject t : temp) {
                if (listResult.contains(t)) continue;
                listResult.add(t);
            }
        }
        return listResult.toArray((AbstractJaxbObject[])Array.newInstance(resultInterfaceClass, listResult.size()));
    }

    public <X extends AbstractJaxbObject> X[] xqueryQuery(String xpathStr, Class<X> resultInterfaceClass, NamespaceContext context) {
        JaxbXQueryEvaluator eval = new JaxbXQueryEvaluator();
        ArrayList<AbstractJaxbObject> listResult = new ArrayList<AbstractJaxbObject>();
        for (AbstractJaxbObject model : this.models) {
            List<AbstractJaxbObject> temp = Arrays.asList(eval.selectJaxbObjectNodes(model, xpathStr, resultInterfaceClass, context, this.getTopParent()));
            for (AbstractJaxbObject t : temp) {
                if (listResult.contains(t)) continue;
                listResult.add(t);
            }
        }
        return listResult.toArray((AbstractJaxbObject[])Array.newInstance(resultInterfaceClass, listResult.size()));
    }

    private Map<URI, AbstractJaxbObject> getAdoptedChildrenCache() {
        if (this.isTopParent()) {
            if (this.adoptedChildrenCache == null) {
                this.adoptedChildrenCache = Collections.synchronizedMap(new HashMap());
            }
            return this.adoptedChildrenCache;
        }
        return this.getTopParent().getAdoptedChildrenCache();
    }

    public List<M> getModels() {
        return this.models;
    }

    public AbstractJaxbObject getChild(URI ns) {
        return this.getAdoptedChildrenCache().get(ns);
    }

    public AbstractJaxbObject[] getAdoptedChildren() {
        return this.getAdoptedChildrenCache().values().toArray(new AbstractJaxbObject[this.getAdoptedChildrenCache().values().size()]);
    }

    public void addAdoptedChildren(URI ns, AbstractJaxbObject jaxbObject) {
        this.getAdoptedChildrenCache().put(ns, jaxbObject);
    }

    public String getInfos() {
        Object res = "";
        for (URI jaxb : this.getAdoptedChildrenCache().keySet()) {
            try {
                res = (String)res + jaxb.getPath().substring(jaxb.getPath().lastIndexOf("/") + 1, jaxb.getPath().length()) + "\n";
            }
            catch (Exception e) {
                res = (String)res + e.getMessage() + "\n";
            }
        }
        if (!((String)(res = (String)res + "\n")).startsWith("List of resources: \n")) {
            res = "List of resources: \n" + (String)res;
        }
        return res;
    }

    public static enum Mode {
        FULL,
        LAZY;

    }
}

