/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.utils.plugin;

import fr.emac.gind.rio.utils.plugin.AbstractXsdToCodeMojo;
import fr.emac.gind.rio.utils.plugin.ClassBO;
import fr.emac.gind.rio.utils.plugin.EnumBO;
import fr.emac.gind.rio.utils.plugin.FieldBO;
import fr.emac.gind.rio.utils.plugin.JavaSourceExtractor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-cs", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class XsdToCSharpMojo
extends AbstractXsdToCodeMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/cs")
    protected File outputDirectory;

    @Override
    public String getCodeExtensionFileName() {
        return "cs";
    }

    @Override
    public File getCodeOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void generateCodeImport(List<String> csImports, String fileName, String keyWord) {
    }

    @Override
    protected void additionalHeaderCode(StringBuilder sb, String xsdShortName) {
        sb.append("// *** Fichier g\u00e9n\u00e9r\u00e9 automatiquement \u2014 source: ").append(xsdShortName).append(" ***\n").append("using System;\n").append("using System.Collections.Generic;\n").append("using System.Runtime.Serialization;\n").append("\n");
    }

    @Override
    protected void convertJavaClassToCode(StringBuilder sb, ClassBO classBO) {
        this.convertJavaClassToCSharp(sb, classBO);
    }

    @Override
    protected void convertEnumToCode(StringBuilder sb, EnumBO enum_) {
        this.convertEnumToCSharp(sb, enum_);
    }

    private void convertJavaClassToCSharp(StringBuilder cs, ClassBO classBO) {
        StringBuilder classBuilder = new StringBuilder();
        String className = classBO.className;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(className)) {
            className = JavaSourceExtractor.mappingForbidenClassNames.get(className);
        }
        String safeClassName = this.sanitizeCodeIdentifier(className);
        String csParent = null;
        if (classBO.parentClassName != null && !classBO.parentClassName.isBlank()) {
            csParent = this.parentCsName(classBO.parentClassName);
        }
        this.appendCsClassHeader(classBuilder, safeClassName, csParent);
        for (Map.Entry<String, FieldBO> fieldEntry : classBO.fields.entrySet()) {
            FieldBO field = fieldEntry.getValue();
            String propName = this.sanitizeCodeIdentifier(field.name);
            String csType = this.mapTypeToCSharp(field.type, field, classBO);
            classBuilder.append("    public ").append(csType).append(" ").append(propName).append(" { get; set; }\n");
        }
        classBuilder.append("}\n\n");
        if (classBO.innerClasses != null) {
            for (ClassBO inner : classBO.innerClasses) {
                inner.javaFileBO = classBO.javaFileBO;
                this.convertJavaClassToCSharp(cs, inner);
            }
        }
        cs.append((CharSequence)classBuilder);
    }

    private void appendCsClassHeader(StringBuilder out, String name, String parent) {
        if (parent != null && !parent.isBlank()) {
            out.append("public class ").append(name).append(" : ").append(parent).append("\n{\n");
        } else {
            out.append("public class ").append(name).append("\n{\n");
        }
    }

    private String mapTypeToCSharp(String javaType, FieldBO fieldBO, ClassBO class_) {
        if (javaType == null || javaType.isBlank()) {
            return "object?";
        }
        String t = javaType.trim();
        t = t.replace(class_.javaFileBO.packageName + ".", "");
        for (String otherPackageName : class_.javaFileBO.otherPossiblePackageNames) {
            t = t.replace(otherPackageName + ".", "");
        }
        switch (t) {
            case "byte": 
            case "Byte": 
            case "java.lang.Byte": {
                return "byte?";
            }
            case "short": 
            case "Short": 
            case "java.lang.Short": {
                return "short?";
            }
            case "int": 
            case "Integer": 
            case "java.lang.Integer": {
                return "int?";
            }
            case "long": 
            case "Long": 
            case "java.lang.Long": {
                return "long?";
            }
            case "float": 
            case "Float": 
            case "java.lang.Float": {
                return "float?";
            }
            case "double": 
            case "Double": 
            case "java.lang.Double": {
                return "double?";
            }
            case "BigInteger": 
            case "java.math.BigInteger": {
                return "long?";
            }
            case "boolean": 
            case "Boolean": 
            case "java.lang.Boolean": {
                return "bool?";
            }
            case "char": 
            case "Character": 
            case "java.lang.Character": {
                return "char?";
            }
            case "String": 
            case "java.lang.String": 
            case "QName": 
            case "DataHandler": {
                return "string?";
            }
            case "LocalDate": 
            case "LocalDateTime": 
            case "Date": 
            case "java.time.LocalDate": 
            case "java.time.LocalDateTime": 
            case "java.util.Date": 
            case "XMLGregorianCalendar": 
            case "javax.xml.datatype.XMLGregorianCalendar": {
                return "DateTime?";
            }
            case "java.lang.Object": 
            case "Object": {
                return "object?";
            }
        }
        if (t.startsWith("List<")) {
            String inner = t.substring("List<".length(), t.length() - ">".length());
            String listType = this.mapTypeToCSharp(inner, fieldBO, class_);
            return "List<" + this.stripNullUnion(listType) + ">?";
        }
        if (t.startsWith("Map<")) {
            String[] inners = t.substring("Map<".length(), t.length() - ">".length()).split(",");
            String k = this.mapTypeToCSharp(inners[0].trim(), fieldBO, class_);
            String v = this.mapTypeToCSharp(inners[1].trim(), fieldBO, class_);
            return "Dictionary<" + this.stripNullUnion(k) + ", " + this.stripNullUnion(v) + ">?";
        }
        if (t.startsWith("JAXBElement<")) {
            String inner = t.substring("JAXBElement<".length(), t.length() - 1);
            String mapped = this.mapTypeToCSharp(inner, fieldBO, class_);
            return mapped;
        }
        if (t.endsWith("[]")) {
            String inner = t.substring(0, t.length() - 2);
            String subType = this.mapTypeToCSharp(inner, fieldBO, class_);
            return this.stripNullUnion(subType) + "[]?";
        }
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(t)) {
            return JavaSourceExtractor.mappingForbidenClassNames.get(t) + "?";
        }
        if (t.contains(".")) {
            String[] parts = t.split("\\.");
            StringBuilder newType = new StringBuilder();
            for (String p : parts) {
                if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(p)) {
                    newType.append(JavaSourceExtractor.mappingForbidenClassNames.get(p));
                } else {
                    newType.append(p);
                }
                newType.append("_");
            }
            String name = newType.substring(0, newType.length() - 1);
            return this.sanitizeCodeIdentifier(name) + "?";
        }
        return this.sanitizeCodeIdentifier(t) + "?";
    }

    private String stripNullUnion(String mapped) {
        if (mapped == null) {
            return "object";
        }
        String m = mapped.trim();
        if (m.endsWith("?")) {
            return m.substring(0, m.length() - 1);
        }
        return m;
    }

    private String parentCsName(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        String parent = raw;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(parent)) {
            parent = JavaSourceExtractor.mappingForbidenClassNames.get(parent);
        }
        return this.sanitizeCodeIdentifier(parent);
    }

    private String convertEnumToCSharp(StringBuilder cs, EnumBO enum_) {
        StringBuilder csEnum = new StringBuilder();
        List<String> lines = Arrays.asList(enum_.enumBlockCode.split("\n"));
        String enumName = null;
        ArrayList<String[]> entries = new ArrayList<String[]>();
        Pattern enumStart = Pattern.compile("enum\\s+(\\w+)");
        Pattern valueEnumPattern = Pattern.compile("^(\\w+)\\s*\\(\\s*\"([^\"]+)\"\\s*\\)\\s*,?;?");
        Pattern simpleEnumPattern = Pattern.compile("^\\s*(\\w+)\\s*,?;?\\s*$");
        for (String raw : lines) {
            String name;
            Matcher simpleMatcher;
            Matcher m;
            String line = raw.trim();
            if (line.startsWith("@")) continue;
            if (enumName == null && (m = enumStart.matcher(line)).find()) {
                enumName = m.group(1);
                continue;
            }
            Matcher valueMatcher = valueEnumPattern.matcher(line);
            if (valueMatcher.find()) {
                String name2 = valueMatcher.group(1);
                String value = valueMatcher.group(2);
                if (name2.equals("value") || name2.equals("fromValue")) continue;
                entries.add(new String[]{name2, value});
                continue;
            }
            if (line.contains("(") || !(simpleMatcher = simpleEnumPattern.matcher(line)).find() || (name = simpleMatcher.group(1)).equals("value") || name.equals("fromValue")) continue;
            entries.add(new String[]{name, null});
        }
        if (enumName == null || enumName.isBlank()) {
            return "";
        }
        String safeEnumName = this.sanitizeCodeIdentifier(enumName);
        boolean hasExplicit = entries.stream().anyMatch(e -> e[1] != null);
        if (hasExplicit) {
            csEnum.append("[DataContract]\n");
        }
        csEnum.append("public enum ").append(safeEnumName).append("\n{\n");
        for (int i = 0; i < entries.size(); ++i) {
            String name = this.sanitizeCodeIdentifier(((String[])entries.get(i))[0]);
            String val = ((String[])entries.get(i))[1];
            if (val != null) {
                csEnum.append("    [EnumMember(Value = \"").append(val).append("\")]\n");
            }
            csEnum.append("    ").append(name);
            if (i < entries.size() - 1) {
                csEnum.append(",");
            }
            csEnum.append("\n");
        }
        csEnum.append("}\n\n");
        csEnum.append("public static class ").append(safeEnumName).append("Extensions\n{\n").append("    public static ").append(safeEnumName).append(" Parse").append(safeEnumName).append("(string value)\n").append("    {\n").append("        if (value == null) throw new ArgumentNullException(nameof(value));\n");
        if (hasExplicit) {
            for (String[] e2 : entries) {
                String n = this.sanitizeCodeIdentifier(e2[0]);
                String v = e2[1] != null ? e2[1] : e2[0];
                csEnum.append("        if (string.Equals(value, \"").append(v).append("\", StringComparison.Ordinal)) return ").append(safeEnumName).append(".").append(n).append(";\n");
            }
        }
        csEnum.append("        if (Enum.TryParse<").append(safeEnumName).append(">(value, ignoreCase: true, out var parsed)) return parsed;\n").append("        throw new ArgumentException(\"Invalid ").append(safeEnumName).append(" value: \" + value, nameof(value));\n").append("    }\n}\n\n");
        cs.append((CharSequence)csEnum);
        return csEnum.toString();
    }
}

