/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.utils.plugin;

import fr.emac.gind.rio.utils.plugin.AbstractXsdToCodeMojo;
import fr.emac.gind.rio.utils.plugin.ClassBO;
import fr.emac.gind.rio.utils.plugin.EnumBO;
import fr.emac.gind.rio.utils.plugin.FieldBO;
import fr.emac.gind.rio.utils.plugin.JavaSourceExtractor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-py", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class XsdToPythonMojo
extends AbstractXsdToCodeMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/py")
    protected File outputDirectory;

    @Override
    public String getCodeExtensionFileName() {
        return "py";
    }

    @Override
    public File getCodeOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void generateCodeImport(List<String> pyImports, String fileName, String keyWord) {
        String module = fileName.replace("-", "_");
        String pyImport = "from . import " + module + " as " + keyWord;
        pyImports.add(pyImport);
    }

    @Override
    protected void additionalHeaderCode(StringBuilder sb, String xsdShortName) {
        sb.append("# *** Fichier g\u00e9n\u00e9r\u00e9 automatiquement \u2014 source: ").append(xsdShortName).append(" ***\n").append("from __future__ import annotations\n").append("from dataclasses import dataclass\n").append("from enum import Enum\n").append("from typing import Optional, List, Dict, Any\n").append("import datetime as _dt\n\n");
    }

    @Override
    protected void convertJavaClassToCode(StringBuilder sb, ClassBO classBO) {
        this.convertJavaClassToPython(sb, classBO);
    }

    @Override
    protected void convertEnumToCode(StringBuilder sb, EnumBO enum_) {
        this.convertEnumToPython(sb, enum_);
    }

    private void convertJavaClassToPython(StringBuilder py, ClassBO classBO) {
        StringBuilder cls = new StringBuilder();
        String className = classBO.className;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(className)) {
            className = JavaSourceExtractor.mappingForbidenClassNames.get(className);
        }
        String safeClassName = this.sanitizeCodeIdentifier(className);
        String pyParent = null;
        if (classBO.parentClassName != null && !classBO.parentClassName.isBlank()) {
            pyParent = this.parentPyName(classBO.parentClassName);
        }
        cls.append("@dataclass\n");
        if (pyParent != null && !pyParent.isBlank()) {
            cls.append("class ").append(safeClassName).append("(").append(pyParent).append("):\n");
        } else {
            cls.append("class ").append(safeClassName).append(":\n");
        }
        if (classBO.fields == null || classBO.fields.isEmpty()) {
            cls.append("    pass\n\n");
        } else {
            for (Map.Entry entry : classBO.fields.entrySet()) {
                FieldBO field = (FieldBO)entry.getValue();
                String propName = this.sanitizeCodeIdentifier(field.name);
                String pyType = this.mapTypeToPython(field.type, field, classBO);
                cls.append("    ").append(propName).append(": ").append(pyType).append(" = None\n");
            }
            cls.append("\n");
        }
        if (classBO.innerClasses != null) {
            for (ClassBO classBO2 : classBO.innerClasses) {
                classBO2.javaFileBO = classBO.javaFileBO;
                this.convertJavaClassToPython(py, classBO2);
            }
        }
        py.append((CharSequence)cls);
    }

    private String parentPyName(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        String parent = raw;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(parent)) {
            parent = JavaSourceExtractor.mappingForbidenClassNames.get(parent);
        }
        return this.sanitizeCodeIdentifier(parent);
    }

    private String mapTypeToPython(String javaType, FieldBO fieldBO, ClassBO class_) {
        if (javaType == null || javaType.isBlank()) {
            return "Optional[Any]";
        }
        String t = javaType.trim();
        t = t.replace(class_.javaFileBO.packageName + ".", "");
        for (String otherPackageName : class_.javaFileBO.otherPossiblePackageNames) {
            t = t.replace(otherPackageName + ".", "");
        }
        switch (t) {
            case "byte": 
            case "Byte": 
            case "java.lang.Byte": 
            case "short": 
            case "Short": 
            case "java.lang.Short": 
            case "int": 
            case "Integer": 
            case "java.lang.Integer": 
            case "long": 
            case "Long": 
            case "java.lang.Long": 
            case "BigInteger": 
            case "java.math.BigInteger": {
                return "Optional[int]";
            }
            case "float": 
            case "Float": 
            case "java.lang.Float": 
            case "double": 
            case "Double": 
            case "java.lang.Double": {
                return "Optional[float]";
            }
            case "boolean": 
            case "Boolean": 
            case "java.lang.Boolean": {
                return "Optional[bool]";
            }
            case "char": 
            case "Character": 
            case "java.lang.Character": 
            case "String": 
            case "java.lang.String": 
            case "QName": 
            case "DataHandler": {
                return "Optional[str]";
            }
            case "LocalDate": 
            case "java.time.LocalDate": {
                return "Optional[_dt.date]";
            }
            case "LocalDateTime": 
            case "java.time.LocalDateTime": 
            case "Date": 
            case "java.util.Date": 
            case "XMLGregorianCalendar": 
            case "javax.xml.datatype.XMLGregorianCalendar": {
                return "Optional[_dt.datetime]";
            }
            case "java.lang.Object": 
            case "Object": {
                return "Optional[Any]";
            }
        }
        if (t.startsWith("List<")) {
            String inner = t.substring("List<".length(), t.length() - 1);
            String mapped = this.stripOptional(this.mapTypeToPython(inner, fieldBO, class_));
            return "Optional[List[" + mapped + "]]";
        }
        if (t.startsWith("Map<")) {
            String[] inners = t.substring("Map<".length(), t.length() - 1).split(",");
            String k = this.stripOptional(this.mapTypeToPython(inners[0].trim(), fieldBO, class_));
            String v = this.stripOptional(this.mapTypeToPython(inners[1].trim(), fieldBO, class_));
            return "Optional[Dict[" + k + ", " + v + "]]";
        }
        if (t.startsWith("JAXBElement<")) {
            String inner = t.substring("JAXBElement<".length(), t.length() - 1);
            return this.mapTypeToPython(inner, fieldBO, class_);
        }
        if (t.endsWith("[]")) {
            String inner = t.substring(0, t.length() - 2);
            String mapped = this.stripOptional(this.mapTypeToPython(inner, fieldBO, class_));
            return "Optional[List[" + mapped + "]]";
        }
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(t)) {
            return "Optional[" + this.sanitizeCodeIdentifier(JavaSourceExtractor.mappingForbidenClassNames.get(t)) + "]";
        }
        if (t.contains(".")) {
            String[] parts = t.split("\\.");
            StringBuilder nb = new StringBuilder();
            for (String p : parts) {
                if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(p)) {
                    nb.append(JavaSourceExtractor.mappingForbidenClassNames.get(p));
                } else {
                    nb.append(p);
                }
                nb.append("_");
            }
            String name = nb.substring(0, nb.length() - 1);
            return "Optional[" + this.sanitizeCodeIdentifier(name) + "]";
        }
        for (String importName : class_.javaFileBO.javaImports) {
            if (!importName.endsWith("." + t)) continue;
            String pkg = importName.replace("." + t, "");
            String[] parts = pkg.split("\\.");
            String keyWord = parts[parts.length - 1].toLowerCase();
            if (keyWord.equals("data") && parts.length >= 2) {
                keyWord = (parts[parts.length - 2] + "_data").toLowerCase();
            }
            String annotated = keyWord + "." + this.sanitizeCodeIdentifier(t);
            return "Optional[" + annotated + "]";
        }
        return "Optional[" + this.sanitizeCodeIdentifier(t) + "]";
    }

    private String stripOptional(String annotated) {
        if (annotated == null) {
            return "Any";
        }
        String s = annotated.trim();
        if (s.startsWith("Optional[") && s.endsWith("]")) {
            return s.substring("Optional[".length(), s.length() - 1);
        }
        return s;
    }

    private String convertEnumToPython(StringBuilder py, EnumBO enum_) {
        StringBuilder out = new StringBuilder();
        List<String> lines = Arrays.asList(enum_.enumBlockCode.split("\n"));
        String enumName = null;
        ArrayList<String[]> entries = new ArrayList<String[]>();
        Pattern enumStart = Pattern.compile("enum\\s+(\\w+)");
        Pattern valueEnumPattern = Pattern.compile("^(\\w+)\\s*\\(\\s*\"([^\"]+)\"\\s*\\)\\s*,?;?");
        Pattern simpleEnumPattern = Pattern.compile("^\\s*(\\w+)\\s*,?;?\\s*$");
        for (String raw : lines) {
            String name;
            Matcher sm;
            Matcher m;
            String line = raw.trim();
            if (line.startsWith("@")) continue;
            if (enumName == null && (m = enumStart.matcher(line)).find()) {
                enumName = m.group(1);
                continue;
            }
            Matcher vm = valueEnumPattern.matcher(line);
            if (vm.find()) {
                String name2 = vm.group(1);
                String val = vm.group(2);
                if (name2.equals("value") || name2.equals("fromValue")) continue;
                entries.add(new String[]{name2, val});
                continue;
            }
            if (line.contains("(") || !(sm = simpleEnumPattern.matcher(line)).find() || (name = sm.group(1)).equals("value") || name.equals("fromValue")) continue;
            entries.add(new String[]{name, null});
        }
        if (enumName == null || enumName.isBlank()) {
            return "";
        }
        String safeEnumName = this.sanitizeCodeIdentifier(enumName);
        out.append("class ").append(safeEnumName).append("(Enum):\n");
        if (entries.isEmpty()) {
            out.append("    pass\n\n");
        } else {
            for (String[] e : entries) {
                String name = this.sanitizeCodeIdentifier(e[0]);
                String val = e[1] != null ? e[1] : e[0];
                out.append("    ").append(name).append(" = \"").append(val).append("\"\n");
            }
            out.append("\n").append("    @classmethod\n").append("    def from_str(cls, value: str) -> \"").append(safeEnumName).append("\":\n").append("        for member in cls:\n").append("            if member.value == value or member.name == value:\n").append("                return member\n").append("        raise ValueError(f\"Invalid ").append(safeEnumName).append(" value: {value}\")\n\n");
        }
        py.append((CharSequence)out);
        return out.toString();
    }
}

