/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.utils.plugin;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import fr.emac.gind.rio.utils.plugin.ClassBO;
import fr.emac.gind.rio.utils.plugin.EnumBO;
import fr.emac.gind.rio.utils.plugin.FieldBO;
import fr.emac.gind.rio.utils.plugin.JavaFileBO;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaSourceExtractor {
    public static Map<String, String> mappingForbidenClassNames = Map.of("Map", "Map_");

    public static JavaFileBO extractJavaFileStructure(File javaFile) throws IOException {
        Objects.requireNonNull(javaFile, "javaFile");
        if (!javaFile.isFile()) {
            throw new IOException("Not a file: " + javaFile.getAbsolutePath());
        }
        final String source = Files.readString(javaFile.toPath(), StandardCharsets.UTF_8);
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        if (jc == null) {
            throw new IllegalStateException("No system Java compiler found. Use a JDK.");
        }
        final JavaFileBO out = new JavaFileBO();
        out.fromJavaFile = javaFile;
        out.enums = new ArrayList<EnumBO>();
        out.mainClasses = new ArrayList<ClassBO>();
        out.javaImports = new ArrayList<String>();
        try (StandardJavaFileManager fm = jc.getStandardFileManager(null, null, StandardCharsets.UTF_8);){
            Iterable<? extends JavaFileObject> fos = fm.getJavaFileObjects(javaFile);
            JavacTask task = (JavacTask)jc.getTask(null, fm, null, List.of("-proc:none"), null, fos);
            Iterable<? extends CompilationUnitTree> units = task.parse();
            Trees trees = Trees.instance(task);
            final SourcePositions pos = trees.getSourcePositions();
            for (final CompilationUnitTree compilationUnitTree : units) {
                if (compilationUnitTree.getPackageName() != null) {
                    out.packageName = compilationUnitTree.getPackageName().toString();
                }
                LinkedHashSet<String> imps = new LinkedHashSet<String>();
                if (compilationUnitTree.getImports() != null) {
                    for (ImportTree importTree : compilationUnitTree.getImports()) {
                        Object q = importTree.getQualifiedIdentifier().toString();
                        if (importTree.isStatic()) {
                            q = "static " + (String)q;
                        }
                        imps.add((String)q);
                    }
                }
                out.javaImports = new ArrayList<String>(imps);
                final ArrayDeque classStack = new ArrayDeque();
                final ArrayDeque simpleNameStack = new ArrayDeque();
                final AtomicInteger atomicInteger = new AtomicInteger(1);
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitClass(ClassTree cls, Void p) {
                        String simple;
                        Tree.Kind kind = cls.getKind();
                        String string = simple = cls.getSimpleName() == null ? "" : cls.getSimpleName().toString();
                        if (mappingForbidenClassNames.containsKey(simple)) {
                            simple = mappingForbidenClassNames.get(simple);
                        }
                        if (kind == Tree.Kind.ENUM) {
                            EnumBO ebo = new EnumBO();
                            ebo.enumName = simple;
                            ebo.enumBlockCode = this.slice(compilationUnitTree, cls, source, pos);
                            out.enums.add(ebo);
                            simpleNameStack.push(simple);
                            Void res = (Void)super.visitClass(cls, p);
                            simpleNameStack.pop();
                            return res;
                        }
                        if (kind == Tree.Kind.INTERFACE || kind == Tree.Kind.RECORD) {
                            simpleNameStack.push(simple);
                            Void res = (Void)super.visitClass(cls, p);
                            simpleNameStack.pop();
                            return res;
                        }
                        if (kind == Tree.Kind.CLASS) {
                            String flattenedName = this.flattenedName(simpleNameStack, simple);
                            ClassBO cbo = new ClassBO();
                            cbo.className = flattenedName;
                            cbo.javaFileBO = out;
                            cbo.fields = new LinkedHashMap<String, FieldBO>();
                            cbo.innerClasses = new ArrayList<ClassBO>();
                            if (cls.getExtendsClause() != null) {
                                cbo.parentClassName = cls.getExtendsClause().toString();
                            }
                            if (!classStack.isEmpty()) {
                                ClassBO container = (ClassBO)classStack.peek();
                                cbo.containerClass = container;
                                container.innerClasses.add(cbo);
                            } else {
                                out.mainClasses.add(cbo);
                            }
                            for (Tree tree : cls.getMembers()) {
                                if (tree.getKind() != Tree.Kind.VARIABLE) continue;
                                VariableTree vt = (VariableTree)tree;
                                FieldBO f = this.buildFieldBO(vt);
                                cbo.fields.put(f.name, f);
                            }
                            cbo.classBlockCodeWithoutInnerClasses = this.sliceClassWithoutInner(cls, compilationUnitTree, source, pos);
                            classStack.push(cbo);
                            simpleNameStack.push(simple);
                            Void res = (Void)super.visitClass(cls, p);
                            simpleNameStack.pop();
                            classStack.pop();
                            return res;
                        }
                        return (Void)super.visitClass(cls, p);
                    }

                    @Override
                    public Void visitNewClass(NewClassTree nct, Void p) {
                        ClassTree body = nct.getClassBody();
                        if (body != null) {
                            String anonSimple = "Anonymous" + atomicInteger.getAndIncrement();
                            simpleNameStack.push(anonSimple);
                            this.visitClass(body, p);
                            simpleNameStack.pop();
                            return null;
                        }
                        return (Void)super.visitNewClass(nct, p);
                    }

                    private String flattenedName(Deque<String> containerSimpleNames, String currentSimple) {
                        if (containerSimpleNames.isEmpty()) {
                            return currentSimple;
                        }
                        ArrayList<String> outerToInner = new ArrayList<String>(containerSimpleNames);
                        Collections.reverse(outerToInner);
                        outerToInner.add(currentSimple);
                        return String.join((CharSequence)"_", outerToInner);
                    }

                    private FieldBO buildFieldBO(VariableTree vt) {
                        String name = vt.getName().toString();
                        String type = vt.getType() == null ? "var" : vt.getType().toString();
                        List anns = vt.getModifiers() != null && vt.getModifiers().getAnnotations() != null ? vt.getModifiers().getAnnotations() : List.of();
                        return new FieldBO(name, type, new ArrayList(anns));
                    }

                    private String slice(CompilationUnitTree unit, Tree tree, String src, SourcePositions pos2) {
                        long start = pos2.getStartPosition(unit, tree);
                        long end = pos2.getEndPosition(unit, tree);
                        if (start < 0L || end < 0L || end > (long)src.length()) {
                            return null;
                        }
                        return src.substring((int)start, (int)end);
                    }

                    private String sliceClassWithoutInner(ClassTree cls, CompilationUnitTree unit, String src, SourcePositions pos2) {
                        String full = this.slice(unit, cls, src, pos2);
                        if (full == null) {
                            return null;
                        }
                        ArrayList<int[]> innerRanges = new ArrayList<int[]>();
                        for (Tree tree : cls.getMembers()) {
                            Tree.Kind k = tree.getKind();
                            if (k != Tree.Kind.CLASS && k != Tree.Kind.ENUM && k != Tree.Kind.INTERFACE && k != Tree.Kind.RECORD) continue;
                            int s = (int)pos2.getStartPosition(unit, tree);
                            int e = (int)pos2.getEndPosition(unit, tree);
                            innerRanges.add(new int[]{s, e});
                        }
                        if (innerRanges.isEmpty()) {
                            return full;
                        }
                        int classStart = (int)pos2.getStartPosition(unit, cls);
                        innerRanges.sort(Comparator.comparingInt(a -> a[0]));
                        StringBuilder stringBuilder = new StringBuilder(full.length());
                        int cursor = 0;
                        for (int[] r : innerRanges) {
                            int rs = Math.max(0, r[0] - classStart);
                            int re = Math.min(full.length(), r[1] - classStart);
                            if (cursor < rs) {
                                stringBuilder.append(full, cursor, rs);
                            }
                            cursor = Math.max(cursor, re);
                        }
                        if (cursor < full.length()) {
                            stringBuilder.append(full, cursor, full.length());
                        }
                        return stringBuilder.toString();
                    }
                }.scan(compilationUnitTree, null);
            }
            HashMap<String, ClassBO> byName = new HashMap<String, ClassBO>();
            for (ClassBO c : out.mainClasses) {
                JavaSourceExtractor.collectAll(byName, c);
            }
            for (ClassBO c : byName.values()) {
                if (c.parentClassName == null) continue;
                c.parentClass = (ClassBO)byName.get(c.parentClassName);
            }
        }
        return out;
    }

    private static void collectAll(Map<String, ClassBO> map, ClassBO c) {
        map.put(c.className, c);
        if (c.innerClasses != null) {
            for (ClassBO in : c.innerClasses) {
                JavaSourceExtractor.collectAll(map, in);
            }
        }
    }
}

