/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.utils.plugin;

import fr.emac.gind.rio.utils.plugin.AbstractXsdToCodeMojo;
import fr.emac.gind.rio.utils.plugin.ClassBO;
import fr.emac.gind.rio.utils.plugin.EnumBO;
import fr.emac.gind.rio.utils.plugin.FieldBO;
import fr.emac.gind.rio.utils.plugin.JavaSourceExtractor;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-dart", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class XsdToDartMojo
extends AbstractXsdToCodeMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/dart")
    protected File outputDirectory;

    @Override
    public String getCodeExtensionFileName() {
        return "dart";
    }

    @Override
    public File getCodeOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void generateCodeImport(List<String> dartImports, String fileName, String keyWord) {
        String dartImport = "import 'package:gind_r_io4u/to/generated_sources/dart/" + fileName.replace("-", "_") + ".dart';";
        dartImports.add(dartImport);
    }

    @Override
    protected void additionalHeaderCode(StringBuilder sb, String xsdShortName) {
        sb.append("import 'dart:typed_data';\n");
        sb.append("import 'package:json_annotation/json_annotation.dart';\n\n");
        sb.append("part '").append(xsdShortName.replace(".dart", "")).append(".g.dart';\n\n\n");
    }

    @Override
    protected void convertJavaClassToCode(StringBuilder sb, ClassBO classBO) {
        this.convertJavaClassToDart(sb, classBO);
        classBO.alreadyDone = true;
    }

    @Override
    protected void convertEnumToCode(StringBuilder sb, EnumBO enum_) {
        XsdToDartMojo.convertEnumToDart(sb, enum_);
    }

    private void convertJavaClassToDart(StringBuilder dart, ClassBO classBO) {
        StringBuilder classBuilder = new StringBuilder();
        String className = classBO.className;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(className)) {
            className = JavaSourceExtractor.mappingForbidenClassNames.get(className);
        }
        if (className.contains("Embedded")) {
            System.out.println("break");
        }
        classBuilder.append("@JsonSerializable()\n");
        if (classBO.parentClassName != null && !classBO.parentClassName.isBlank()) {
            classBuilder.append("class ").append(className).append(" extends ").append(classBO.parentClassName).append(" {\n\n");
        } else {
            classBuilder.append("class ").append(className).append(" {\n\n");
        }
        for (Map.Entry<String, FieldBO> fieldEntry : classBO.fields.entrySet()) {
            String unsanitizedFieldName = fieldEntry.getKey();
            String fieldName = XsdToDartMojo.sanitizedFieldName(fieldEntry);
            String dartType = this.mapTypeToDart(fieldEntry.getValue().type, fieldEntry.getValue(), classBO);
            if (unsanitizedFieldName.startsWith("_")) {
                unsanitizedFieldName = unsanitizedFieldName.replaceFirst("_", "");
            }
            if (unsanitizedFieldName.equals("extends") || unsanitizedFieldName.equals("type") || unsanitizedFieldName.equals("return") || unsanitizedFieldName.equals("in")) {
                classBuilder.append("\t").append("@JsonKey(name: '" + unsanitizedFieldName + "')").append("\n");
            }
            classBuilder.append("\t").append(dartType).append("? ").append(fieldName).append(";\n");
        }
        String constructor = XsdToDartMojo.generateDartConstructor(classBO);
        classBuilder.append(constructor);
        classBuilder.append("\n\tfactory ").append(className).append(".fromJson(Map<String, dynamic> json) => _$").append(className).append("FromJson(json);\n\n");
        classBuilder.append("\n\tMap<String, dynamic> toJson() => _$").append(className).append("ToJson(this);\n\n");
        classBuilder.append("}\n\n");
        if (className.equals("FixedValues")) {
            System.out.println("break");
        }
        if (classBO.innerClasses != null) {
            for (ClassBO innerClass : classBO.innerClasses) {
                innerClass.javaFileBO = classBO.javaFileBO;
                this.convertJavaClassToDart(dart, innerClass);
            }
        }
        dart.append((CharSequence)classBuilder);
    }

    private static String generateDartConstructor(ClassBO classBo) {
        Map<String, FieldBO> parentArgs;
        StringBuilder sb = new StringBuilder();
        String className = classBo.className;
        if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(className)) {
            className = JavaSourceExtractor.mappingForbidenClassNames.get(className);
        }
        sb.append("\n\t").append(className).append("(");
        if (classBo.fields != null && !classBo.fields.isEmpty()) {
            sb.append("{\n");
        }
        for (Map.Entry<String, FieldBO> fieldEntry : classBo.fields.entrySet()) {
            String fieldName = XsdToDartMojo.sanitizedFieldName(fieldEntry);
            sb.append("\t    this.").append(fieldName).append(",\n");
        }
        ClassBO parentClass = classBo.parentClass;
        if (parentClass != null && (parentArgs = parentClass.fields) != null && !parentArgs.isEmpty()) {
            for (Map.Entry<String, FieldBO> parentArg : parentArgs.entrySet()) {
                if (classBo.fields.keySet().contains(parentArg.getKey())) continue;
                String fieldName = XsdToDartMojo.sanitizedFieldName(parentArg);
                sb.append("\t    super.").append(fieldName).append(",\n");
            }
        }
        if (classBo.fields != null && !classBo.fields.isEmpty()) {
            sb.append("}\n");
        }
        sb.append(")");
        if (parentClass != null) {
            sb.append(" : super(").append(")");
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String sanitizedFieldName(Map.Entry<String, FieldBO> parentArg) {
        Object fieldName = parentArg.getValue().name;
        if (((String)fieldName).startsWith("_")) {
            fieldName = ((String)fieldName).replaceFirst("_", "");
        }
        if (((String)fieldName).equals("extends") || ((String)fieldName).equals("type") || ((String)fieldName).equals("return") || ((String)fieldName).equals("in")) {
            fieldName = (String)fieldName + "_";
        }
        return fieldName;
    }

    private static String convertEnumToDart(StringBuilder dart, EnumBO enum_) {
        StringBuilder dartEnum = new StringBuilder();
        List<String> lines = Arrays.asList(enum_.enumBlockCode.split("\n"));
        String enumName = null;
        ArrayList<CallSite> entries = new ArrayList<CallSite>();
        boolean hasCustomValues = false;
        Pattern enumStart = Pattern.compile("enum\\s+(\\w+)");
        Pattern valueEnumPattern = Pattern.compile("^(\\w+)\\s*\\(\\s*\"([^\"]+)\"\\s*\\)\\s*,?;?");
        Pattern simpleEnumPattern = Pattern.compile("^\\s*(\\w+)\\s*,?;?\\s*$");
        for (String line : lines) {
            String name;
            Matcher simpleMatcher;
            Matcher m;
            if ((line = line.trim()).startsWith("@")) continue;
            if (enumName == null && (m = enumStart.matcher(line)).find()) {
                enumName = m.group(1);
                continue;
            }
            Matcher valueMatcher = valueEnumPattern.matcher(line);
            if (valueMatcher.find()) {
                hasCustomValues = true;
                String name2 = valueMatcher.group(1);
                String value = valueMatcher.group(2);
                entries.add((CallSite)((Object)("  " + name2 + "(\"" + value + "\")")));
                continue;
            }
            if (line.contains("(") || !(simpleMatcher = simpleEnumPattern.matcher(line)).find() || (name = simpleMatcher.group(1)).equals("value") || name.equals("fromValue")) continue;
            entries.add((CallSite)((Object)("  " + name)));
        }
        dartEnum.append("enum ").append(enumName).append(" {\n");
        dartEnum.append(String.join((CharSequence)",\n", entries)).append(";\n\n");
        if (hasCustomValues) {
            dartEnum.append("  final String value;\n");
            dartEnum.append("  const ").append(enumName).append("(this.value);\n\n");
            dartEnum.append("  factory ").append(enumName).append(".fromJson(String value) {\n");
            dartEnum.append("    return ").append(enumName).append(".values.firstWhere(\n");
            dartEnum.append("      (e) => e.value == value,\n");
            dartEnum.append("      orElse: () => throw ArgumentError('Invalid value: \\$value'),\n");
            dartEnum.append("    );\n");
            dartEnum.append("  }\n\n");
            dartEnum.append("  String toJson() => value;\n");
        } else {
            dartEnum.append("  factory ").append(enumName).append(".fromJson(String value) {\n");
            dartEnum.append("    return ").append(enumName).append(".values.firstWhere(\n");
            dartEnum.append("      (e) => e.name == value,\n");
            dartEnum.append("      orElse: () => throw ArgumentError('Invalid value: \\$value'),\n");
            dartEnum.append("    );\n");
            dartEnum.append("  }\n\n");
            dartEnum.append("  String toJson() => name;\n");
        }
        dartEnum.append("}\n\n");
        dart.append((CharSequence)dartEnum);
        return dartEnum.toString();
    }

    private String mapTypeToDart(String javaType, FieldBO fieldBO, ClassBO class_) {
        javaType = javaType.replace(class_.javaFileBO.packageName + ".", "");
        for (String otherPackageName : class_.javaFileBO.otherPossiblePackageNames) {
            javaType = javaType.replace(otherPackageName + ".", "");
        }
        return switch (javaType) {
            case "String" -> "String";
            case "QName" -> "String";
            case "base64Binary" -> "String";
            case "byte[]" -> "String";
            case "int", "Integer", "BigInteger", "long", "Long" -> "int";
            case "boolean", "Boolean" -> "bool";
            case "XMLGregorianCalendar" -> "DateTime";
            case "DataHandler" -> "String";
            case "double", "Double", "float", "Float" -> "double";
            default -> {
                if (javaType.startsWith("List<")) {
                    String inner = javaType.substring("List<".length(), javaType.length() - ">".length());
                    yield "List<" + this.mapTypeToDart(inner, fieldBO, class_) + ">";
                }
                if (javaType.startsWith("Map<")) {
                    String[] inners = javaType.substring("Map<".length(), javaType.length() - ">".length()).split(",");
                    yield "Map<" + this.mapTypeToDart(inners[0], fieldBO, class_) + ", " + this.mapTypeToDart(inners[1], fieldBO, class_) + ">";
                }
                if (javaType.startsWith("JAXBElement<")) {
                    String inner = javaType.substring("JAXBElement<".length(), javaType.length() - 1);
                    yield this.mapTypeToDart(inner, fieldBO, class_);
                }
                if (JavaSourceExtractor.mappingForbidenClassNames.containsKey(javaType)) {
                    javaType = JavaSourceExtractor.mappingForbidenClassNames.get(javaType);
                    yield javaType;
                }
                if (javaType.contains(".")) {
                    String[] javaTypeSplitted = javaType.split("\\.");
                    Object newType = "";
                    for (String jt : javaTypeSplitted) {
                        newType = JavaSourceExtractor.mappingForbidenClassNames.containsKey(jt) ? (String)newType + JavaSourceExtractor.mappingForbidenClassNames.get(jt) : (String)newType + jt;
                        newType = (String)newType + "_";
                    }
                    yield newType = ((String)newType).substring(0, ((String)newType).length() - "_".length());
                }
                yield javaType;
            }
        };
    }
}

