/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.utils.xsd2html;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.JaxbObjectUtil;
import fr.emac.gind.schema10.SchemaOfSchemas;
import fr.emac.gind.schema10.XSDSchemaManager;
import fr.emac.gind.utils.xsd2html.PropertyTag;
import gind.org.w3._2001.xmlschema.GJaxbAnnotated;
import gind.org.w3._2001.xmlschema.GJaxbAny;
import gind.org.w3._2001.xmlschema.GJaxbAttribute;
import gind.org.w3._2001.xmlschema.GJaxbComplexType;
import gind.org.w3._2001.xmlschema.GJaxbElement;
import gind.org.w3._2001.xmlschema.GJaxbFormChoice;
import gind.org.w3._2001.xmlschema.GJaxbNoFixedFacet;
import gind.org.w3._2001.xmlschema.GJaxbSchema;
import gind.org.w3._2001.xmlschema.GJaxbSimpleType;
import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.xpath.XPathEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSD2HTML {
    private static final Logger LOG = LoggerFactory.getLogger((String)XSD2HTML.class.getName());
    private static XSD2HTML INSTANCE = null;

    private XSD2HTML() {
    }

    public static XSD2HTML getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new XSD2HTML();
        }
        return INSTANCE;
    }

    public Element generateForm(GJaxbElement eIn, String action, Map<QName, PropertyTag> tags, Document valuesInForm, XSDSchemaManager schemaManager) throws Exception {
        try {
            if (eIn != null) {
                Stack<QName> parents = new Stack<QName>();
                Element res = this.generateForm(null, eIn, action, tags, valuesInForm, ((GJaxbSchema)eIn.findParent(new QName("http://www.w3.org/2001/XMLSchema", "schema"))).getElementFormDefault(), 1, false, false, parents, schemaManager);
                Document doc = DOMUtil.getInstance().newDocument();
                Element parent = doc.createElement("div");
                doc.appendChild(parent);
                parent.appendChild(doc.adoptNode(res));
                for (PropertyTag suppTag : tags.values()) {
                    if (suppTag.isAlreadyUsed()) continue;
                    Element div = doc.createElement("div");
                    Element input = doc.createElement("input");
                    input.setAttribute("id", suppTag.getName().getLocalPart());
                    input.setAttribute("name", "HIDDEN_DATA." + suppTag.getName().getLocalPart());
                    if (suppTag.isHidden()) {
                        input.setAttribute("type", "hidden");
                    } else {
                        Element label = doc.createElement("label");
                        label.setAttribute("for", eIn.getName());
                        label.setTextContent(eIn.getName() + ": ");
                        div.appendChild(label);
                        input.setAttribute("type", "text");
                    }
                    if (suppTag.getDefaultValue() != null) {
                        input.setAttribute("value", suppTag.getDefaultValue());
                    }
                    div.appendChild(input);
                    res.appendChild(div);
                }
                if (action != null) {
                    Element submit = doc.createElement("input");
                    submit.setAttribute("type", "submit");
                    submit.setAttribute("value", "send");
                    res.appendChild(submit);
                }
                return parent;
            }
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e);
        }
        return null;
    }

    private Element generateForm(Element parentDomElmt, GJaxbElement eIn, String action, Map<QName, PropertyTag> tags, Document valuesInForm, GJaxbFormChoice form, int minOccurs, boolean createOptionalElement, boolean createOptionalAttribute, Stack<QName> parents, XSDSchemaManager schemaManager) throws Exception {
        GJaxbSchema parentSchema;
        Element eOut = null;
        if (minOccurs == 0) {
            return eOut;
        }
        GJaxbAnnotated eInType = null;
        if (eIn.getType() != null) {
            eInType = schemaManager.getType(eIn.getType());
        } else if (eIn.getComplexType() != null) {
            eInType = eIn.getComplexType();
        }
        assert (eInType != null) : "No type defined for " + eIn.getName();
        if (parentDomElmt == null) {
            Document doc = DOMUtil.getInstance().newDocument();
            eOut = doc.createElement("form");
            eOut.setAttribute("name", eIn.getName());
            eOut.setAttribute("id", eIn.getName());
            eOut.setAttribute("action", action);
            eOut.setAttribute("method", "post");
            doc.appendChild(eOut);
            parentDomElmt = doc.getDocumentElement();
            parents.push(new QName(((GJaxbSchema)eIn.findParent(new QName("http://www.w3.org/2001/XMLSchema", "schema"))).getTargetNamespace(), eIn.getName()));
        } else if (eInType instanceof GJaxbComplexType) {
            eOut = parentDomElmt.getOwnerDocument().createElement("fieldset");
            Element legend = parentDomElmt.getOwnerDocument().createElement("legend");
            legend.setTextContent(eIn.getName());
            eOut.appendChild(legend);
            parents.push(new QName(((GJaxbSchema)eIn.findParent(new QName("http://www.w3.org/2001/XMLSchema", "schema"))).getTargetNamespace(), eIn.getName()));
        } else if (eInType instanceof GJaxbSimpleType) {
            List<String> enumString = this.getEnum(eInType);
            if (!enumString.isEmpty()) {
                eOut = parentDomElmt.getOwnerDocument().createElement("div");
                Element label = parentDomElmt.getOwnerDocument().createElement("label");
                label.setAttribute("for", eIn.getName());
                label.setTextContent(eIn.getName() + ": ");
                eOut.appendChild(label);
                Element select = parentDomElmt.getOwnerDocument().createElement("select");
                select.setAttribute("id", eIn.getName());
                select.setAttribute("name", this.createJSONPath(parents, eIn.getName()));
                eOut.appendChild(select);
                for (String e : enumString) {
                    Element option = parentDomElmt.getOwnerDocument().createElement("option");
                    option.setTextContent(e);
                    select.appendChild(option);
                }
            } else {
                eOut = this.createDefaultInputTag(parentDomElmt, eIn, tags, parents, valuesInForm);
            }
        }
        if (eInType instanceof GJaxbComplexType) {
            ArrayList<GJaxbElement> items = new ArrayList<GJaxbElement>();
            GJaxbComplexType complexType = (GJaxbComplexType)eInType;
            if (complexType.isSetSequence()) {
                items.addAll(complexType.getSequence().getParticle());
            } else if (complexType.isSetAll()) {
                items.addAll(complexType.getSequence().getParticle());
            } else if (complexType.isSetComplexContent() && complexType.getComplexContent().isSetExtension()) {
                items.addAll(this.getAllElementFindInAllInheritedParent(complexType.getComplexContent().getExtension().getBase(), schemaManager));
                if (complexType.getComplexContent().getExtension().isSetSequence()) {
                    items.addAll(complexType.getComplexContent().getExtension().getSequence().getParticle());
                }
            }
            if (items != null) {
                for (Object e : items) {
                    GJaxbElement item = null;
                    if (e instanceof GJaxbElement) {
                        item = (GJaxbElement)e;
                    } else if (e instanceof JAXBElement && ((JAXBElement)e).getValue() instanceof GJaxbElement) {
                        item = (GJaxbElement)((JAXBElement)e).getValue();
                    }
                    if (item != null) {
                        Element child;
                        int minOccursChildElmt;
                        GJaxbFormChoice elmtFrom;
                        GJaxbElement e2;
                        if (item.getRef() == null) {
                            e2 = item;
                            elmtFrom = null;
                            if (e2.getForm() != null) {
                                elmtFrom = e2.getForm();
                            } else {
                                GJaxbSchema parentSchema2 = (GJaxbSchema)JaxbObjectUtil.getSpecificParent((AbstractJaxbObject)eIn, GJaxbSchema.class);
                                elmtFrom = parentSchema2.getElementFormDefault();
                            }
                            minOccursChildElmt = e2.getMinOccurs().intValue();
                            if (createOptionalElement && minOccursChildElmt == 0) {
                                minOccursChildElmt = 1;
                            }
                            if ((child = this.generateForm(parentDomElmt, e2, action, tags, valuesInForm, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute, parents, schemaManager)) == null) continue;
                            eOut.appendChild(child.cloneNode(true));
                            continue;
                        }
                        e2 = schemaManager.getElement(item.getRef());
                        if (e2 != null) {
                            elmtFrom = null;
                            elmtFrom = e2.getForm() != null ? e2.getForm() : form;
                            minOccursChildElmt = e2.getMinOccurs().intValue();
                            if (createOptionalElement && minOccursChildElmt == 0) {
                                minOccursChildElmt = 1;
                            }
                            if ((child = this.generateForm(parentDomElmt, e2, action, tags, valuesInForm, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute, parents, schemaManager)) == null) continue;
                            eOut.appendChild(child.cloneNode(true));
                            continue;
                        }
                        throw new UncheckedException("Impossible to find element corresponding to this reference: " + String.valueOf(item.getRef()));
                    }
                    if (e instanceof GJaxbAny) {
                        GJaxbAny any = (GJaxbAny)e;
                        LOG.warn("GJaxbAny is not take into account to generate form for the moment: " + String.valueOf(any));
                        continue;
                    }
                    throw new Exception("kind of item not take into account for the moment: " + String.valueOf(e));
                }
                for (GJaxbAnnotated gJaxbAnnotated : complexType.getAttributeOrAttributeGroup()) {
                    GJaxbAttribute attr = (GJaxbAttribute)gJaxbAnnotated;
                    Attr a = null;
                    if ("REQUIRED".equals(attr.getUse().toUpperCase())) {
                        a = this.generateAttribute(eIn, attr, tags, eOut);
                    } else if (createOptionalAttribute) {
                        a = this.generateAttribute(eIn, attr, tags, eOut);
                    }
                    if (a == null) continue;
                    eOut.setAttributeNode(a);
                }
            }
            parents.pop();
        }
        if ((parentSchema = (GJaxbSchema)JaxbObjectUtil.getSpecificParent((AbstractJaxbObject)eIn, GJaxbSchema.class)) != null) {
            parentSchema.getAttributeFormDefault();
        }
        return eOut;
    }

    private Element createDefaultInputTag(Element parentDomElmt, GJaxbElement eIn, Map<QName, PropertyTag> tags, Stack<QName> parents, Document valuesInForm) throws Exception {
        String value;
        Element eOut = parentDomElmt.getOwnerDocument().createElement("div");
        Element input = parentDomElmt.getOwnerDocument().createElement("input");
        input.setAttribute("id", eIn.getName());
        input.setAttribute("name", this.createJSONPath(parents, eIn.getName()));
        PropertyTag specificPropertyTag = tags.get(new QName(eIn.findTargetNamespace(), eIn.getName()));
        if (specificPropertyTag != null) {
            specificPropertyTag.setAlreadyUsed(true);
        }
        if (specificPropertyTag != null && specificPropertyTag.isHidden()) {
            input.setAttribute("type", "hidden");
        } else {
            Element label = parentDomElmt.getOwnerDocument().createElement("label");
            label.setAttribute("for", eIn.getName());
            label.setTextContent(eIn.getName() + ": ");
            eOut.appendChild(label);
            input.setAttribute("type", "text");
        }
        if (specificPropertyTag != null && specificPropertyTag.getDefaultValue() != null) {
            input.setAttribute("value", specificPropertyTag.getDefaultValue());
        }
        if ((value = this.findValue(eIn, parents, valuesInForm)) != null) {
            input.setAttribute("value", value);
        }
        eOut.appendChild(input);
        return eOut;
    }

    private String findValue(GJaxbElement eIn, Stack<QName> parents, Document valuesInForm) throws Exception {
        String res = null;
        if (valuesInForm != null) {
            String xpath = this.createXPATH(parents, eIn);
            XPathEvaluator eval = new XPathEvaluator(new Configuration());
            eval.setNamespaceContext(eIn.getNamespaceContext());
            res = eval.evaluate(xpath, (Object)valuesInForm);
        }
        return res;
    }

    private String createXPATH(Stack<QName> parents, GJaxbElement eIn) {
        Object xpath = "";
        for (QName current : parents) {
            xpath = (String)xpath + "/" + eIn.getNamespaceContext().getPrefix(current.getNamespaceURI()) + ":" + current.getLocalPart();
        }
        xpath = (String)xpath + "/" + eIn.getNamespaceContext().getPrefix(((GJaxbSchema)eIn.findParent(new QName("http://www.w3.org/2001/XMLSchema", "schema"))).getTargetNamespace()) + ":" + eIn.getName();
        return xpath;
    }

    private String createJSONPath(Stack<QName> parents, String elmt) {
        Object jsonPath = "";
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            jsonPath = (String)jsonPath + ((QName)it.next()).getLocalPart() + ".";
        }
        jsonPath = (String)jsonPath + elmt;
        return jsonPath;
    }

    private List<String> getEnum(GJaxbAnnotated eInType) {
        ArrayList<String> enumString = new ArrayList<String>();
        GJaxbSimpleType st = (GJaxbSimpleType)eInType;
        if ("boolean".equals(st.getName())) {
            enumString.add("false");
            enumString.add("true");
        } else if (st.isSetRestriction() && st.getRestriction().getBase().equals(new QName("http://www.w3.org/2001/XMLSchema", "string"))) {
            for (Object facet : st.getRestriction().getFacets()) {
                if (!(facet instanceof JAXBElement) || !(((JAXBElement)facet).getValue() instanceof GJaxbNoFixedFacet)) continue;
                enumString.add(((GJaxbNoFixedFacet)((JAXBElement)facet).getValue()).getValue());
            }
        }
        return enumString;
    }

    private List<GJaxbElement> getAllElementFindInAllInheritedParent(QName baseQName, XSDSchemaManager schemaManager) throws Exception {
        ArrayList<GJaxbElement> res = new ArrayList<GJaxbElement>();
        GJaxbAnnotated base = schemaManager.getType(baseQName);
        if (base instanceof GJaxbComplexType) {
            GJaxbComplexType ct = (GJaxbComplexType)base;
            if (ct.isSetAll()) {
                res.addAll(ct.getAll().getParticle());
            } else if (ct.isSetSequence()) {
                res.addAll(ct.getSequence().getParticle());
            } else if (ct.isSetComplexContent() && ct.getComplexContent().isSetExtension()) {
                res.addAll(this.getAllElementFindInAllInheritedParent(ct.getComplexContent().getExtension().getBase(), schemaManager));
            }
        }
        return res;
    }

    public Attr generateAttribute(GJaxbElement eIn, GJaxbAttribute aIn, Map<QName, PropertyTag> tags, Element eOut) {
        Attr attr = null;
        if (aIn.getName() != null) {
            attr = ((GJaxbSchema)aIn.findTopParent()).getAttributeFormDefault() == GJaxbFormChoice.QUALIFIED ? eOut.getOwnerDocument().createAttributeNS(aIn.findTargetNamespace(), aIn.getName()) : eOut.getOwnerDocument().createAttribute(aIn.getName());
        }
        return attr;
    }

    public String printForm(GJaxbElement eIn, String action, Map<QName, PropertyTag> tags, boolean createOptionalElement, boolean createOptionalAttribute, Document valuesInForm, XSDSchemaManager schemaManager) throws Exception {
        Element eOut = null;
        GJaxbSchema parentSchema = (GJaxbSchema)eIn.findTopParent();
        try {
            Stack<QName> parents = new Stack<QName>();
            eOut = this.generateForm(null, eIn, action, tags, valuesInForm, parentSchema.getElementFormDefault(), 1, createOptionalElement, createOptionalAttribute, parents, schemaManager);
            Document doc = DOMUtil.getInstance().newDocument();
            doc.appendChild(doc.adoptNode(eOut));
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e);
        }
        return XMLPrettyPrinter.print((Node)eOut);
    }

    public String printHtml(GJaxbElement e, String action, Map<QName, PropertyTag> tags, Document valuesInForm) throws Exception {
        XSDSchemaManager schemaManager = new XSDSchemaManager(new GJaxbSchema[]{SchemaOfSchemas.getInstance().getSchema(), (GJaxbSchema)e.findParent(new QName("http://www.w3.org/2001/XMLSchema", "schema"))});
        Element eOut = this.generateForm(e, action, tags, valuesInForm, schemaManager);
        Object form = null;
        form = DOMUtil.getInstance().getElements(DOMUtil.getInstance().getFirstElement(eOut)).isEmpty() && action == null ? "Congratulation!!!, your request has been sent successfully. You have received: '" + e.getName() + "' response" : XMLPrettyPrinter.print((Node)eOut).replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        String cssBuffer = FileUtil.getContents((InputStream)Thread.currentThread().getContextClassLoader().getResource("css/default.css").openStream());
        if (cssBuffer.indexOf("*/") >= 0) {
            cssBuffer = cssBuffer.substring(cssBuffer.indexOf("*/") + "*/".length(), cssBuffer.length());
        }
        String css = "<style type=\"text/css\">\n" + cssBuffer + "\n</style>\n";
        String html = "<html><head><title>" + e.getName() + " Form </title></head><body>" + css + (String)form + "</body></html>";
        Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(html.getBytes()));
        return XMLPrettyPrinter.print((Node)doc).replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
    }
}

