/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases.riosuite.test;

import fr.emac.gind.campaign.manager.data.model.GJaxbProcessToDeploy;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.eventcommonsdata.GJaxbProcessStatusType;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.models_gov.GJaxbSynchronizeResponse;
import fr.emac.gind.humantask.client.HumanTaskClient;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.process.GJaxbDeployResult;
import fr.emac.gind.process.instance.GJaxbExecType;
import fr.emac.gind.process.instance.GJaxbRunASyncResponse;
import fr.emac.gind.process.instance.GJaxbRunSync;
import fr.emac.gind.processmonitoring.data.GJaxbGetProcessInstanceResponse;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.ProcessResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.rio.dw.resources.gov.bo.RequestHeaderContext;
import fr.emac.gind.rio.dw.resources.gov.bo.RunProcessRequest;
import fr.emac.gind.rio.suite.test.RIOSuiteSimulationAndOrchestrationBundle;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.usecases.riosuite.test.HumanTaskTestNotifierClient;
import fr.emac.gind.usecases.riosuite.test.RIOSuiteDeductionTest;
import fr.emac.gind.usecases.riosuite.test.RIOSuiteTest;
import fr.emac.gind.workflow.deduction.AbstractDeductionStrategy;
import fr.emac.gind.workflow.report.GJaxbErrorReport;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class RIOSuiteOrchestrationTest
extends RIOSuiteTest {
    protected static Logger LOG = LoggerFactory.getLogger((String)RIOSuiteOrchestrationTest.class.getName());
    public HumanTaskClient htClient;
    private final String callbackAddress;
    private final String port;
    private NotificationConsumerWebService humanTaskconsumer;

    public RIOSuiteOrchestrationTest(RIOAbstractProject uc) throws Exception {
        super(uc);
        this.port = "10108";
        this.callbackAddress = "http://localhost:" + this.port + "/NotifierTest";
    }

    @BeforeEach
    public void initHumanTaskTestNotifier() {
    }

    @AfterEach
    public void stopHumanTaskTestNotifier() throws Exception {
        if (this.humanTaskconsumer != null) {
            this.humanTaskconsumer.stop();
        }
    }

    protected <TESTCLASSCREATINGPROCESS extends RIOSuiteTest, STRATEGY extends AbstractDeductionStrategy> GJaxbRunASyncResponse launchOrchestrationTest(DWUser user, File existingDeducedProcess, TESTCLASSCREATINGPROCESS ucDeduction, STRATEGY strategy, Map<String, Map.Entry<String, String>> humanAnswers) throws Exception {
        GJaxbGenericModel process = null;
        if (!existingDeducedProcess.exists()) {
            LOG.debug("Let's deduce the process before running it.");
            throw new Exception("Not Yet Implemented");
        }
        LOG.debug("let's use existing deduced process." + String.valueOf(existingDeducedProcess.toURI().toURL()));
        process = (GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(existingDeducedProcess.toURI().toURL(), GJaxbGenericModel.class);
        Assertions.assertNotNull((Object)process);
        this.generateProcessFile(strategy, process);
        GJaxbRunSync request = new GJaxbRunSync();
        request.setStartDate(XMLGregorianCalendarHelper.getInstance().getNewCalendar(new Date()));
        request.setExecutionType(GJaxbExecType.ORCHESTRATION);
        GJaxbRunSync.InputData in = new GJaxbRunSync.InputData();
        request.setInputData(in);
        GJaxbSynchronizeResponse publishResponse = ((ModelsResource)bundle.getRioga().getResourcesManager().findResource(ModelsResource.class)).publish(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), process, null, null);
        assert (publishResponse != null);
        LOG.debug(this.createNotifierForHumanTaskEvent(user, humanAnswers));
        RunProcessRequest runRequest = new RunProcessRequest();
        RequestHeaderContext requestHeaderContext = new RequestHeaderContext();
        GJaxbNode processNode = process.getNode().stream().filter(n -> n.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Process"))).findAny().get();
        GJaxbProcessToDeploy sp = new GJaxbProcessToDeploy();
        sp.setProcessId(processNode.getId());
        sp.setProcessName(GenericModelHelper.getName((GJaxbNode)processNode));
        GJaxbDeployResult deployResponse = ((ProcessResource)bundle.getRioga().getResourcesManager().findResource(ProcessResource.class)).deploy(user, sp);
        String endpointAddress = deployResponse.getEndpointAddress();
        runRequest.setEndpointAddress(endpointAddress);
        runRequest.setProcessToDeploy(sp);
        runRequest.setRequestHeaderContext(requestHeaderContext);
        GJaxbRunASyncResponse res = ((ProcessResource)bundle.getRioga().getResourcesManager().findResource(ProcessResource.class)).runASync(user, runRequest);
        this.assertRunAsyncResponse(res);
        return res;
    }

    public String createNotifierForHumanTaskEvent(DWUser user, Map<String, Map.Entry<String, String>> humanAnswers) throws Exception {
        String notifierClientAddress = this.callbackAddress;
        final HumanTaskTestNotifierClient notifier = new HumanTaskTestNotifierClient(notifierClientAddress, humanAnswers, user, bundle);
        this.humanTaskconsumer = new NotificationConsumerWebService();
        this.humanTaskconsumer.start((Map)new HashMap<String, Object>(this){
            final /* synthetic */ RIOSuiteOrchestrationTest this$0;
            {
                this.this$0 = this$0;
                this.put("host", "0.0.0.0");
                this.put("port", this.this$0.port);
                this.put("serviceName", "NotifierTest");
                this.put("notifierClient", notifier);
            }
        });
        LOG.debug("Subscribe on addHumanTaskTopic at " + (String)bundle.getRioga().getConfiguration().getProperties().get("humantask"));
        return notifier.subscribeOn((String)bundle.getRioga().getConfiguration().getProperties().get("humantask") + "Subscriber", new QName("http://www.gind.emac.fr/HumanTaskTopic", "addHumanTaskTopic"));
    }

    protected void assertRunAsyncResponse(GJaxbRunASyncResponse res) {
    }

    @Override
    protected RIOSuiteAbstractBundle initBundle() throws Exception {
        return new RIOSuiteSimulationAndOrchestrationBundle();
    }

    protected void assertError(GJaxbErrorReport res) {
        Assertions.assertNotNull((Object)res);
    }

    public GJaxbProcessStatusType doTestOrchestrate(RIOSuiteDeductionTest ucDeductionTest, AbstractDeductionStrategy strategyDeduction, Map<String, Map.Entry<String, String>> humanAnswers, GJaxbProcessStatusType processStatusExpected) throws Exception {
        bundle.getRioga().getUserResource();
        DWUser user = new DWUser(SystemResource.getDEFAULT_ADMIN(), bundle.getRioga().getUserResource().getSystemClient());
        File existingDeducedProcess = new File(new File("target"), this.getProcessFileNameFromStrategy(strategyDeduction));
        GJaxbRunASyncResponse res = this.launchOrchestrationTest(user, existingDeducedProcess, ucDeductionTest, strategyDeduction, humanAnswers);
        LOG.debug("PROCESS INSTANCE ID " + res.getInstanceId());
        GJaxbGetProcessInstanceResponse processInstance = ((ProcessResource)bundle.getRioga().getResourcesManager().findResource(ProcessResource.class)).processInstance(user, res.getInstanceId());
        while (processInstance == null || processInstance.getInstanceInfo() == null) {
            LOG.debug("PROCESS INSTANCE IS NULL");
            Thread.sleep(2000L);
            processInstance = ((ProcessResource)bundle.getRioga().getResourcesManager().findResource(ProcessResource.class)).processInstance(user, res.getInstanceId());
        }
        GJaxbProcessStatusType currentProcessStatus = processInstance.getInstanceInfo().getStatus();
        while (!(currentProcessStatus.equals((Object)processStatusExpected) || currentProcessStatus.equals((Object)GJaxbProcessStatusType.CRASHED) || currentProcessStatus.equals((Object)GJaxbProcessStatusType.ENDED))) {
            processInstance = ((ProcessResource)bundle.getRioga().getResourcesManager().findResource(ProcessResource.class)).processInstance(user, res.getInstanceId());
            currentProcessStatus = processInstance.getInstanceInfo().getStatus();
            LOG.debug("PROCESS STATUS " + String.valueOf(currentProcessStatus));
            Thread.sleep(5000L);
        }
        LOG.debug("process final status " + String.valueOf(currentProcessStatus));
        return currentProcessStatus;
    }
}

