/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases.riosuite.test;

import java.util.List;

public class Scenario {
    private List<String> risks = null;
    private List<String> preventiveStrategies = null;
    private List<String> correctiveStrategies = null;
    private Double expectedDuration = null;
    private Double expectedCost = null;
    private Double expectedProbability = null;
    private String name = "";

    public Scenario(List<String> risks, List<String> preventiveStrategies, List<String> correctiveStrategies, Double expectedDuration, Double expectedCost, Double expectedProbability) {
        this(risks, preventiveStrategies, correctiveStrategies, null, expectedDuration, expectedCost, expectedProbability);
    }

    public Scenario(List<String> risks, List<String> preventiveStrategies, List<String> correctiveStrategies, String impedanceStrategy, Double expectedDuration, Double expectedCost, Double expectedProbability) {
        this.risks = risks;
        this.preventiveStrategies = preventiveStrategies;
        this.correctiveStrategies = correctiveStrategies;
        this.expectedDuration = expectedDuration;
        this.expectedCost = expectedCost;
        this.expectedProbability = expectedProbability;
        StringBuffer title = new StringBuffer();
        if (!risks.isEmpty()) {
            risks.forEach(risk -> title.append(risk + ", "));
            title.delete(title.length() - ", ".length(), title.length());
        }
        title.append("/");
        if (!preventiveStrategies.isEmpty()) {
            preventiveStrategies.forEach(preventiveStrategy -> title.append(preventiveStrategy + ", "));
            title.delete(title.length() - ", ".length(), title.length());
        }
        title.append("/");
        if (!correctiveStrategies.isEmpty()) {
            correctiveStrategies.forEach(correctiveStrategy -> title.append(correctiveStrategy + ", "));
            title.delete(title.length() - ", ".length(), title.length());
        }
        this.name = title.toString();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRisks() {
        return this.risks;
    }

    public List<String> getPreventiveStrategies() {
        return this.preventiveStrategies;
    }

    public List<String> getCorrectiveStrategies() {
        return this.correctiveStrategies;
    }

    public Double getExpectedDuration() {
        return this.expectedDuration;
    }

    public Double getExpectedCost() {
        return this.expectedCost;
    }

    public Double getExpectedProbability() {
        return this.expectedProbability;
    }
}

