/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases.riosuite.test;

import fr.emac.gind.bootstrap.test.GindTest;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbProcessToDeploy;
import fr.emac.gind.campaign.manager.data.model.GJaxbResourceType;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.process.instance.GJaxbExecType;
import fr.emac.gind.process.instance.GJaxbRunSync;
import fr.emac.gind.process.instance.GJaxbRunSyncResponse;
import fr.emac.gind.process.instance.ProcessInstance;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHeader;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import fr.emac.gind.usecases.riosuite.test.AbstractRIOProcess;
import fr.emac.gind.usecases.riosuite.test.Scenario;
import fr.emac.gind.workflow.engine.Engine;
import fr.emac.gind.workflow.engine.Execution;
import fr.emac.gind.workflow.engine.Process;
import fr.emac.gind.workflow.engine.compiler.AbstractCompiler;
import fr.emac.gind.workflow.engine.message.Message;
import fr.emac.gind.workflow.engine.message.ParametersUtil;
import fr.emac.gind.workflow.engine.prio.compiler.PRIOCompiler;
import fr.emac.gind.workflow.engine.prio.utils.ProcessInstanceIndicatorHelper;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPort;
import jakarta.xml.ws.Endpoint;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PRIOTest
extends GindTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)PRIOTest.class.getName());
    private final SOAPSender sender = new SOAPSender(new SOAPInterceptor[0]);
    private File processPrio = null;
    protected URL riskUrl = null;
    protected URL projectUrl = null;
    private final List<Scenario> scenarios = new ArrayList<Scenario>();
    private String serverAddress = null;
    private Class<? extends ProcessInstance> engineClass = null;
    protected URL[] otherFiles = null;
    protected String rangeStrategyName = null;

    public PRIOTest(File processXml, String rangeStrategyName, String serverAddress, Class<? extends ProcessInstance> engineClass, URL ... otherFiles) throws Exception {
        this.otherFiles = otherFiles;
        this.rangeStrategyName = rangeStrategyName;
        this.riskUrl = Arrays.asList(this.otherFiles).stream().filter(u -> u.toString().endsWith("objectives.xml")).findAny().get();
        this.projectUrl = Arrays.asList(this.otherFiles).stream().filter(u -> u.toString().endsWith("project.xml")).findAny().get();
        assert (this.projectUrl != null);
        if (rangeStrategyName != null) {
            this.processPrio = new File("./target/process_" + rangeStrategyName + ".prio");
            GJaxbGenericModel originalProcess = (GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().parse(processXml), GJaxbGenericModel.class);
            Document dom = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)originalProcess);
            File newProcessFile = File.createTempFile("newProcess", rangeStrategyName);
            FileUtil.setContents((File)newProcessFile, (String)XMLPrettyPrinter.print((Node)dom));
            FileUtils.copyFile((File)newProcessFile, (File)this.processPrio);
        } else {
            this.processPrio = new File("./target/process.prio");
            FileUtils.copyFile((File)processXml, (File)this.processPrio);
        }
        this.engineClass = engineClass;
        this.serverAddress = serverAddress;
        GJaxbCampaign campaign = new GJaxbCampaign();
        GJaxbProcessToDeploy pd = new GJaxbProcessToDeploy();
        GJaxbResourceType processResource = new GJaxbResourceType();
        GJaxbGenericModel processModel = (GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().parse(this.processPrio), GJaxbGenericModel.class);
        GenericModelManager processModelManager = new GenericModelManager(new GJaxbGenericModel[]{processModel});
        processResource.setGenericModel(processModel);
        processResource.setName("processName");
        pd.setProcess(processResource);
    }

    public void addScenario(Scenario scenario) {
        this.scenarios.add(scenario);
    }

    @Test
    public void excuteAllScenariosWithoutThread() throws Exception {
        for (Scenario scenario : this.scenarios) {
            try {
                LOG.info("Run scenario (" + (this.scenarios.indexOf(scenario) + 1) + "/" + this.scenarios.size() + ") : " + scenario.getName() + " ( expectedDuration = " + scenario.getExpectedDuration() + ", expectedCost = " + scenario.getExpectedCost() + ", expectedProbability = " + scenario.getExpectedProbability() + " )");
                this.executeTestWithoutThreadWithParam(scenario);
                LOG.info("Scenario (" + (this.scenarios.indexOf(scenario) + 1) + "/" + this.scenarios.size() + ") : " + scenario.getName() + " => Successfull !!!");
            }
            catch (Throwable e) {
                LOG.error("Scenario (" + (this.scenarios.indexOf(scenario) + 1) + "/" + this.scenarios.size() + ") : " + scenario.getName() + " => Failed !!!");
                throw e;
            }
        }
    }

    @Test
    public void excuteAllScenariosWS() throws Exception {
        for (Scenario scenario : this.scenarios) {
            try {
                LOG.info("Run scenario (" + (this.scenarios.indexOf(scenario) + 1) + "/" + this.scenarios.size() + ") : " + scenario.getName() + " ( expectedDuration = " + scenario.getExpectedDuration() + ", expectedCost = " + scenario.getExpectedCost() + ", expectedProbability = " + scenario.getExpectedProbability() + " )");
                this.executeTestWSWithParam(scenario);
                LOG.info("Scenario (" + (this.scenarios.indexOf(scenario) + 1) + "/" + this.scenarios.size() + ") : " + scenario.getName() + " => Successfull !!!");
            }
            catch (Throwable e) {
                LOG.error("Scenario (" + (this.scenarios.indexOf(scenario) + 1) + "/" + this.scenarios.size() + ") : " + scenario.getName() + " => Failed !!!");
                throw e;
            }
        }
    }

    private Execution executeTestWithoutThreadWithoutImpedanceAssert(Scenario scenario) throws Exception {
        PRIOCompiler compiler = new PRIOCompiler();
        Configuration conf = new Configuration(Thread.currentThread().getContextClassLoader().getResource("conf/config.properties"));
        Engine engine = new Engine(conf.getProperties(), new AbstractCompiler[]{compiler});
        compiler.initByDefault();
        Process[] processus = compiler.compile(this.processPrio.toURI().toURL(), Thread.currentThread().getContextClassLoader().getResource("wsdl/ProcessInstance.wsdl"), this.otherFiles, null, null);
        Process process = processus[0];
        Message msg = new Message(new QName("http://www.gind.emac.fr/ProcessInstance/", "runSyncRequest"), ((GJaxbTPort)process.getWsdlManger().getServices()[0].getPort().get(0)).getName());
        GJaxbRunSync request = new GJaxbRunSync();
        request.setExecutionType(GJaxbExecType.SIMULATION);
        JSONArray selectedImpedances = this.buildImpedancesSelected("cost", "duration");
        request.getParameter().add(ParametersUtil.createParameter((String)"selectedImpedances", (Object)selectedImpedances));
        request.getParameter().add(ParametersUtil.createParameter((String)"potentialities", scenario.getRisks()));
        request.getParameter().add(ParametersUtil.createParameter((String)"preventiveStrategies", scenario.getPreventiveStrategies()));
        request.getParameter().add(ParametersUtil.createParameter((String)"correctiveStrategies", scenario.getCorrectiveStrategies()));
        request.getParameter().add(ParametersUtil.createParameter((String)"breakpoints", List.of()));
        request.getParameter().add(ParametersUtil.createParameter((String)"rangeStrategyName", (Object)this.rangeStrategyName));
        Map<QName, String> mapOfHeaders = Map.of(new QName("http://fr.emac.gind/", "withoutThread"), "true");
        SOAPHeader header = new SOAPHeader(mapOfHeaders);
        Document soapRequest = SOAPSender.createSOAPMessageRequest((Document)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)request), (SOAPHeader)header);
        msg.setPayload(soapRequest);
        Execution execution = engine.createExecution(process);
        execution.bindMessageToVariable(process, msg);
        execution.getContext().put("inputRequest", request);
        Assertions.assertEquals((Object)Execution.Status.INACTIVE, (Object)execution.getStatus());
        execution.runWithoutThread();
        PRIOTest.validExecution(execution);
        LOG.debug("duration     : " + String.valueOf(execution.getVariableValue("process_duration").getValue(new Execution[]{execution})) + " \texpected: " + scenario.getExpectedDuration());
        return execution;
    }

    private void executeTestWithoutThreadWithParam(Scenario scenario) throws Exception {
        Execution execution = this.executeTestWithoutThreadWithoutImpedanceAssert(scenario);
        Assertions.assertEquals((double)scenario.getExpectedDuration(), (double)((Float)execution.getVariableValue("process_duration").getValue(new Execution[]{execution})).floatValue(), (double)0.001, (String)(scenario.getName() + " failed!!!: Error on duration "));
    }

    public static void validExecution(Execution execution) {
        Assertions.assertEquals((Object)Execution.Status.ENDED, (Object)execution.getStatus());
        Execution[] ee = execution.getAllChildExecutionsRecursively();
        LOG.debug(execution.getName() + " " + String.valueOf(execution.getStatus()) + " on node: " + execution.getCurrentNode().getName());
        for (int i = 0; i < ee.length; ++i) {
            LOG.debug(ee[i].getName() + " " + String.valueOf(ee[i].getStatus()) + " on node: " + execution.getCurrentNode().getName());
        }
        Assertions.assertEquals((long)0L, (long)Arrays.asList(execution.getAllChildExecutionsRecursively()).stream().filter(ex -> !ex.getStatus().equals((Object)Execution.Status.ENDED)).peek(eee -> LOG.debug("PROBLEM WITH THESE EXECUTIONS " + eee.getName() + " " + String.valueOf(eee.getStatus()))).count());
        if (execution.getAllChildExecutionsRecursively().length > 0) {
            Arrays.asList(execution.getAllChildExecutionsRecursively()).forEach(exe -> LOG.debug("PROBLEM WITH " + exe.getName()));
        }
        Assertions.assertEquals((int)0, (int)execution.getAllChildExecutionsRecursively().length);
        Assertions.assertNotNull((Object)execution.getVariableValue("runSyncResponse").getValue(new Execution[]{execution}));
        Assertions.assertTrue((boolean)execution.isProcessCorrectlyEnded());
    }

    private GJaxbRunSyncResponse runProcess(String endpointAddress, GJaxbRunSync request) throws Exception {
        SOAPHeader header = new SOAPHeader((Map)new HashMap<QName, String>(){
            {
                this.put(new QName("http://fr.emac.gind/", "withoutThread"), "true");
            }
        });
        Document resp = this.sender.sendSoapRequest(XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)request), endpointAddress, "http://www.gind.emac.fr/ProcessInstance/runSync", header);
        GJaxbRunSyncResponse response = (GJaxbRunSyncResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)resp), GJaxbRunSyncResponse.class);
        return response;
    }

    private JSONArray buildImpedancesSelected(String ... names) {
        JSONArray selectedImpedances = new JSONArray();
        for (int i = 0; i < names.length; ++i) {
            JSONObject impedance = new JSONObject();
            impedance.put("name", (Object)names[i]);
            impedance.put("selected", true);
            selectedImpedances.put((Object)impedance);
        }
        return selectedImpedances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestWSWithParam(Scenario scenario) throws Exception {
        AbstractRIOProcess engine = (AbstractRIOProcess)this.engineClass.getConstructor(URL.class, URL[].class).newInstance(this.processPrio.toURI().toURL(), this.otherFiles);
        Endpoint server = Endpoint.publish((String)this.serverAddress, (Object)engine);
        try {
            Message msg = new Message(new QName("http://www.gind.emac.fr/ProcessInstance/", "runSyncRequest"), ((GJaxbTPort)engine.getProcess().getWsdlManger().getServices()[0].getPort().get(0)).getName());
            GJaxbRunSync request = new GJaxbRunSync();
            request.getParameter().add(ParametersUtil.createParameter((String)"calculateDuration", (Object)true));
            JSONArray selectedImpedances = this.buildImpedancesSelected("cost", "duration");
            request.getParameter().add(ParametersUtil.createParameter((String)"selectedImpedances", (Object)selectedImpedances));
            request.getParameter().add(ParametersUtil.createParameter((String)"potentialities", scenario.getRisks()));
            request.getParameter().add(ParametersUtil.createParameter((String)"preventiveStrategies", scenario.getPreventiveStrategies()));
            request.getParameter().add(ParametersUtil.createParameter((String)"correctiveStrategies", scenario.getCorrectiveStrategies()));
            request.getParameter().add(ParametersUtil.createParameter((String)"breakpoints", List.of()));
            request.getParameter().add(ParametersUtil.createParameter((String)"rangeStrategyName", (Object)this.rangeStrategyName));
            request.setExecutionType(GJaxbExecType.SIMULATION);
            Document soapRequest = SOAPSender.createSOAPMessageRequest((Document)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)request), null);
            msg.setPayload(soapRequest);
            GJaxbRunSyncResponse response = this.runProcess(this.serverAddress, request);
            Assertions.assertNotNull((Object)response);
            Assertions.assertNotNull((Object)response.getSimulationResults());
            LOG.debug("expected duration " + scenario.getExpectedDuration());
            LOG.debug("actual duration   " + String.valueOf(ProcessInstanceIndicatorHelper.findIndicator((String)"duration", (List)response.getSimulationResults().getSimulationOutputByProcess().getIndicator()).getIndicatorValue().getSimulatedValue()));
            Assertions.assertEquals((double)scenario.getExpectedDuration(), (double)ProcessInstanceIndicatorHelper.findIndicator((String)"duration", (List)response.getSimulationResults().getSimulationOutputByProcess().getIndicator()).getIndicatorValue().getSimulatedValue().getPrecise().floatValue(), (double)0.01, (String)(scenario.getName() + " failed!!!: Error on duration "));
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    @Test
    public void findNumberOfScenarios() throws Exception {
    }
}

