/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases.cep.helper;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.interpretation.config.InterpretationConfigDeployHelper;
import fr.emac.gind.event.interpretation.config.InterpretationConfigsManagerCommandClient;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.event.producer.NotificationProducerWebService;
import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.interpretationconfigs.InterpretationCommand;
import fr.emac.gind.io.interpretation.engine.InterpretationEngineContainer;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbEventAction;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigsResponse;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbSubscriptionRequiredType;
import fr.emac.gind.storage.mongodb.EventStorageWebService;
import fr.emac.gind.storage.mongodb.StorageImpl;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import gind.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CEPClientRunner {
    private static final Logger LOG = LoggerFactory.getLogger((String)CEPClientRunner.class.getName());
    private final GovernanceWebService gov;
    private final InterpretationEngineContainer ieEngine;
    private final EventStorageWebService wsStorage;

    public CEPClientRunner(GovernanceWebService gov, InterpretationEngineContainer ieEngine, EventStorageWebService wsStorage) {
        this.gov = gov;
        this.ieEngine = ieEngine;
        this.wsStorage = wsStorage;
    }

    public static Map.Entry<QName, List<Document>> createEntry(QName topic, String ... msg) {
        List docs = Arrays.asList(msg).stream().map(m -> {
            try {
                return DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(m.getBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        AbstractMap.SimpleEntry<QName, List<Document>> e = new AbstractMap.SimpleEntry<QName, List<Document>>(topic, docs);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GJaxbNotify> runComplexTest(URL ruleFile, int assertCpt, Map.Entry<QName, List<Document>> ... inputEventsPerTopic) throws Exception {
        NotificationProducerWebService producer = new NotificationProducerWebService();
        NotificationConsumerWebService consumer = new NotificationConsumerWebService();
        try {
            GJaxbTopicSetType topicSet = new GJaxbTopicSetType();
            JAXBElement ts = new ObjectFactory().createTopicSet(topicSet);
            for (Map.Entry<QName, List<Document>> e : inputEventsPerTopic) {
                Document doc = DOMUtil.getInstance().newDocument();
                Element newChild = doc.createElementNS(e.getKey().getNamespaceURI(), e.getKey().getLocalPart());
                newChild.setAttributeNS("http://docs.oasis-open.org/wsn/t-1", "wstop:topic", "true");
                doc.adoptNode(newChild);
                doc.appendChild(newChild);
                ((GJaxbTopicSetType)ts.getValue()).getAny().add(doc.getDocumentElement());
            }
            final File topicSetFile = File.createTempFile("temp_", UUID.randomUUID().toString(), new File("target"));
            LOG.debug(XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement(ts)));
            FileUtil.setContents((File)topicSetFile, (String)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement(ts)));
            InterpretationCommand client = InterpretationConfigsManagerCommandClient.createClient((String)this.ieEngine.getAddress(InterpretationConfigsManagerCommandClient.class));
            GJaxbInterpretationConfig rule = (GJaxbInterpretationConfig)XMLJAXBContext.getInstance().unmarshallDocument(ruleFile, GJaxbInterpretationConfig.class);
            GJaxbInterpretationConfigs configs = new GJaxbInterpretationConfigs();
            configs.getInterpretationConfig().add(rule);
            GJaxbDeploy deployRequest = InterpretationConfigDeployHelper.buildRequest((GJaxbInterpretationConfigs)configs, (String)"a", (String)"b", (File[])new File[0]);
            String pa = ((GJaxbSubscriptionRequiredType)rule.getContext().getSubscriptionsRequired().getEntry().get(0)).getEndpointAddressToSubscribe();
            URL url = new URL(pa);
            final String producerAddress = url.getPath().substring(1);
            producer.start((Map)new HashMap<String, Object>(this){
                final /* synthetic */ CEPClientRunner this$0;
                {
                    this.this$0 = this$0;
                    this.put("host", "localhost");
                    this.put("port", 8391);
                    this.put("serviceName", producerAddress);
                    this.put("storage", this.this$0.wsStorage.getAddress(StorageImpl.class));
                    this.put("topicSet", topicSetFile.toURI().toURL().toString());
                }
            });
            GJaxbDeployResponse response = client.deploy(deployRequest);
            Assertions.assertNotNull((Object)response);
            GJaxbGetInterpretationConfigs list = new GJaxbGetInterpretationConfigs();
            list.setCollaborationName("a");
            list.setKnowledgeSpaceName("b");
            GJaxbGetInterpretationConfigsResponse res = client.getInterpretationConfigs(list);
            Assertions.assertEquals((int)1, (int)res.getInterpretationConfig().size());
            final List<GJaxbNotify> notifyList = Collections.synchronizedList(new ArrayList());
            final AbstractNotifierClient notifier = new AbstractNotifierClient(this, "http://localhost:9501/NotifierClient"){

                public void notify(GJaxbNotify notify) {
                    try {
                        LOG.debug("rule output notification received: ");
                        String n = XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)notify));
                        LOG.debug(n);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assertions.fail();
                    }
                    notifyList.add(notify);
                }
            };
            QName outputTopic = ((GJaxbEventAction)rule.getEventAction().get(0)).getTopic();
            LOG.debug("output topic " + String.valueOf(outputTopic));
            consumer.start((Map)new HashMap<String, Object>(this){
                final /* synthetic */ CEPClientRunner this$0;
                {
                    this.this$0 = this$0;
                    this.put("host", "localhost");
                    this.put("port", 9501);
                    this.put("serviceName", "NotifierClient");
                    this.put("notifierClient", notifier);
                }
            });
            String subscriptionId = ((AbstractNotifierClient)consumer.getImplementation(notifier.getClass())).subscribeOn(this.ieEngine.getAddress(NotificationManagerImpl.class), outputTopic);
            Assertions.assertNotNull((Object)subscriptionId);
            Arrays.asList(inputEventsPerTopic).forEach(entry -> ((List)entry.getValue()).stream().forEach(d -> {
                try {
                    ((NotificationManagerImpl)producer.getImplementation(NotificationManagerImpl.class)).getNotifier().sendNotificationOnTopic(d, (QName)entry.getKey(), null, Boolean.valueOf(false));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assertions.fail();
                }
            }));
            while (notifyList.size() < assertCpt) {
                Thread.sleep(1000L);
                System.out.print("-");
            }
            List<GJaxbNotify> list2 = notifyList;
            return list2;
        }
        finally {
            if (consumer != null) {
                consumer.stop();
            }
            if (producer != null) {
                producer.stop();
            }
        }
    }
}

