/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.commons.utils.date.LocalDateTimeHelper;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.humantask.GJaxbGetTodoListResponse;
import fr.emac.gind.humantask.GJaxbTask;
import fr.emac.gind.humantask.GJaxbUpdateTask;
import fr.emac.gind.humantask.GJaxbUpdateTaskResponse;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.dw.resources.HumanTaskResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/generic-application/onlyget")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OnlyGetResource {
    private static Logger LOG = LoggerFactory.getLogger((String)OnlyGetResource.class.getName());
    private Configuration conf = null;
    private Humantask htClient = null;
    private ModelsResource modelsResource = null;
    private HumanTaskResource humanResource = null;

    public OnlyGetResource(Configuration conf, ModelsResource modelsResource, HumanTaskResource humanResource) throws Exception {
        this.conf = conf;
        this.modelsResource = modelsResource;
        this.humanResource = humanResource;
    }

    @GET
    @Path(value="/checkTaskDone")
    public String checkTaskDone(@QueryParam(value="personId") String personId, @QueryParam(value="taskName") String taskName, @QueryParam(value="collaborationName") String collaborationName, @QueryParam(value="knowledgeSpaceName") String knowledgeSpaceName) throws Exception {
        DWUser defaultAdmin = new DWUser(SystemResource.getDEFAULT_ADMIN(), true, null);
        defaultAdmin.setCurrentCollaborationName(collaborationName);
        defaultAdmin.setCurrentKnowledgeSpaceName(knowledgeSpaceName);
        GJaxbGetTodoListResponse todoListResponse = this.humanResource.todoList(defaultAdmin, personId, personId, false);
        GJaxbTask taskFound = null;
        for (GJaxbTask task : todoListResponse.getTodoList().getTask()) {
            if (!GenericModelHelper.getName((GJaxbNode)task.getNode()).equals(taskName)) continue;
            taskFound = task;
            break;
        }
        if (taskFound == null) {
            throw new Exception("No task with name '" + taskName + "' found");
        }
        GenericModelHelper.findProperty((String)"Acceptance", (List)taskFound.getNode().getProperty(), (boolean)true).setValue("ACCEPT");
        GenericModelHelper.findProperty((String)"Achieved", (List)taskFound.getNode().getProperty(), (boolean)true).setValue("DONE");
        GenericModelHelper.findProperty((String)"end", (List)taskFound.getNode().getProperty(), (boolean)true).setValue(LocalDateTimeHelper.isoString((LocalDateTime)LocalDateTime.now()));
        GJaxbUpdateTask request = new GJaxbUpdateTask();
        request.setCollaborationName(collaborationName);
        request.setKnowledgeSpaceName(knowledgeSpaceName);
        request.setTask(taskFound);
        request.setDeployedTaskId(taskFound.getDeployedTaskId());
        GJaxbUpdateTaskResponse response = this.humanResource.updateTask(defaultAdmin, request);
        return JSONJAXBContext.getInstance().marshallAnyElement((Object)response);
    }
}

