/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbAddEdge;
import fr.emac.gind.gov.core_gov.GJaxbAddEdgeResponse;
import fr.emac.gind.gov.core_gov.GJaxbAddNode;
import fr.emac.gind.gov.core_gov.GJaxbAddNodeResponse;
import fr.emac.gind.gov.core_gov.GJaxbGetEdge;
import fr.emac.gind.gov.core_gov.GJaxbGetEdgeResponse;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNodeResponse;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.gov.core_gov.GJaxbRemoveEdge;
import fr.emac.gind.gov.core_gov.GJaxbRemoveEdgeResponse;
import fr.emac.gind.gov.core_gov.GJaxbRemoveNode;
import fr.emac.gind.gov.core_gov.GJaxbRemoveNodeResponse;
import fr.emac.gind.gov.core_gov.GJaxbUpdateEdge;
import fr.emac.gind.gov.core_gov.GJaxbUpdateEdgeResponse;
import fr.emac.gind.gov.core_gov.GJaxbUpdateNode;
import fr.emac.gind.gov.core_gov.GJaxbUpdateNodeResponse;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.rio.dw.resources.gov.bo.FindNodesParameters;
import fr.emac.gind.rio.dw.resources.gov.bo.FindParameters;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/generic-application/core")
@Produces(value={"application/json"})
public class CoreResource {
    private static Logger LOG = LoggerFactory.getLogger((String)CoreResource.class.getName());
    private CoreGov coreClient = null;

    public CoreResource(Configuration conf) throws Exception {
        this.coreClient = CoreGovClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovCore"));
    }

    @POST
    @Path(value="/nodes")
    @Consumes(value={"application/json"})
    public GJaxbNode addNode(@Auth DWUser user, GJaxbNode node) throws Exception {
        GJaxbAddNodeResponse response = null;
        try {
            GJaxbAddNode request = new GJaxbAddNode();
            if (!node.isSetId()) {
                node.setId("node_" + UUID.randomUUID().toString());
            }
            request.setNode(node);
            request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            if (user != null) {
                request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            }
            if (node.getType().equals(new QName("http://fr.emac.gind/system", "User"))) {
                request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            }
            response = this.coreClient.addNode(request);
            node.setId(response.getId());
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return node;
    }

    @PUT
    @Path(value="/nodes")
    @Consumes(value={"application/json"})
    public GJaxbNode updateNode(@Auth DWUser user, GJaxbNode node) throws Exception {
        GJaxbUpdateNodeResponse response = null;
        try {
            GJaxbUpdateNode request = new GJaxbUpdateNode();
            request.setNode(node);
            request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            if (user != null) {
                request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            }
            request.setCreateIfNotExist(true);
            if (node.getType().equals(new QName("http://fr.emac.gind/system", "User"))) {
                request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                request.setCreateIfNotExist(false);
            }
            response = this.coreClient.updateNode(request);
            node.setId(response.getId());
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return node;
    }

    @POST
    @Path(value="/nodes/getNode")
    public GJaxbGetNodeResponse getNode(@Auth DWUser user, GJaxbGetNode request) throws Exception {
        GJaxbGetNodeResponse response = null;
        try {
            LOG.debug("id = " + request.getId());
            if (user != null) {
                request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.coreClient.getNode(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/nodes/findNodesByTypesAndOrProperties")
    public List<GJaxbNode> findNodesByTypesAndOrPropertiesRest(@Auth DWUser user, FindNodesParameters params) throws Exception {
        return this.findNodesByTypesAndOrProperties(user, params.getTypes(), params.getProperties(), params.getStatus(), params.getCollaborationName(), params.getKnowledgeSpaceName());
    }

    /*
     * WARNING - void declaration
     */
    public List<GJaxbNode> findNodesByTypesAndOrProperties(@Auth DWUser user, @QueryParam(value="types") List<QName> types, @QueryParam(value="properties") List<FindParameters> properties, @QueryParam(value="node_status") List<String> node_status, String collaborationName, String knowlegeSpaceName) throws Exception {
        ArrayList<GJaxbNode> nodes = new ArrayList<GJaxbNode>();
        try {
            void var10_20;
            if (user != null && !user.isAdmin() && user.getCurrentCollaborationName() == null) {
                throw new Exception("CollaborationName cannot be null for a user");
            }
            Object queryMsg = "";
            if (types != null && types.size() > 0) {
                queryMsg = (String)queryMsg + "(";
                for (QName qName : types) {
                    String queryType = "n:`" + qName.toString() + "`";
                    queryMsg = (String)queryMsg + queryType + " OR ";
                }
                queryMsg = ((String)queryMsg).substring(0, ((String)queryMsg).length() - " OR ".length());
                queryMsg = (String)queryMsg + ")";
            }
            Object queryProperties = "";
            if (properties != null && !properties.isEmpty()) {
                for (FindParameters prop : properties) {
                    Object operator = " = ";
                    String rightExp = "'" + prop.getValue() + "'";
                    if (prop.getOperator() == null || "equals".equals(prop.getOperator())) {
                        operator = " = ";
                        rightExp = "'" + prop.getValue() + "'";
                    } else if (prop.getOperator() != null && "contains".equals(prop.getOperator())) {
                        operator = " =~ ";
                        rightExp = "'.*" + prop.getValue() + ".*'";
                    }
                    queryProperties = (String)queryProperties + "n.`property_" + prop.getName() + "`" + (String)operator + rightExp + " AND ";
                }
                queryProperties = ((String)queryProperties).substring(0, ((String)queryProperties).length() - " AND ".length());
            }
            if (!((String)queryProperties).isEmpty()) {
                queryMsg = !((String)queryMsg).isEmpty() ? (String)queryMsg + " AND (" + (String)queryProperties + ")" : (String)queryMsg + "(" + (String)queryProperties + ")";
            }
            String string = "";
            if (node_status != null && !node_status.isEmpty()) {
                String string2 = "n:";
                boolean first = true;
                for (String status : node_status) {
                    void var10_16;
                    if (first) {
                        String string3 = (String)var10_16 + "`" + status + "`";
                        first = false;
                        continue;
                    }
                    String string4 = (String)var10_16 + "|`" + status + "`";
                }
            }
            if (!var10_20.isEmpty()) {
                queryMsg = !((String)queryMsg).isEmpty() ? (String)queryMsg + " AND (" + (String)var10_20 + ")" : (String)queryMsg + "(" + (String)var10_20 + ")";
            }
            GJaxbQuery query = new GJaxbQuery();
            if (collaborationName != null && !collaborationName.isBlank() && knowlegeSpaceName != null && !knowlegeSpaceName.isBlank()) {
                match = "n:`" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "`&`" + RegExpHelper.toRegexFriendlyName((String)knowlegeSpaceName) + "`";
                query.setQuery("match (" + (String)match + ") where " + (String)queryMsg + " return n; ");
            } else if (user != null) {
                match = "n";
                query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                if (user.getCurrentCollaborationName() != null) {
                    query.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                    match = (String)match + ":`" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName()) + "`";
                }
                if (user.getCurrentKnowledgeSpaceName() != null) {
                    query.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
                    match = (String)match + "&`" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentKnowledgeSpaceName()) + "`";
                }
                query.setQuery("match (" + (String)match + ") where " + (String)queryMsg + " return n; ");
            } else {
                query.setQuery("match (n) where " + (String)queryMsg + " return n; ");
            }
            GJaxbQueryResponse queryResponse = this.coreClient.query(query);
            if (queryResponse != null && queryResponse.getSingle() != null && queryResponse.getSingle().getGenericModel() != null) {
                nodes.addAll(queryResponse.getSingle().getGenericModel().getNode());
            }
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return nodes;
    }

    @DELETE
    @Path(value="/nodes/{id}")
    public GJaxbRemoveNodeResponse deleteNode(@Auth DWUser user, @PathParam(value="id") String id, @QueryParam(value="qid") String qid) throws Exception {
        GJaxbRemoveNodeResponse response = null;
        assert (user != null);
        try {
            LOG.debug("id = " + id);
            LOG.debug("qId = " + qid);
            GJaxbRemoveNode request = new GJaxbRemoveNode();
            if (qid != null) {
                request.setId(qid);
            } else {
                request.setId(id);
            }
            request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
            request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            response = this.coreClient.removeNode(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    public GJaxbAddEdgeResponse addEdge(DWUser user, GJaxbEdge edge, String sourceId, String targetId) throws Exception {
        GJaxbAddEdgeResponse response = null;
        try {
            GJaxbAddEdge request = new GJaxbAddEdge();
            request.setEdge(edge);
            request.setSourceNodeId(sourceId);
            request.setTargetNodeId(targetId);
            request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            if (user != null) {
                request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.coreClient.addEdge(request);
            edge.setId(response.getId());
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/edges")
    @Consumes(value={"application/json"})
    public GJaxbEdge addEdge(@Auth DWUser user, GJaxbEdge edge) throws Exception {
        GJaxbAddEdgeResponse response = this.addEdge(user, edge, edge.getSource().getId(), edge.getTarget().getId());
        return edge;
    }

    @PUT
    @Path(value="/edges")
    @Consumes(value={"application/json"})
    public GJaxbEdge updateEdge(@Auth DWUser user, GJaxbUpdateEdge requestEdge) throws Exception {
        GJaxbUpdateEdgeResponse response = null;
        assert (user != null);
        try {
            response = this.coreClient.updateEdge(requestEdge);
            requestEdge.getEdge().setId(response.getId());
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return requestEdge.getEdge();
    }

    @POST
    @Path(value="/edges/getEdge")
    public GJaxbGetEdgeResponse getEdge(@Auth DWUser user, GJaxbGetEdge request) throws Exception {
        GJaxbGetEdgeResponse response = null;
        assert (user != null);
        try {
            LOG.debug("id = " + request.getId());
            if (user != null) {
                request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.coreClient.getEdge(request);
            response.getEdge().setSource(null);
            response.getEdge().setTarget(null);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @DELETE
    @Path(value="/edges/{id}")
    public GJaxbRemoveEdgeResponse deleteEdge(@Auth DWUser user, @PathParam(value="id") String id, @QueryParam(value="qid") String qid) throws Exception {
        GJaxbRemoveEdgeResponse response = null;
        assert (user != null);
        try {
            LOG.debug("id = " + id);
            LOG.debug("qId = " + qid);
            GJaxbRemoveEdge request = new GJaxbRemoveEdge();
            if (qid != null) {
                request.setId(qid);
            } else {
                request.setId(id);
            }
            request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
            request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            response = this.coreClient.removeEdge(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    public CoreGov getCoreClient() {
        return this.coreClient;
    }
}

