/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.Neo4JClient;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.neo4j.GJaxbQuery;
import fr.emac.gind.neo4j.GJaxbQueryResponse;
import fr.emac.gind.neo4j.Neo4J;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path(value="/{app}/generic-application/neo4j")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class Neo4JResource {
    private Neo4J neo4jClient = null;

    public Neo4JResource(Configuration conf) throws Exception {
        this.neo4jClient = Neo4JClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovNeo4J"));
    }

    @POST
    @Path(value="/query")
    public GJaxbQueryResponse query(@Auth DWUser user, GJaxbQuery query) throws Exception {
        assert (user != null);
        GJaxbQueryResponse response = null;
        try {
            response = this.neo4jClient.query(query);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }
}

