/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.bundles;

import fr.emac.gind.generic.application.bundles.AbstractModifierResource;
import io.dropwizard.servlets.assets.ByteRange;
import io.dropwizard.servlets.assets.ResourceURL;
import io.dropwizard.util.Resources;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetInterceptorServlet
extends HttpServlet {
    private static final long serialVersionUID = 6393345594784987908L;
    private Map<String, AbstractModifierResource> mapModifiers = null;
    private static Logger LOG = LoggerFactory.getLogger((String)AssetInterceptorServlet.class.getName());
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_RANGE = "If-Range";
    private static final String RANGE = "Range";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String ETAG = "ETag";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String DEFAULT_MEDIA_TYPE = "text/html";
    private final String resourcePath;
    private final String uriPath;
    @Nullable
    private final String indexFile;
    private final String defaultMediaType;
    @Nullable
    private final Charset defaultCharset;

    public AssetInterceptorServlet(String resourcePath, String uriPath, @Nullable String indexFile, @Nullable Charset defaultCharset, Map<String, AbstractModifierResource> mapModifiers) {
        this(resourcePath, uriPath, indexFile, DEFAULT_MEDIA_TYPE, defaultCharset, mapModifiers);
    }

    public AssetInterceptorServlet(String resourcePath, String uriPath, @Nullable String indexFile, @Nullable String defaultMediaType, @Nullable Charset defaultCharset, Map<String, AbstractModifierResource> mapModifiers) {
        String trimmedPath = AssetInterceptorServlet.trimSlashes(resourcePath);
        this.resourcePath = trimmedPath.isEmpty() ? trimmedPath : trimmedPath + "/";
        String trimmedUri = AssetInterceptorServlet.trimTrailingSlashes(uriPath);
        this.uriPath = trimmedUri.isEmpty() ? "/" : trimmedUri;
        this.indexFile = indexFile;
        this.defaultMediaType = defaultMediaType == null ? DEFAULT_MEDIA_TYPE : defaultMediaType;
        this.defaultCharset = defaultCharset;
        this.mapModifiers = mapModifiers;
    }

    private static String trimSlashes(String s) {
        Matcher matcher = Pattern.compile("^/*(.*?)/*$").matcher(s);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return s;
    }

    private static String trimTrailingSlashes(String s) {
        Matcher matcher = Pattern.compile("(.*?)/*$").matcher(s);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return s;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    @Nullable
    public String getIndexFile() {
        return this.indexFile;
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    @Nullable
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            try {
                String ifRange;
                CachedAsset cachedAsset;
                StringBuilder builder = new StringBuilder(req.getServletPath());
                if (req.getPathInfo() != null) {
                    builder.append(req.getPathInfo());
                }
                if ((cachedAsset = this.loadAsset(builder.toString(), req)) == null) {
                    resp.sendError(404);
                    return;
                }
                if (this.isCachedClientSide(req, cachedAsset)) {
                    resp.sendError(304);
                    return;
                }
                String rangeHeader = req.getHeader(RANGE);
                int resourceLength = cachedAsset.getResource().length;
                List<Object> ranges = Collections.emptyList();
                boolean usingRanges = false;
                if (rangeHeader != null && ((ifRange = req.getHeader(IF_RANGE)) == null || cachedAsset.getETag().equals(ifRange))) {
                    ranges = this.parseRangeHeader(rangeHeader, resourceLength);
                    if (ranges.isEmpty()) {
                        resp.sendError(416);
                        return;
                    }
                    resp.setStatus(206);
                    usingRanges = true;
                    String byteRanges = ranges.stream().map(ByteRange::toString).collect(Collectors.joining(","));
                    resp.addHeader(CONTENT_RANGE, "bytes " + byteRanges + "/" + resourceLength);
                }
                resp.setDateHeader(LAST_MODIFIED, cachedAsset.getLastModifiedTime());
                resp.setHeader(ETAG, cachedAsset.getETag());
                String requestUri = req.getRequestURI();
                String mediaType = Optional.ofNullable(req.getServletContext().getMimeType((String)(this.indexFile != null && requestUri.endsWith("/") ? requestUri + this.indexFile : requestUri))).orElse(this.defaultMediaType);
                if (mediaType.startsWith("video") || mediaType.startsWith("audio") || usingRanges) {
                    resp.addHeader(ACCEPT_RANGES, "bytes");
                }
                resp.setContentType(mediaType);
                if (this.defaultCharset != null) {
                    resp.setCharacterEncoding(this.defaultCharset.toString());
                }
                try (ServletOutputStream output = resp.getOutputStream();){
                    if (usingRanges) {
                        for (ByteRange byteRange : ranges) {
                            output.write(cachedAsset.getResource(), byteRange.getStart(), byteRange.getEnd() - byteRange.getStart() + 1);
                        }
                    } else {
                        output.write(cachedAsset.getResource());
                    }
                }
            }
            catch (RuntimeException | URISyntaxException ignored) {
                if (resp.isCommitted()) break block18;
                resp.reset();
                resp.setStatus(404);
            }
        }
    }

    @Nullable
    private CachedAsset loadAsset(String key, HttpServletRequest req) throws URISyntaxException, IOException {
        if (!((String)key).startsWith(this.uriPath) || ((String)key).startsWith("/generic-application")) {
            throw new IllegalArgumentException("Cache key must start with " + this.uriPath + " or /generic-application");
        }
        if (((String)key).startsWith("/generic-application")) {
            key = ((String)key).replace("/generic-application/webjars", this.uriPath);
        }
        if (((String)key).contains("(") && ((String)key).contains(")")) {
            key = ((String)key).substring(0, ((String)key).indexOf("(")) + "index.html";
        }
        String requestedResourcePath = AssetInterceptorServlet.trimSlashes(((String)key).substring(this.uriPath.length()));
        String absoluteRequestedResourcePath = AssetInterceptorServlet.trimSlashes(this.resourcePath + requestedResourcePath);
        List<AbstractModifierResource> modifiers = this.findModifiers(absoluteRequestedResourcePath);
        LOG.info("absoluteRequestedResourcePath = " + absoluteRequestedResourcePath);
        byte[] buffer = null;
        long lastModified = System.currentTimeMillis();
        if (!(absoluteRequestedResourcePath.contains("/webjars/resourcesFolder") || absoluteRequestedResourcePath.contains("/generatePages/") || absoluteRequestedResourcePath.contains("/generatePagesWithMultipleContext/"))) {
            if (!absoluteRequestedResourcePath.contains("/NEXUS")) {
                Object requestedResourceURL = this.getResourceURL(absoluteRequestedResourcePath);
                lastModified = ResourceURL.getLastModified((URL)requestedResourceURL);
                if (lastModified < 1L) {
                    lastModified = System.currentTimeMillis();
                }
                lastModified = lastModified / 1000L * 1000L;
                requestedResourceURL = Resources.getResource((String)absoluteRequestedResourcePath);
                if (ResourceURL.isDirectory((URL)requestedResourceURL)) {
                    if (this.indexFile != null) {
                        requestedResourceURL = this.getResourceURL(absoluteRequestedResourcePath + "/" + this.indexFile);
                    } else {
                        return null;
                    }
                }
                buffer = this.readResource((URL)requestedResourceURL);
            } else {
                buffer = this.getNexusResource(absoluteRequestedResourcePath, req.getQueryString());
            }
        }
        try {
            if (modifiers != null && !modifiers.isEmpty()) {
                for (AbstractModifierResource modifier : modifiers) {
                    byte[] newBuffer;
                    if (buffer != null) {
                        newBuffer = modifier.replace((String)key, buffer);
                        if (newBuffer == null) continue;
                        buffer = newBuffer;
                        continue;
                    }
                    newBuffer = modifier.replace((String)key, null);
                    if (newBuffer == null) continue;
                    buffer = newBuffer;
                }
            } else {
                LOG.warn("Impossible to find modifier for: " + requestedResourcePath);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        return new CachedAsset(buffer, lastModified);
    }

    private byte[] getNexusResource(String requestedResourcePath, String queryString) throws IOException {
        byte[] buffer = null;
        if (requestedResourcePath.contains("/NEXUS")) {
            try {
                String nexusUrl = queryString.substring(queryString.indexOf("private_resource=") + "private_resource=".length());
                String login = System.getenv().get("RIO_MEDIA_LOGIN");
                String pwd = System.getenv().get("RIO_MEDIA_PWD");
                if (login == null || pwd == null) {
                    throw new IOException("RIO_MEDIA_LOGIN and/or RIO_MEDIA_PWD are not correctly set !!!");
                }
                String encoding = Base64.getEncoder().encodeToString((login + ":" + pwd).getBytes("UTF-8"));
                Client client = ClientBuilder.newClient();
                WebTarget webTarget = client.target(nexusUrl);
                Invocation.Builder invocationBuilder = webTarget.request(new String[]{"*/*"});
                invocationBuilder.header("Authorization", (Object)("Basic " + encoding));
                Response response = invocationBuilder.get();
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    LOG.debug("Success! " + response.getStatus());
                    LOG.debug(String.valueOf(response.getEntity()));
                    InputStream downloadFile = (InputStream)response.readEntity(InputStream.class);
                    buffer = downloadFile.readAllBytes();
                } else {
                    LOG.debug("ERROR! " + response.getStatus());
                    LOG.debug(String.valueOf(response.getEntity()));
                    InputStream downloadFile = (InputStream)response.readEntity(InputStream.class);
                    buffer = downloadFile.readAllBytes();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        return buffer;
    }

    private List<AbstractModifierResource> findModifiers(String requestedResourceURL) {
        ArrayList<AbstractModifierResource> acceptedModifiers = new ArrayList<AbstractModifierResource>();
        if (this.mapModifiers != null) {
            for (AbstractModifierResource modifier : this.mapModifiers.values()) {
                if (!modifier.accept(requestedResourceURL)) continue;
                acceptedModifiers.add(modifier);
            }
        }
        return acceptedModifiers;
    }

    protected URL getResourceURL(String absoluteRequestedResourcePath) {
        return Resources.getResource((String)absoluteRequestedResourcePath);
    }

    protected byte[] readResource(URL requestedResourceURL) throws IOException {
        try (InputStream inputStream = requestedResourceURL.openStream();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    private boolean isCachedClientSide(HttpServletRequest req, CachedAsset cachedAsset) {
        String ifNoneMatchHeader = req.getHeader(IF_NONE_MATCH);
        if (ifNoneMatchHeader != null) {
            return cachedAsset.getETag().equals(ifNoneMatchHeader);
        }
        return req.getDateHeader(IF_MODIFIED_SINCE) >= cachedAsset.getLastModifiedTime();
    }

    private List<ByteRange> parseRangeHeader(String rangeHeader, int resourceLength) {
        try {
            String[] parts;
            List<Object> byteRanges = rangeHeader.contains("=") ? ((parts = rangeHeader.split("=", -1)).length > 1 ? Arrays.stream(parts[1].split(",", -1)).map(String::trim).map(s -> ByteRange.parse((String)s, (int)resourceLength)).collect(Collectors.toList()) : Collections.emptyList()) : Collections.emptyList();
            return byteRanges;
        }
        catch (NumberFormatException e) {
            return Collections.emptyList();
        }
    }

    private static class CachedAsset {
        private final byte[] resource;
        private final String eTag;
        private final long lastModifiedTime;

        private CachedAsset(byte[] resource, long lastModifiedTime) {
            this.resource = resource;
            this.eTag = "\"" + CachedAsset.hash(resource) + "\"";
            this.lastModifiedTime = lastModifiedTime;
        }

        private static String hash(byte[] resource) {
            CRC32 crc32 = new CRC32();
            crc32.update(resource);
            return Long.toHexString(crc32.getValue());
        }

        public byte[] getResource() {
            return this.resource;
        }

        public String getETag() {
            return this.eTag;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }
    }
}

