/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.rest.HTTPClientUtil;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.ai.chatbot.client.AIChatbotClient;
import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.ai_chatbot.FaultMessage;
import fr.emac.gind.gov.ai_chatbot.GJaxbExportDocumentsFromRAG;
import fr.emac.gind.gov.ai_chatbot.GJaxbExportDocumentsFromRAGResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbExternalResourceType;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesFromPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesFromPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventActualitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventBuildings;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventBuildingsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventCodeExplanation;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventCodeExplanationResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctions;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventFunctionsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGoods;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGoodsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGroups;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventGroupsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventIots;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventIotsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPersons;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPersonsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPositionFromTerritory;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPositionFromTerritoryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotential;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialities;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventPotentialitiesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNews;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNewsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoads;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoadsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRoles;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesFromObjectives;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesFromObjectivesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventRolesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensors;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventSensorsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTerritories;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTerritoriesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTweets;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventTweetsResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbLoadDocumentsForRAG;
import fr.emac.gind.gov.ai_chatbot.GJaxbLoadDocumentsForRAGResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbQuery;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectory;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectoryResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevel;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevelResponse;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.metamodel.GJaxbModelingViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.dw.resources.FileResource;
import fr.emac.gind.tweet.GJaxbMediaObject;
import fr.emac.gind.tweet.GJaxbTweetObject;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.ByteArrayInputStream;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/generic-application/aichatbot")
@Produces(value={"application/json"})
public class AIChatbotResource
implements AiChatbot {
    private static Logger LOG = LoggerFactory.getLogger((String)AIChatbotResource.class.getName());
    private AiChatbot chatbotClient = null;
    private FileResource fileResource = null;
    private String riopiotAddress = null;

    public AIChatbotResource(Configuration conf, FileResource fileResource) throws Exception {
        this.chatbotClient = AIChatbotClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovAIChatbot"));
        this.fileResource = fileResource;
        if (conf.getMapObjects().containsKey("tools_r-iopiot")) {
            this.riopiotAddress = conf.getMapObjects().get("tools_r-iopiot").toString();
        }
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    public GJaxbQueryResponse query(@Auth DWUser user, GJaxbQuery parameters) throws FaultMessage {
        return this.query(parameters);
    }

    @POST
    @Path(value="/inventFunctions")
    @Consumes(value={"application/json"})
    public String inventFunctions(@Auth DWUser user, GJaxbInventFunctions parameters) throws Exception {
        GJaxbInventFunctionsResponse res = this.inventFunctions(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventFunctionsResponse").toString();
    }

    @POST
    @Path(value="/inventRoles")
    @Consumes(value={"application/json"})
    public String inventRoles(@Auth DWUser user, GJaxbInventRoles parameters) throws Exception {
        GJaxbInventRolesResponse res = this.inventRoles(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventRolesResponse").toString();
    }

    @POST
    @Path(value="/inventRolesFromObjectives")
    @Consumes(value={"application/json"})
    public String inventRolesFromObjectives(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventRolesFromObjectives parameters = (GJaxbInventRolesFromObjectives)JSONJAXBContext.getInstance().unmarshall("{ \"inventRolesFromObjectives\": " + jsonRequest + " }", GJaxbInventRolesFromObjectives.class);
        GJaxbInventRolesFromObjectivesResponse res = this.inventRolesFromObjectives(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventRolesFromObjectivesResponse").toString();
    }

    @POST
    @Path(value="/inventActualities")
    @Consumes(value={"application/json"})
    public String inventActualities(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventActualities parameters = (GJaxbInventActualities)JSONJAXBContext.getInstance().unmarshall("{ \"inventActualities\": " + jsonRequest + " }", GJaxbInventActualities.class);
        GJaxbInventActualitiesResponse res = this.inventActualities(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventActualitiesResponse").toString();
    }

    @POST
    @Path(value="/inventPotentialities")
    @Consumes(value={"application/json"})
    public String inventPotentialities(@Auth DWUser user, GJaxbInventPotentialities parameters) throws Exception {
        GJaxbInventPotentialitiesResponse res = this.inventPotentialities(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventPotentialitiesResponse").toString();
    }

    @POST
    @Path(value="/inventPotential")
    @Consumes(value={"application/json"})
    public String inventPotential(@Auth DWUser user, GJaxbInventPotential parameters) throws Exception {
        GJaxbInventPotentialResponse res = this.inventPotential(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventPotentialResponse").toString();
    }

    @POST
    @Path(value="/inventPersons")
    @Consumes(value={"application/json"})
    public String inventPersons(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventPersons parameters = (GJaxbInventPersons)JSONJAXBContext.getInstance().unmarshall("{ \"inventPersons\":" + jsonRequest + "}", GJaxbInventPersons.class);
        GJaxbInventPersonsResponse res = this.inventPersons(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventPersonsResponse").toString();
    }

    @POST
    @Path(value="/inventGoods")
    @Consumes(value={"application/json"})
    public String inventGoods(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventGoods parameters = (GJaxbInventGoods)JSONJAXBContext.getInstance().unmarshall("{ \"inventGoods\":" + jsonRequest + "}", GJaxbInventGoods.class);
        GJaxbInventGoodsResponse res = this.inventGoods(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventGoodsResponse").toString();
    }

    @POST
    @Path(value="/inventBuildings")
    @Consumes(value={"application/json"})
    public String inventBuildings(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventBuildings parameters = (GJaxbInventBuildings)JSONJAXBContext.getInstance().unmarshall("{ \"inventBuildings\":" + jsonRequest + "}", GJaxbInventBuildings.class);
        GJaxbInventBuildingsResponse res = this.inventBuildings(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventBuildingsResponse").toString();
    }

    public GJaxbInventBuildingsResponse inventBuildings(GJaxbInventBuildings parameters) throws FaultMessage {
        return this.chatbotClient.inventBuildings(parameters);
    }

    @POST
    @Path(value="/inventRoads")
    @Consumes(value={"application/json"})
    public String inventRoads(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventRoads parameters = (GJaxbInventRoads)JSONJAXBContext.getInstance().unmarshall("{ \"inventRoads\":" + jsonRequest + "}", GJaxbInventRoads.class);
        GJaxbInventRoadsResponse res = this.inventRoads(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventBuildingsResponse").toString();
    }

    @POST
    @Path(value="/inventGroups")
    @Consumes(value={"application/json"})
    public String inventGroups(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventGroups parameters = (GJaxbInventGroups)JSONJAXBContext.getInstance().unmarshall("{ \"inventGroups\":" + jsonRequest + "}", GJaxbInventGroups.class);
        GJaxbInventGroupsResponse res = this.inventGroups(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventGroupsResponse").toString();
    }

    @POST
    @Path(value="/inventTerritories")
    @Consumes(value={"application/json"})
    public String inventTerritories(@Auth DWUser user, GJaxbInventTerritories parameters) throws Exception {
        GJaxbInventTerritoriesResponse res = this.inventTerritories(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventTerritoriesResponse").toString();
    }

    @POST
    @Path(value="/inventSensors")
    @Consumes(value={"application/json"})
    public String inventSensors(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventSensors parameters = (GJaxbInventSensors)JSONJAXBContext.getInstance().unmarshall("{ \"inventSensors\":" + jsonRequest + "}", GJaxbInventSensors.class);
        GJaxbInventSensorsResponse res = this.inventSensors(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventSensorsResponse").toString();
    }

    @POST
    @Path(value="/inventIots")
    @Consumes(value={"application/json"})
    public String inventIots(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventIots parameters = (GJaxbInventIots)JSONJAXBContext.getInstance().unmarshall("{ \"inventIots\":" + jsonRequest + "}", GJaxbInventIots.class);
        GJaxbInventIotsResponse res = this.inventIots(parameters);
        this.uploadResources(user, res.getGenericModel(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventIotsResponse").toString();
    }

    @POST
    @Path(value="/inventPositionFromTerritory")
    @Consumes(value={"application/json"})
    public String inventPositionFromTerritory(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventPositionFromTerritory parameters = (GJaxbInventPositionFromTerritory)JSONJAXBContext.getInstance().unmarshall("{ \"inventPositionFromTerritory\":" + jsonRequest + "}", GJaxbInventPositionFromTerritory.class);
        GJaxbInventPositionFromTerritoryResponse res = this.inventPositionFromTerritory(parameters);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventPositionFromTerritoryResponse").toString();
    }

    @POST
    @Path(value="/inventTweets")
    @Consumes(value={"application/json"})
    public String inventTweets(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventTweets parameters = (GJaxbInventTweets)JSONJAXBContext.getInstance().unmarshall("{ \"inventTweets\":" + jsonRequest + "}", GJaxbInventTweets.class);
        GJaxbInventTweetsResponse res = this.inventTweets(parameters);
        this.uploadTweetResources(user, res.getTweet(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventTweetsResponse").toString();
    }

    @POST
    @Path(value="/inventPictures")
    @Consumes(value={"application/json"})
    public String inventPictures(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventPictures parameters = (GJaxbInventPictures)JSONJAXBContext.getInstance().unmarshall("{ \"inventPictures\":" + jsonRequest + "}", GJaxbInventPictures.class);
        GJaxbInventPicturesResponse res = this.inventPictures(parameters);
        this.uploadPictureResources(user, res.getPictureOutput(), res.getExternalResource());
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventPicturesResponse").toString();
    }

    @POST
    @Path(value="/similarityLevel")
    @Consumes(value={"application/json"})
    public String similarityLevel(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbSimilarityLevel parameters = (GJaxbSimilarityLevel)JSONJAXBContext.getInstance().unmarshall("{ \"similarityLevel\":" + jsonRequest + "}", GJaxbSimilarityLevel.class);
        GJaxbSimilarityLevelResponse res = this.similarityLevel(parameters);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("similarityLevelResponse").toString();
    }

    @POST
    @Path(value="/loadDocumentsForRAG")
    @Consumes(value={"application/json"})
    public String loadDocumentsForRAG(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbLoadDocumentsForRAG parameters = (GJaxbLoadDocumentsForRAG)JSONJAXBContext.getInstance().unmarshall("{ \"loadDocumentsForRAG\":" + jsonRequest + "}", GJaxbLoadDocumentsForRAG.class);
        GJaxbLoadDocumentsForRAGResponse res = this.loadDocumentsForRAG(parameters);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("loadDocumentsForRAGResponse").toString();
    }

    @POST
    @Path(value="/exportDocumentsFromRAG")
    @Consumes(value={"application/json"})
    public String exportDocumentsFromRAG(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbExportDocumentsFromRAG parameters = (GJaxbExportDocumentsFromRAG)JSONJAXBContext.getInstance().unmarshall("{ \"exportDocumentsFromRAG\":" + jsonRequest + "}", GJaxbExportDocumentsFromRAG.class);
        GJaxbExportDocumentsFromRAGResponse res = this.exportDocumentsFromRAG(parameters);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("exportDocumentsFromRAGResponse").toString();
    }

    @POST
    @Path(value="/restoreRAGFromDirectory")
    @Consumes(value={"application/json"})
    public String restoreRAGFromDirectory(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbRestoreRAGFromDirectory parameters = (GJaxbRestoreRAGFromDirectory)JSONJAXBContext.getInstance().unmarshall("{ \"restoreRAGFromDirectory\":" + jsonRequest + "}", GJaxbRestoreRAGFromDirectory.class);
        GJaxbRestoreRAGFromDirectoryResponse res = this.restoreRAGFromDirectory(parameters);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("restoreRAGFromDirectoryResponse").toString();
    }

    public GJaxbQueryResponse query(GJaxbQuery parameters) throws FaultMessage {
        return this.chatbotClient.query(parameters);
    }

    public GJaxbInventRolesResponse inventRoles(GJaxbInventRoles parameters) throws FaultMessage {
        return this.chatbotClient.inventRoles(parameters);
    }

    public GJaxbInventActualitiesResponse inventActualities(GJaxbInventActualities parameters) throws FaultMessage {
        return this.chatbotClient.inventActualities(parameters);
    }

    public GJaxbInventPersonsResponse inventPersons(GJaxbInventPersons parameters) throws FaultMessage {
        return this.chatbotClient.inventPersons(parameters);
    }

    public GJaxbInventTerritoriesResponse inventTerritories(GJaxbInventTerritories parameters) throws FaultMessage {
        return this.chatbotClient.inventTerritories(parameters);
    }

    public GJaxbSimilarityLevelResponse similarityLevel(GJaxbSimilarityLevel parameters) throws FaultMessage {
        return this.chatbotClient.similarityLevel(parameters);
    }

    public GJaxbInventGroupsResponse inventGroups(GJaxbInventGroups parameters) throws FaultMessage {
        return this.chatbotClient.inventGroups(parameters);
    }

    public GJaxbInventPotentialitiesResponse inventPotentialities(GJaxbInventPotentialities parameters) throws FaultMessage {
        return this.chatbotClient.inventPotentialities(parameters);
    }

    public GJaxbInventPotentialResponse inventPotential(GJaxbInventPotential parameters) throws FaultMessage {
        return this.chatbotClient.inventPotential(parameters);
    }

    public GJaxbInventFunctionsResponse inventFunctions(GJaxbInventFunctions parameters) throws FaultMessage {
        return this.chatbotClient.inventFunctions(parameters);
    }

    public GJaxbInventSensorsResponse inventSensors(GJaxbInventSensors parameters) throws FaultMessage {
        return this.chatbotClient.inventSensors(parameters);
    }

    public GJaxbInventActualitiesFromPicturesResponse inventActualitiesFromPictures(GJaxbInventActualitiesFromPictures parameters) throws FaultMessage {
        return this.chatbotClient.inventActualitiesFromPictures(parameters);
    }

    public GJaxbQueryOnPicturesResponse queryOnPictures(GJaxbQueryOnPictures parameters) throws FaultMessage {
        return this.chatbotClient.queryOnPictures(parameters);
    }

    public GJaxbInventPositionFromTerritoryResponse inventPositionFromTerritory(GJaxbInventPositionFromTerritory parameters) throws FaultMessage {
        return this.chatbotClient.inventPositionFromTerritory(parameters);
    }

    public GJaxbInventTweetsResponse inventTweets(GJaxbInventTweets parameters) throws FaultMessage {
        return this.chatbotClient.inventTweets(parameters);
    }

    public GJaxbInventPicturesResponse inventPictures(GJaxbInventPictures parameters) throws FaultMessage {
        return this.chatbotClient.inventPictures(parameters);
    }

    public GJaxbInventIotsResponse inventIots(GJaxbInventIots parameters) throws FaultMessage {
        return this.chatbotClient.inventIots(parameters);
    }

    public GJaxbInventRolesFromObjectivesResponse inventRolesFromObjectives(GJaxbInventRolesFromObjectives parameters) throws FaultMessage {
        return this.chatbotClient.inventRolesFromObjectives(parameters);
    }

    private void uploadPictureResources(DWUser user, List<GJaxbInventPicturesResponse.PictureOutput> pictureOutputs, List<GJaxbExternalResourceType> rscs) throws Exception {
        for (GJaxbExternalResourceType extRsc : rscs) {
            for (GJaxbInventPicturesResponse.PictureOutput pictureOutput : pictureOutputs) {
                if (!extRsc.getId().equals(pictureOutput.getPictureId())) continue;
                String fileName = pictureOutput.getPictureId() + extRsc.getContentType().replace("image/", ".");
                JSONObject data = new JSONObject();
                data.put("nodeId", (Object)pictureOutput.getPictureId());
                data.put("category", (Object)"pictures");
                data.put("collaborationName", (Object)user.getCurrentCollaborationName());
                data.put("knowledgeSpaceName", (Object)user.getCurrentKnowledgeSpaceName());
                data.put("fileName", (Object)fileName);
                String url = this.fileResource.upload(user, new ByteArrayInputStream(extRsc.getData()), FormDataContentDisposition.name((String)fileName).build(), data.toString());
                pictureOutput.setPictureUrl(url);
            }
        }
        rscs.clear();
    }

    private void uploadTweetResources(DWUser user, List<GJaxbTweetObject> tweets, List<GJaxbExternalResourceType> rscs) throws Exception {
        ArrayList<GJaxbInventPicturesResponse.PictureOutput> pictureOutputs = new ArrayList<GJaxbInventPicturesResponse.PictureOutput>();
        for (GJaxbTweetObject tweet : tweets) {
            for (GJaxbMediaObject media : tweet.getExtendedEntities().getMedia()) {
                GJaxbInventPicturesResponse.PictureOutput po = new GJaxbInventPicturesResponse.PictureOutput();
                po.setPictureId(media.getIdStr());
                po.setPictureUrl(media.getMediaUrl());
                pictureOutputs.add(po);
            }
        }
        this.uploadPictureResources(user, pictureOutputs, rscs);
        for (GJaxbInventPicturesResponse.PictureOutput po : pictureOutputs) {
            for (GJaxbTweetObject tweet : tweets) {
                for (GJaxbMediaObject media : tweet.getExtendedEntities().getMedia()) {
                    if (!po.getPictureId().equals(media.getIdStr())) continue;
                    media.setMediaUrl(po.getPictureUrl());
                }
            }
        }
        rscs.clear();
    }

    private void uploadResources(DWUser user, GJaxbGenericModel model, List<GJaxbExternalResourceType> rscs) throws Exception {
        for (GJaxbExternalResourceType extRsc : rscs) {
            String nodeId = extRsc.getId().split("::")[0];
            String propertyName = extRsc.getId().split("::")[1];
            GJaxbNode node = GenericModelHelper.findNodeById((String)nodeId, (List)model.getNode());
            String instanceName = GenericModelHelper.findProperty((String)"name", (List)node.getProperty()).getValue();
            String fileName = "photo_" + UUID.randomUUID().toString() + RegExpHelper.toRegexFriendlyName((String)instanceName).hashCode() + extRsc.getContentType().replace("image/", ".");
            JSONObject data = new JSONObject();
            data.put("nodeId", (Object)nodeId);
            data.put("category", (Object)"node");
            data.put("collaborationName", (Object)user.getCurrentCollaborationName());
            data.put("knowledgeSpaceName", (Object)user.getCurrentKnowledgeSpaceName());
            data.put("fileName", (Object)fileName);
            String url = this.fileResource.upload(user, new ByteArrayInputStream(extRsc.getData()), FormDataContentDisposition.name((String)fileName).build(), data.toString());
            if (!node.isSetModeling()) {
                node.setModeling(new GJaxbNode.Modeling());
            }
            if (node.getModeling().getItemView().isEmpty()) {
                GJaxbNode.Modeling.ItemView iv2 = new GJaxbNode.Modeling.ItemView();
                iv2.setViewId("view_" + UUID.randomUUID().toString());
                iv2.setPosition(new GJaxbPosition());
                iv2.setPackageName("UNDEFINED");
                node.getModeling().getItemView().add(iv2);
            }
            if (node.isSetModeling() && node.getModeling().isSetItemView()) {
                node.getModeling().getItemView().forEach(iv -> {
                    if (iv != null) {
                        if (!iv.isSetSpecificModeling()) {
                            iv.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
                        }
                        if (!iv.getSpecificModeling().isSetNodeMetaModeling()) {
                            iv.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
                        }
                        if (!iv.getSpecificModeling().getNodeMetaModeling().isSetModelingViewDefinition()) {
                            iv.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
                        }
                        if (!iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().isSetView()) {
                            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
                        }
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(url);
                    }
                });
            }
            if (!node.isSetGeolocation() || !node.getGeolocation().isSetItemView()) continue;
            node.getGeolocation().getItemView().forEach(iv -> {
                if (iv != null && iv.getPoint() != null) {
                    if (!iv.isSetSpecificGeolocation()) {
                        iv.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                    }
                    if (!iv.getSpecificGeolocation().isSetNodeMetaGeolocation()) {
                        iv.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                    }
                    if (!iv.getSpecificGeolocation().getNodeMetaGeolocation().isSetPoint()) {
                        iv.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                    }
                    iv.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(url);
                }
            });
        }
        rscs.clear();
    }

    @GET
    @Path(value="/getRiopiotContext")
    @Consumes(value={"application/json"})
    public String getRiopiotContext(@Auth DWUser user) throws Exception {
        String riopiotConfBuffer = null;
        try {
            HttpResponse response = HTTPClientUtil.sendHTTPRequest((HTTPClientUtil.HTTPProtocol)HTTPClientUtil.HTTPProtocol.GET, (String)(this.riopiotAddress + "/api/context/applicationContext"), null, null, null, null);
            riopiotConfBuffer = (String)response.body();
            System.out.println("riopiotConfBuffer = " + riopiotConfBuffer);
        }
        catch (Throwable e) {
            LOG.warn("RIOPIOT IS NOT CONNECTED !!!");
            return null;
        }
        return riopiotConfBuffer;
    }

    @POST
    @Path(value="/inventCodeExplanation")
    @Consumes(value={"application/json"})
    public String inventCodeExplanation(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbInventCodeExplanation parameters = (GJaxbInventCodeExplanation)JSONJAXBContext.getInstance().unmarshall("{ \"inventCodeExplanation\":" + jsonRequest + "}", GJaxbInventCodeExplanation.class);
        GJaxbInventCodeExplanationResponse res = this.inventCodeExplanation(parameters);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)res)).get("inventCodeExplanationResponse").toString();
    }

    public GJaxbInventCodeExplanationResponse inventCodeExplanation(GJaxbInventCodeExplanation parameters) throws FaultMessage {
        return this.chatbotClient.inventCodeExplanation(parameters);
    }

    public GJaxbInventRoadsResponse inventRoads(GJaxbInventRoads parameters) throws FaultMessage {
        return this.chatbotClient.inventRoads(parameters);
    }

    public GJaxbInventGoodsResponse inventGoods(GJaxbInventGoods parameters) throws FaultMessage {
        return this.chatbotClient.inventGoods(parameters);
    }

    public GJaxbLoadDocumentsForRAGResponse loadDocumentsForRAG(GJaxbLoadDocumentsForRAG parameters) throws FaultMessage {
        return this.chatbotClient.loadDocumentsForRAG(parameters);
    }

    public GJaxbExportDocumentsFromRAGResponse exportDocumentsFromRAG(GJaxbExportDocumentsFromRAG parameters) throws FaultMessage {
        return this.chatbotClient.exportDocumentsFromRAG(parameters);
    }

    public GJaxbRestoreRAGFromDirectoryResponse restoreRAGFromDirectory(GJaxbRestoreRAGFromDirectory parameters) throws FaultMessage {
        return this.chatbotClient.restoreRAGFromDirectory(parameters);
    }

    public GJaxbInventProblemsFromNewsResponse inventProblemsFromNews(GJaxbInventProblemsFromNews parameters) throws FaultMessage {
        return this.chatbotClient.inventProblemsFromNews(parameters);
    }
}

