/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.generic.application.GindError;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class GindWebApplicationException
extends WebApplicationException {
    private static final long serialVersionUID = 1L;

    private GindWebApplicationException(Exception e, Response.Status status, Method method) {
        super(Response.status((Response.Status)status).entity((Object)GindWebApplicationException.createGindError(e, status, method)).type("application/json").build());
        e.printStackTrace();
    }

    private static GindError createGindError(Exception e, Response.Status status, Method method) {
        GindError error = new GindError();
        error.setMessage(e.getMessage());
        error.setStackTrace(ExceptionUtils.getStackTrace((Throwable)e));
        error.setMethod(method.getName());
        error.setClazz(method.getDeclaringClass().getName());
        error.setStatus(String.valueOf(status.getStatusCode()));
        error.setStatusMessage(status.toString());
        return error;
    }

    public static void manageError(Exception e, Object currentMethod) throws Exception {
        if (e instanceof GindWebApplicationException) {
            throw e;
        }
        throw new GindWebApplicationException(e, Response.Status.INTERNAL_SERVER_ERROR, ReflectionHelper.getCurrentMethod((Object)currentMethod));
    }
}

