/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.bundles.modifier;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.generic.application.bundles.AbstractModifierResource;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.usecase.GJaxbLocationType;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.usecases.RIOUsecasesManager;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalModifierResource
extends AbstractModifierResource {
    private static Logger LOG = LoggerFactory.getLogger(ExternalModifierResource.class);
    private Configuration conf = null;
    private String applicationName = null;

    public ExternalModifierResource(String applicationName, Configuration conf) {
        super("resourcesFolder", RIOConstant.WEBJARS_RESOURCES_FOLDER);
        this.conf = conf;
        this.applicationName = applicationName;
        File rscFolder = new File(RIOConstant.RESOURCES_FOLDER);
        rscFolder.mkdirs();
    }

    @Override
    public byte[] replace(String url, byte[] buffer) throws Exception {
        String friendlyProjectName = null;
        String collaborationName = null;
        String urlRsc = url.replace("/" + this.applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER, "");
        if ("resources".equals(urlRsc.split("/")[2])) {
            collaborationName = urlRsc.split("/")[0];
            friendlyProjectName = urlRsc.split("/")[1];
        } else if ("resources".equals(urlRsc.split("/")[1])) {
            friendlyProjectName = urlRsc.split("/")[0];
        } else {
            System.out.println("Strange URL");
        }
        RIOAbstractProject project = null;
        if (friendlyProjectName != null) {
            project = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).findAvailableUsecaseByFriendlyName(friendlyProjectName, false, null);
        }
        byte[] newBuffer = null;
        String genericFilefilePath = url.replace("/" + this.applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER, RIOConstant.RESOURCES_FOLDER + "/");
        File genericFile = new File(genericFilefilePath);
        LOG.debug("**** genericFilefilePath: " + genericFilefilePath);
        if (genericFile.exists()) {
            newBuffer = FileUtils.readFileToByteArray((File)genericFile);
        } else {
            if (friendlyProjectName != null) {
                if (project == null || project.getUsecaseDef().getLocation().equals((Object)GJaxbLocationType.EMBEDDED)) {
                    String rscPath = "META-INF/resources/webjars/gind/usecases/" + friendlyProjectName + url.substring(url.indexOf(friendlyProjectName) + friendlyProjectName.length());
                    LOG.debug("rscPath = " + rscPath);
                    URL rsc = Thread.currentThread().getContextClassLoader().getResource(rscPath);
                    if (rsc != null) {
                        newBuffer = IOUtils.toByteArray((InputStream)rsc.openStream());
                    }
                }
                if (newBuffer == null) {
                    String filePath = null;
                    if (url.contains("/" + this.applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER + friendlyProjectName) && project != null) {
                        filePath = url.replace("/" + this.applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER + friendlyProjectName, project.getRootDirectory());
                    } else if (url.contains("/" + this.applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER)) {
                        filePath = url.replace("/" + this.applicationName + RIOConstant.WEBJARS_RESOURCES_FOLDER, RIOConstant.RESOURCES_FOLDER + "/");
                    }
                    LOG.debug("filePath = " + filePath);
                    if (new File(filePath).exists()) {
                        newBuffer = FileUtils.readFileToByteArray((File)new File(filePath));
                    }
                }
            }
            if (newBuffer == null) {
                if (url.endsWith(".jpeg") || url.endsWith(".jpg") || url.endsWith(".png")) {
                    LOG.warn("Impossible to find resource: " + url);
                } else {
                    throw new Exception("Impossible to find resource: " + url);
                }
            }
        }
        return newBuffer;
    }

    @Override
    public boolean accept(String requestedResourceURL) {
        return this.getResourcePatterns().get(0).equals("resourcesFolder") && requestedResourceURL.toString().contains(this.getResourcePatterns().get(1));
    }
}

