/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationFactoryFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.Cli;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.util.Generics;
import jakarta.validation.Validator;
import java.io.IOException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class ConfiguredCommandWithoutLog<T extends Configuration>
extends Command {
    private boolean asynchronous = false;
    private T configuration;

    protected ConfiguredCommandWithoutLog(String name, String description) {
        super(name, description);
    }

    protected Class<T> getConfigurationClass() {
        return Generics.getTypeParameter(((Object)((Object)this)).getClass(), Configuration.class);
    }

    public void configure(Subparser subparser) {
        this.addFileArgument(subparser);
    }

    protected Argument addFileArgument(Subparser subparser) {
        return subparser.addArgument(new String[]{"file"}).nargs("?").help("application configuration file");
    }

    public void run(Bootstrap<?> wildcardBootstrap, Namespace namespace) throws Exception {
        Bootstrap<?> bootstrap = wildcardBootstrap;
        this.configuration = this.parseConfiguration(bootstrap.getConfigurationFactoryFactory(), bootstrap.getConfigurationSourceProvider(), bootstrap.getValidatorFactory().getValidator(), namespace.getString("file"), this.getConfigurationClass(), bootstrap.getObjectMapper());
        try {
            this.run(bootstrap, namespace, this.configuration);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (!this.asynchronous) {
                this.cleanup();
            }
        }
    }

    protected void cleanupAsynchronously() {
        this.asynchronous = true;
    }

    protected void cleanup() {
        if (this.configuration != null) {
            this.configuration.getLoggingFactory().stop();
        }
    }

    protected void run(Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
    }

    private T parseConfiguration(ConfigurationFactoryFactory<T> configurationFactoryFactory, ConfigurationSourceProvider provider, Validator validator, String path, Class<T> klass, ObjectMapper objectMapper) throws IOException, ConfigurationException {
        ConfigurationFactory configurationFactory = configurationFactoryFactory.create(klass, validator, objectMapper, "dw");
        if (path != null) {
            return (T)((Configuration)configurationFactory.build(provider, path));
        }
        return (T)((Configuration)configurationFactory.build());
    }

    public void onError(Cli cli, Namespace namespace, Throwable e) {
        super.onError(cli, namespace, e);
        throw new RuntimeException(e.getMessage(), e);
    }
}

