/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.users;

import fr.emac.gind.gov.system_gov.GJaxbUpdateUser;
import fr.emac.gind.gov.system_gov.SystemGov;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class DWUser
implements Principal {
    private static final long serialVersionUID = 1L;
    private static Map<String, GJaxbNode> USER_REGISTRY = Collections.synchronizedMap(new HashMap());
    private String userId = null;
    private boolean isFake = false;
    private SystemGov systemClient = null;

    public DWUser(GJaxbNode user, SystemGov systemClient) {
        this.userId = user.getId();
        USER_REGISTRY.put(this.userId, user);
        this.systemClient = systemClient;
    }

    public DWUser(GJaxbNode user, boolean isFake, SystemGov systemClient) {
        this.userId = user.getId();
        USER_REGISTRY.put(this.userId, user);
        this.isFake = isFake;
        this.systemClient = systemClient;
    }

    public boolean isFake() {
        return this.isFake;
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getName() {
        return GenericModelHelper.findProperty((String)"firstName", (List)USER_REGISTRY.get(this.userId).getProperty()).getValue() + " " + GenericModelHelper.findProperty((String)"lastName", (List)USER_REGISTRY.get(this.userId).getProperty()).getValue();
    }

    public GJaxbNode getUser() {
        return USER_REGISTRY.get(this.userId);
    }

    public void setUser(GJaxbNode user) throws Exception {
        if (!this.userId.equals(user.getId())) {
            throw new Exception("Invalid User Id !!!");
        }
        USER_REGISTRY.put(this.userId, user);
        GJaxbUpdateUser reqUser = new GJaxbUpdateUser();
        reqUser.setNode(user);
        this.systemClient.updateUser(reqUser);
    }

    public boolean isAdmin() {
        JSONObject roles = new JSONObject(GenericModelHelper.findProperty((String)"roles", (List)USER_REGISTRY.get(this.userId).getProperty()).getValue());
        return roles.getJSONObject("admin").getBoolean("checked");
    }

    public String getPassword() {
        return GenericModelHelper.findProperty((String)"password", (List)USER_REGISTRY.get(this.userId).getProperty()).getValue();
    }

    public String getEmail() {
        return GenericModelHelper.findProperty((String)"email", (List)USER_REGISTRY.get(this.userId).getProperty()).getValue();
    }

    public String getPropertyValue(String propertyName) {
        return GenericModelHelper.findProperty((String)propertyName, (List)USER_REGISTRY.get(this.userId).getProperty(), (boolean)true).getValue();
    }

    public String getCurrentCollaborationName() {
        return GenericModelHelper.findProperty((String)"currentCollaborationName", (List)USER_REGISTRY.get(this.userId).getProperty()) != null ? GenericModelHelper.findProperty((String)"currentCollaborationName", (List)USER_REGISTRY.get(this.userId).getProperty()).getValue() : null;
    }

    public String getCurrentKnowledgeSpaceName() {
        return GenericModelHelper.findProperty((String)"currentKnowledgeSpaceName", (List)USER_REGISTRY.get(this.userId).getProperty()) != null ? GenericModelHelper.findProperty((String)"currentKnowledgeSpaceName", (List)USER_REGISTRY.get(this.userId).getProperty()).getValue() : null;
    }

    public void setCurrentCollaborationName(String collab) throws Exception {
        GenericModelHelper.findProperty((String)"currentCollaborationName", (List)USER_REGISTRY.get(this.userId).getProperty(), (boolean)true).setValue(collab);
        if (!this.isFake) {
            GJaxbUpdateUser reqUser = new GJaxbUpdateUser();
            reqUser.setNode(USER_REGISTRY.get(this.userId));
            this.systemClient.updateUser(reqUser);
        }
    }

    public void setCurrentKnowledgeSpaceName(String knowledge) throws Exception {
        GenericModelHelper.findProperty((String)"currentKnowledgeSpaceName", (List)USER_REGISTRY.get(this.userId).getProperty(), (boolean)true).setValue(knowledge);
        if (!this.isFake) {
            GJaxbUpdateUser reqUser = new GJaxbUpdateUser();
            reqUser.setNode(USER_REGISTRY.get(this.userId));
            this.systemClient.updateUser(reqUser);
        }
    }

    public static GJaxbNode getAlreadyLoggedUser(String userId) {
        return USER_REGISTRY.get(userId);
    }
}

