/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.event.interpretation.config.InterpretationConfigDeployHelper;
import fr.emac.gind.event.interpretation.config.InterpretationConfigsManagerCommandClient;
import fr.emac.gind.event.interpretation.predict.PredictCommandClient;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.interpretationconfigs.InterpretationCommand;
import fr.emac.gind.interpretationconfigs.PredictCommand;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbContext;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResult;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigResponse;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigsResponse;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbPredict;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.model.interpretation.config.GJaxbSubscriptionRequiredType;
import fr.emac.gind.model.interpretation.config.GJaxbUndeploy;
import fr.emac.gind.model.interpretation.config.GJaxbUndeployResponse;
import fr.emac.gind.rio.dw.resources.gov.bo.InterpretationConfigByUrl;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Path(value="/{app}/r-ioga/interpretation_rules")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class InterpretationRulesResource {
    private static Logger LOG = LoggerFactory.getLogger((String)InterpretationRulesResource.class.getName());
    private InterpretationCommand interpretationClient = null;
    private PredictCommand predictClient = null;
    private String eventProducerAgentBrokerAddress = null;
    private boolean isAlreadyRegistering = false;
    private Configuration conf = null;

    public InterpretationRulesResource(Configuration conf) throws Exception {
        this.conf = conf;
        if (conf.getProperties().get("interpretation-engine") != null) {
            this.interpretationClient = InterpretationConfigsManagerCommandClient.createClient((String)((String)conf.getProperties().get("interpretation-engine")).replace("/InterpretationEngine", "/LowLevelInterpretationManager"));
            this.predictClient = PredictCommandClient.createClient((String)((String)conf.getProperties().get("interpretation-engine")).replace("/InterpretationEngine", "/LowLevelInterpretationManager"));
            this.eventProducerAgentBrokerAddress = (String)conf.getProperties().get("event-broker");
        }
    }

    @POST
    @Path(value="/importRule")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String importRule(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        JSONObject response = new JSONObject();
        try {
            Document doc = DOMUtil.getInstance().parse(is);
            GJaxbInterpretationConfig cep = (GJaxbInterpretationConfig)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbInterpretationConfig.class);
            List<GJaxbInterpretationConfig> rules = Arrays.asList(cep);
            this.addRules(user, rules);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response.toString();
    }

    @POST
    @Path(value="/addRules")
    public String addRules(@Auth DWUser user, List<GJaxbInterpretationConfig> rules) throws Exception {
        String res = null;
        try {
            Object validMessage = "";
            String errorMessage = "";
            for (GJaxbInterpretationConfig rule : rules) {
                try {
                    if (rule.isSetCepRule() || rule.isSetMlConfig()) {
                        this.changeBrokerVariableByBrokerAddress(rule);
                        GJaxbInterpretationConfigs configs = new GJaxbInterpretationConfigs();
                        if (!rule.isSetContext()) {
                            rule.setContext(new GJaxbContext());
                        }
                        rule.getContext().setCollaborationName(user.getCurrentCollaborationName());
                        rule.getContext().setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                        configs.getInterpretationConfig().add(rule);
                        GJaxbDeploy request = InterpretationConfigDeployHelper.buildRequest((GJaxbInterpretationConfigs)configs, (String)user.getCurrentCollaborationName(), (String)user.getCurrentKnowledgeSpaceName(), (File[])new File[0]);
                        request.setResourcesFolderBaseDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
                        GJaxbDeployResponse response = this.interpretationClient.deploy(request);
                        validMessage = (String)validMessage + "rule '" + rule.getName() + "' loaded!!!\n";
                        continue;
                    }
                    LOG.warn("Rule not loaded : '" + rule.getName() + "' !!!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOG.error("Error on rule '" + rule.getName() + "' !!!\n", (Throwable)e);
                    GindWebApplicationException.manageError(e, this);
                }
            }
            if (!errorMessage.trim().isEmpty()) {
                throw new Exception(errorMessage);
            }
            JSONObject resp = new JSONObject();
            resp.put("message", validMessage);
            res = resp.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return res;
    }

    @POST
    @Path(value="/addRulesFromURL")
    public String addRulesFromURL(@Auth DWUser user, List<InterpretationConfigByUrl> rules) throws Exception {
        ArrayList<GJaxbInterpretationConfig> resRules = new ArrayList<GJaxbInterpretationConfig>();
        if (rules != null) {
            for (InterpretationConfigByUrl _rule : rules) {
                GJaxbInterpretationConfig rule = (GJaxbInterpretationConfig)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(_rule.getUrl()).toURL(), GJaxbInterpretationConfig.class);
                resRules.add(rule);
            }
        }
        return this.addRules(user, resRules);
    }

    private void changeBrokerVariableByBrokerAddress(GJaxbInterpretationConfig rule) throws Exception {
        if (rule.getContext() != null && rule.getContext().getSubscriptionsRequired() != null) {
            for (GJaxbSubscriptionRequiredType subs : rule.getContext().getSubscriptionsRequired().getEntry()) {
                if (subs.getEndpointAddressToSubscribe() == null) {
                    subs.setEndpointAddressToSubscribe(this.eventProducerAgentBrokerAddress);
                    continue;
                }
                if (subs.getEndpointAddressToSubscribe() == null || !subs.getEndpointAddressToSubscribe().trim().equals("${eventProducerAgentBroker}")) continue;
                subs.setEndpointAddressToSubscribe(this.eventProducerAgentBrokerAddress);
            }
        }
    }

    private void changeBrokerAddressByBrokerVariable(GJaxbInterpretationConfig rule) throws Exception {
        if (rule.getContext() != null && rule.getContext().getSubscriptionsRequired() != null) {
            for (GJaxbSubscriptionRequiredType subs : rule.getContext().getSubscriptionsRequired().getEntry()) {
                if (subs.getEndpointAddressToSubscribe() == null) {
                    subs.setEndpointAddressToSubscribe("${eventProducerAgentBroker}");
                    continue;
                }
                if (subs.getEndpointAddressToSubscribe() == null || !subs.getEndpointAddressToSubscribe().trim().equals(this.eventProducerAgentBrokerAddress)) continue;
                subs.setEndpointAddressToSubscribe("${eventProducerAgentBroker}");
            }
        }
    }

    @GET
    @Path(value="/rules")
    public List<GJaxbInterpretationConfig> getRules(@Auth DWUser user) throws Exception {
        ArrayList<GJaxbInterpretationConfig> rules = new ArrayList<GJaxbInterpretationConfig>();
        String collaborationName = user.getCurrentCollaborationName();
        String knowledgespaceName = user.getCurrentKnowledgeSpaceName();
        try {
            GJaxbGetInterpretationConfigs request = new GJaxbGetInterpretationConfigs();
            request.setCollaborationName(collaborationName);
            request.setKnowledgeSpaceName(knowledgespaceName);
            GJaxbGetInterpretationConfigsResponse response = this.interpretationClient.getInterpretationConfigs(request);
            for (GJaxbInterpretationConfig rule : response.getInterpretationConfig()) {
                this.changeBrokerAddressByBrokerVariable(rule);
                rule.getContext().setCollaborationName(null);
                rule.getContext().setKnowledgeSpaceName(null);
                rules.add(rule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return rules;
    }

    @GET
    @Path(value="/rule")
    public GJaxbGetInterpretationConfigResponse getRule(@Auth DWUser user, @QueryParam(value="id") String ruleId) throws Exception {
        GJaxbGetInterpretationConfigResponse response = null;
        GJaxbInterpretationConfig rule = null;
        String collaborationName = user.getCurrentCollaborationName();
        String knowledgespaceName = user.getCurrentKnowledgeSpaceName();
        try {
            GJaxbGetInterpretationConfig request = new GJaxbGetInterpretationConfig();
            request.setCollaborationName(collaborationName);
            request.setKnowledgeSpaceName(knowledgespaceName);
            request.setRuleId(ruleId);
            response = this.interpretationClient.getInterpretationConfig(request);
            rule = response.getInterpretationConfig();
            if (rule != null) {
                this.changeBrokerAddressByBrokerVariable(rule);
                rule.getContext().setCollaborationName(null);
                rule.getContext().setKnowledgeSpaceName(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @DELETE
    @Path(value="/deleteRules")
    public GJaxbUndeployResponse deleteRules(@Auth DWUser user, List<GJaxbInterpretationConfig> rules) throws Exception {
        try {
            String collaborationName = user.getCurrentCollaborationName();
            String knowledgespaceName = user.getCurrentKnowledgeSpaceName();
            GJaxbUndeploy request = new GJaxbUndeploy();
            request.setCollaborationName(collaborationName);
            request.setKnowledgeSpaceName(knowledgespaceName);
            request.setRequest(new GJaxbDeployResult());
            for (GJaxbInterpretationConfig rule : rules) {
                request.getRequest().getRuleId().add(rule.getId());
            }
            request.setResourcesFolderBaseDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
            GJaxbUndeployResponse response = this.interpretationClient.undeploy(request);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
            return null;
        }
    }

    @DELETE
    @Path(value="/deleteRule")
    public GJaxbUndeployResponse deleteRule(@Auth DWUser user, @QueryParam(value="ruleId") String ruleId) throws Exception {
        try {
            String collaborationName = user.getCurrentCollaborationName();
            String knowledgespaceName = user.getCurrentKnowledgeSpaceName();
            GJaxbUndeploy request = new GJaxbUndeploy();
            request.setCollaborationName(collaborationName);
            request.setKnowledgeSpaceName(knowledgespaceName);
            request.setRequest(new GJaxbDeployResult());
            request.getRequest().getRuleId().add(ruleId);
            request.setResourcesFolderBaseDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
            GJaxbUndeployResponse response = this.interpretationClient.undeploy(request);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
            return null;
        }
    }

    @POST
    @Path(value="/predict")
    public String predict(@Auth DWUser user, GJaxbPredict request) throws Exception {
        assert (user != null);
        String response = null;
        try {
            request.getPredictInputs().getProperty().forEach(p -> {
                if (p.getValue() != null) {
                    byte[] bytes = StringUtils.getBytesUtf8((String)p.getValue().replaceAll("[^\\p{ASCII}]", ""));
                    String utf8EncodedString = StringUtils.newStringUtf8((byte[])bytes);
                    p.setValue(utf8EncodedString);
                }
            });
            request.setResourcesFolderBaseDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
            GJaxbPredictResponse resp = this.predictClient.predict(request);
            response = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)resp)).get("predictResponse").toString();
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }
}

