/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioga;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.eventtype.GJaxbDeductionProgressEvent;
import fr.emac.gind.gov.deduction.DeduceFault;
import fr.emac.gind.gov.deduction.DeductionCallBack;
import fr.emac.gind.gov.deduction.GJaxbDeductionASyncCallBackResponse;
import fr.emac.gind.gov.deduction.GJaxbDeductionASyncCallBackResponseResponse;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="deductionSOAPCallBackEndpoint", serviceName="deductionCallBackService", targetNamespace="http://www.gind.emac.fr/gov/deduction/", wsdlLocation="wsdl/deduction.wsdl", endpointInterface="fr.emac.gind.gov.deduction.DeductionCallBack")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class DeductionSolutionASyncCallBackSOAPImpl
implements DeductionCallBack {
    private static final Logger LOG = LoggerFactory.getLogger((String)DeductionSolutionASyncCallBackSOAPImpl.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;

    public DeductionSolutionASyncCallBackSOAPImpl(WebsocketCommand WEB_SOCKET_COMMAND) {
        this.WEB_SOCKET_COMMAND = WEB_SOCKET_COMMAND;
    }

    @WebMethod(action="http://www.gind.emac.fr/gov/deduction/deductionASyncCallBackResponse")
    @WebResult(name="deductionASyncCallBackResponseResponse", targetNamespace="http://www.gind.emac.fr/gov/deduction/", partName="parameters")
    public GJaxbDeductionASyncCallBackResponseResponse deductionASyncCallBackResponse(@WebParam(name="deductionASyncCallBackResponse", targetNamespace="http://www.gind.emac.fr/gov/deduction/", partName="parameters") GJaxbDeductionASyncCallBackResponse parameters) throws DeduceFault {
        LOG.info("Executing operation sendASyncResponse");
        LOG.debug(String.valueOf(parameters));
        try {
            String collaborationName = parameters.getDeductionProgress().getCollaborationName();
            String knowledgeName = parameters.getDeductionProgress().getKnowledgeSpaceName();
            GJaxbDeductionProgressEvent event = new GJaxbDeductionProgressEvent();
            event.setCollaborationName(collaborationName);
            event.setKnowledgeSpaceName(knowledgeName);
            event.setDeductionProgress(parameters.getDeductionProgress());
            GJaxbGetResult request = new GJaxbGetResult();
            request.setWebsocketId("/deductionResponseCallback/" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName));
            request.setJsonResult("{ \"event\" : " + JSONJAXBContext.getInstance().marshallAnyElement((Object)event) + "}");
            this.WEB_SOCKET_COMMAND.getResult(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return new GJaxbDeductionASyncCallBackResponseResponse();
    }
}

