/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotificationMessageHolderType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class EventBrokerNotifier
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)EventBrokerNotifier.class.getName());
    private WebsocketCommand command = null;

    public EventBrokerNotifier(String address, WebsocketCommand command) throws Exception {
        super(address);
        this.command = command;
    }

    public void notify(GJaxbNotify notify) {
        try {
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            QName topic = QName.valueOf(((GJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getTopic().getContent().get(0).toString());
            Map mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
            Element context = (Element)mapInfo.get(new QName("http://www.gind.emac.fr", "context"));
            String collaborationName = ((Element)DOMUtil.getInstance().findElementsByNs(context, new QName("http://www.gind.emac.fr", "collaborationName")).get(0)).getTextContent();
            String knowledgeSpaceName = ((Element)DOMUtil.getInstance().findElementsByNs(context, new QName("http://www.gind.emac.fr", "knowledgeSpaceName")).get(0)).getTextContent();
            String agentHandlerId = ((Element)DOMUtil.getInstance().findElementsByNs(context, new QName("http://www.gind.emac.fr", "agentHandlerId")).get(0)).getTextContent();
            String webSocketId = "riored/eventReceivedCallback/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName).hashCode() + "/" + topic.toString().hashCode();
            JSONObject json = new JSONObject();
            json.put("event", (Object)XMLCompactPrinter.print((Node)doc.getDocumentElement()));
            json.put("createAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "createAt"))).getTextContent());
            json.put("sendAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt"))).getTextContent());
            json.put("eventId", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "eventId"))).getTextContent());
            json.put("topic", (Object)topic);
            json.put("agentHandlerId", (Object)agentHandlerId);
            GJaxbGetResult request = new GJaxbGetResult();
            request.setWebsocketId(webSocketId);
            request.setJsonResult(json.toString());
            this.command.getResult(request);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

