/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.event_broker.EventBroker;
import fr.emac.gind.event.event_broker.data.GJaxbGetAllTopics;
import fr.emac.gind.event.event_broker.data.GJaxbGetAllTopicsResponse;
import fr.emac.gind.event.producer.simulator.EventBrokerClient;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.rio.dw.resources.EventBrokerNotifier;
import fr.emac.gind.rio.dw.resources.bo.eventBroker.SubscribeTO;
import fr.emac.gind.rio.dw.resources.bo.eventBroker.UnSubscribeTO;
import fr.emac.gind.websocket.command.WebsocketCommand;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/r-ioga/eventBroker")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EventBrokerResource {
    private static Logger LOG = LoggerFactory.getLogger((String)EventBrokerResource.class.getName());
    private EventBroker eventBrokerRegisterClient = null;
    private Configuration conf = null;
    private WebsocketCommand command = null;
    private Map<String, Map<String, List<QName>>> notifierClientMaps = new HashMap<String, Map<String, List<QName>>>();
    private NotificationConsumerWebService eventBrokerConsumer = null;
    private AbstractNotifierClient eventBrokerClient = null;

    public EventBrokerResource(Configuration conf, WebsocketCommand command) throws Exception {
        this.conf = conf;
        this.command = command;
        String eventBrokerRegisterAddress = ((String)conf.getProperties().get("event-broker")).replace("Subscriber", "Register");
        this.eventBrokerRegisterClient = EventBrokerClient.createClient((String)eventBrokerRegisterAddress);
    }

    @GET
    @Path(value="/getAllTopics")
    public GJaxbGetAllTopicsResponse getAllTopics(@Auth DWUser user) throws Exception {
        GJaxbGetAllTopicsResponse res = null;
        try {
            res = this.eventBrokerRegisterClient.getAllTopics(new GJaxbGetAllTopics());
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    @POST
    @Path(value="/subscribe")
    public String subscribe(@Auth DWUser user, SubscribeTO subscribe) throws Exception {
        JSONObject res = null;
        try {
            if (this.eventBrokerClient == null) {
                this.eventBrokerClient = this.createNotifier();
            }
            String eventBrokerProducerAddress = (String)this.conf.getProperties().get("event-broker");
            String subscriptionId = this.eventBrokerClient.subscribeOn(eventBrokerProducerAddress, subscribe.getTopic());
            Map<String, List<QName>> notifierByCK = this.notifierClientMaps.get(subscribe.getCollaborationName() + "::" + subscribe.getKnowledgeSpaceName());
            if (notifierByCK == null) {
                notifierByCK = new HashMap<String, List<QName>>();
                this.notifierClientMaps.put(subscribe.getCollaborationName() + "::" + subscribe.getKnowledgeSpaceName(), notifierByCK);
            }
            notifierByCK.put(subscriptionId, Arrays.asList(subscribe.getTopic()));
            res = new JSONObject();
            res.put("subscriptionId", (Object)subscriptionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res.toString();
    }

    @POST
    @Path(value="/unsubscribe")
    public String unsubscribe(@Auth DWUser user, UnSubscribeTO unsubscribe) throws Exception {
        JSONObject res = new JSONObject();
        try {
            String eventBrokerProducerAddress = (String)this.conf.getProperties().get("event-broker");
            this.eventBrokerClient.unsubscribeOn(eventBrokerProducerAddress, unsubscribe.getSubscriptionId());
            Map<String, List<QName>> notifierByCK = this.notifierClientMaps.get(unsubscribe.getCollaborationName() + "::" + unsubscribe.getKnowledgeSpaceName());
            notifierByCK.remove(unsubscribe.getSubscriptionId());
            res.put("ok", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res.toString();
    }

    private AbstractNotifierClient createNotifier() throws Exception {
        String logNotifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("notifier-for-event-broker-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOREDNotifierForEventBroker");
        final EventBrokerNotifier logNotifier = new EventBrokerNotifier(logNotifierClientAddress, this.command);
        this.eventBrokerConsumer = new NotificationConsumerWebService();
        this.eventBrokerConsumer.start((Map)new HashMap<String, Object>(this){
            final /* synthetic */ EventBrokerResource this$0;
            {
                this.this$0 = this$0;
                this.put("host", "0.0.0.0");
                this.put("port", this.this$0.conf.getProperties().get("notifier-for-event-broker-port"));
                this.put("serviceName", "RIOREDNotifierForEventBroker");
                this.put("notifierClient", logNotifier);
            }
        });
        return logNotifier;
    }
}

