/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.timeseries.GJaxbDelete;
import fr.emac.gind.timeseries.GJaxbDeleteAll;
import fr.emac.gind.timeseries.GJaxbPointTo;
import fr.emac.gind.timeseries.GJaxbQuery;
import fr.emac.gind.timeseries.GJaxbQueryResponse;
import fr.emac.gind.timeseries.GJaxbUpdate;
import fr.emac.gind.timeseries.GJaxbWrite;
import fr.emac.gind.timeseries.Timeseries;
import fr.emac.gind.timeseries.mongodb.client.TimeSeriesMongoDBClient;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/r-ioga/timeSeries")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimeSeriesResource {
    private static Logger LOG = LoggerFactory.getLogger((String)TimeSeriesResource.class.getName());
    private Configuration conf = null;
    private Timeseries timeseriesClient = null;
    private Number number;

    public TimeSeriesResource(Configuration conf) throws Exception {
        this.conf = conf;
    }

    public Timeseries getTimeseriesClient() throws Exception {
        if (this.timeseriesClient == null) {
            this.timeseriesClient = TimeSeriesMongoDBClient.createTimeSeriesMongoDBClient((String)((String)this.conf.getProperties().get("timeseries")).toString());
        }
        return this.timeseriesClient;
    }

    @POST
    @Path(value="/write")
    public boolean write(@Auth DWUser user, GJaxbPointTo pointTo) throws Exception {
        try {
            LOG.debug("point: " + String.valueOf(pointTo));
            GJaxbWrite wreq = new GJaxbWrite();
            wreq.setPointTo(pointTo);
            this.getTimeseriesClient().write(wreq);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
            return false;
        }
    }

    @POST
    @Path(value="/update")
    public boolean update(@Auth DWUser user, GJaxbPointTo pointTo) throws Exception {
        try {
            LOG.debug("point: " + String.valueOf(pointTo));
            GJaxbUpdate ureq = new GJaxbUpdate();
            ureq.setPointTo(pointTo);
            this.getTimeseriesClient().update(ureq);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
            return false;
        }
    }

    @POST
    @Path(value="/query")
    public List<GJaxbPointTo> query(@Auth DWUser user, GJaxbQuery query) throws Exception {
        GJaxbQueryResponse res = new GJaxbQueryResponse();
        try {
            LOG.debug("query: " + String.valueOf(query));
            res = this.getTimeseriesClient().query(query);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res.getPointTo();
    }

    @POST
    @Path(value="/delete")
    public boolean delete(@Auth DWUser user, GJaxbPointTo pointTo) throws Exception {
        try {
            LOG.debug("pointTo: " + String.valueOf(pointTo));
            GJaxbDelete dreq = new GJaxbDelete();
            dreq.setPointTo(pointTo);
            this.getTimeseriesClient().delete(dreq);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return true;
    }

    @POST
    @Path(value="/deleteAll")
    public boolean deleteAll(@Auth DWUser user, GJaxbDeleteAll request) throws Exception {
        try {
            this.getTimeseriesClient().deleteAll(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return true;
    }
}

