/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iome;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.broker.EventBrokerWebService;
import fr.emac.gind.event.broker.SubscriberBrokerManagerImpl;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioda.RIODAApplicationContext;
import fr.emac.gind.r.ioda.RIODANotifierClient;
import fr.emac.gind.r.ioda.RIODAService;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOMEService
extends RIODAService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOMEService.class.getName());
    private NotificationConsumerWebService governanceConsumer = null;

    public RIOMEService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOMEService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-iome";
    }

    public String getRedirection() {
        return "/riome";
    }

    public RIODAApplicationContext createApplicationContext() throws Exception {
        return new RIODAApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        if (this.conf.getProperties().get("riome-core-gov-notifier-port") != null) {
            this.createNotifierForCoreGovEvent();
        }
    }

    private void createNotifierForCoreGovEvent() throws Exception {
        String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("riome-core-gov-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIODaNotifierForGovernance");
        RIODANotifierClient notifier = new RIODANotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, this.getName());
        this.governanceConsumer = new NotificationConsumerWebService();
        this.governanceConsumer.start((Map)new HashMap<String, Object>(this, (AbstractNotifierClient)notifier){
            final /* synthetic */ AbstractNotifierClient val$notifier;
            final /* synthetic */ RIOMEService this$0;
            {
                this.val$notifier = abstractNotifierClient;
                this.this$0 = this$0;
                this.put("host", this.this$0.conf.getProperties().get("host"));
                this.put("port", this.this$0.conf.getProperties().get("riome-core-gov-notifier-port"));
                this.put("serviceName", "RIOMENotifierForGovernance");
                this.put("notifierClient", this.val$notifier);
            }
        });
        if (LocalRegistry.getInstance().findWS(EventBrokerWebService.class) != null) {
            EventBrokerWebService eventBrokerWebService = (EventBrokerWebService)LocalRegistry.getInstance().findWS(EventBrokerWebService.class);
            SubscriberBrokerManagerImpl eventBrokerNotifier = (SubscriberBrokerManagerImpl)eventBrokerWebService.getImplementation(SubscriberBrokerManagerImpl.class);
            notifier.subscribeOn((NotificationManagerImpl)eventBrokerNotifier, new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic"));
            notifier.subscribeOn((NotificationManagerImpl)eventBrokerNotifier, new QName("http://www.gind.emac.fr/EventType", "similarityNearLinkTopic"));
        } else {
            String brokerSubscribeAddress = (String)this.conf.getProperties().get("event-broker");
            notifier.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic"));
            notifier.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "similarityNearLinkTopic"));
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.governanceConsumer != null) {
            this.governanceConsumer.stop();
        }
    }
}

