/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iose;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.r.iose.RIOSEApplicationContext;
import fr.emac.gind.r.iose.RIOSENotifierClient;
import fr.emac.gind.rio.dw.resources.TimeSeriesResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOSEService
extends RIOGAService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOSEService.class.getName());
    public static NotificationConsumerWebService RIOSE_CONSUMER = null;
    public static AbstractNotifierClient RIOSE_NOTIFIER = null;

    public RIOSEService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOSEService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-iose";
    }

    public String getRedirection() {
        return "/riose";
    }

    public RIOSEApplicationContext createApplicationContext() throws Exception {
        return new RIOSEApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        this.activatePubSubServerServlet(environment);
        this.createNotifierToDatasetAndSensorStatusEvent();
        resourcesManager.addResource((Object)new TimeSeriesResource(this.conf));
    }

    private void createNotifierToDatasetAndSensorStatusEvent() throws Exception {
        if (RIOSE_CONSUMER == null) {
            String logNotifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("riose-notifier-for-sensors-status-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOSeNotifierForSensors");
            RIOSE_NOTIFIER = new RIOSENotifierClient(logNotifierClientAddress, WEB_SOCKET_COMMAND);
            RIOSE_CONSUMER = new NotificationConsumerWebService();
            RIOSE_CONSUMER.start((Map)new HashMap<String, Object>(){
                {
                    this.put("host", "0.0.0.0");
                    this.put("port", RIOSEService.this.conf.getProperties().get("riose-notifier-for-sensors-status-port"));
                    this.put("serviceName", "RIOSeNotifierForSensors");
                    this.put("notifierClient", RIOSE_NOTIFIER);
                }
            });
            String brokerSubscribeAddress = (String)this.conf.getProperties().get("event-broker");
            RIOSE_NOTIFIER.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "allDatasetTopic"));
            String sensorManagerSubscriberAddress = (String)this.conf.getProperties().get("sensor-manager-server") + "Subscriber";
            RIOSE_NOTIFIER.subscribeOn(sensorManagerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allSensorTopic"));
        }
    }

    public void stop() throws Exception {
        if (RIOSE_CONSUMER != null) {
            RIOSE_CONSUMER.stop();
        }
        super.stop();
    }
}

