/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.game_master.GameMasterApi;
import fr.emac.gind.game_master.GameMasterManagerClient;
import fr.emac.gind.game_master.data.GJaxbCreateGameScenario;
import fr.emac.gind.game_master.data.GJaxbCreateGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenario;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbGetCurrentGameScenario;
import fr.emac.gind.game_master.data.GJaxbGetCurrentGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbGetGameScenarios;
import fr.emac.gind.game_master.data.GJaxbGetGameScenariosResponse;
import fr.emac.gind.game_master.data.GJaxbSaveGameScenario;
import fr.emac.gind.game_master.data.GJaxbSaveGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbSetCurrentGameScenario;
import fr.emac.gind.game_master.data.GJaxbSetCurrentGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbUpdateGameScenario;
import fr.emac.gind.game_master.data.GJaxbUpdateGameScenarioResponse;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.rio.dw.resources.FileResource;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/gameMaster")
@Produces(value={"application/json"})
public class GameMasterResource {
    private static Logger LOG = LoggerFactory.getLogger(GameMasterResource.class);
    private GameMasterApi gmClient = null;
    private FileResource fileResource = null;

    public GameMasterResource(Configuration conf, FileResource fileResource) throws Exception {
        this.gmClient = GameMasterManagerClient.createClient((String)((String)conf.getProperties().get("game-master-server")).toString());
        this.fileResource = fileResource;
    }

    @POST
    @Path(value="/setCurrentGameScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbSetCurrentGameScenarioResponse setCurrentGameScenario(@Auth DWUser user, GJaxbSetCurrentGameScenario req) throws Exception {
        GJaxbSetCurrentGameScenarioResponse response = null;
        try {
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.gmClient.setCurrentGameScenario(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/getCurrentGameScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetCurrentGameScenarioResponse getCurrentGameScenario(@Auth DWUser user, GJaxbGetCurrentGameScenario req) throws Exception {
        GJaxbGetCurrentGameScenarioResponse response = null;
        try {
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.gmClient.getCurrentGameScenario(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/getGameScenarios")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetGameScenariosResponse getGameScenarios(@Auth DWUser user, GJaxbGetGameScenarios req) throws Exception {
        GJaxbGetGameScenariosResponse response = null;
        try {
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.gmClient.getGameScenarios(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/createGameScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbCreateGameScenarioResponse createGameScenario(@Auth DWUser user, GJaxbCreateGameScenario req) throws Exception {
        GJaxbCreateGameScenarioResponse response = null;
        try {
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.gmClient.createGameScenario(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/updateGameScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUpdateGameScenarioResponse updateGameScenario(@Auth DWUser user, GJaxbUpdateGameScenario req) throws Exception {
        GJaxbUpdateGameScenarioResponse response = null;
        try {
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.gmClient.updateGameScenario(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/deleteGameScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbDeleteGameScenarioResponse deleteGameScenario(@Auth DWUser user, GJaxbDeleteGameScenario req) throws Exception {
        GJaxbDeleteGameScenarioResponse response = null;
        try {
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.gmClient.deleteGameScenario(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/saveGameScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbSaveGameScenarioResponse saveGameScenario(@Auth DWUser user, GJaxbSaveGameScenario req) throws Exception {
        GJaxbSaveGameScenarioResponse response = null;
        try {
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.gmClient.saveGameScenario(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }
}

