/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.dataset.GJaxbDataset;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.RestWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.rio.dw.resources.FileResource;
import fr.emac.gind.rio.dw.resources.gov.bo.SendEventToProviderTO;
import fr.emac.gind.sensors.controler.SensorControler;
import fr.emac.gind.sensors.controler.SensorControlerClient;
import fr.emac.gind.sensors.controler.data.GJaxbAddBreakpoints;
import fr.emac.gind.sensors.controler.data.GJaxbAddBreakpointsResponse;
import fr.emac.gind.sensors.controler.data.GJaxbAddDatasetAndRefreshModelOnSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbAddDatasetAndRefreshModelOnSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbCreateSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbCreateSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbFindSensorControlerByProtocol;
import fr.emac.gind.sensors.controler.data.GJaxbFindSensorControlerByProtocolResponse;
import fr.emac.gind.sensors.controler.data.GJaxbGetBreakpoints;
import fr.emac.gind.sensors.controler.data.GJaxbGetBreakpointsResponse;
import fr.emac.gind.sensors.controler.data.GJaxbGetSensorControlers;
import fr.emac.gind.sensors.controler.data.GJaxbGetSensorControlersResponse;
import fr.emac.gind.sensors.controler.data.GJaxbGetXMLDataOfDataset;
import fr.emac.gind.sensors.controler.data.GJaxbGetXMLDataOfDatasetResponse;
import fr.emac.gind.sensors.controler.data.GJaxbPauseDataSetOnTopicOfSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbPauseDataSetOnTopicOfSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbPlayDataSetOnTopicOfSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbPlayDataSetOnTopicOfSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbRemoveBreakpoints;
import fr.emac.gind.sensors.controler.data.GJaxbRemoveBreakpointsResponse;
import fr.emac.gind.sensors.controler.data.GJaxbRemoveDatasetOnSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbRemoveDatasetOnSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbSendEventToSensor;
import fr.emac.gind.sensors.controler.data.GJaxbSendEventToSensorResponse;
import fr.emac.gind.sensors.controler.data.GJaxbStopDataSetOnTopicOfSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbStopDataSetOnTopicOfSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbUpdateDatasetAndModelConfiguration;
import fr.emac.gind.sensors.controler.data.GJaxbUpdateDatasetAndModelConfigurationResponse;
import fr.emac.gind.sensors.controler.data.GJaxbUpdateDatasetAndModelOnSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbUpdateDatasetAndModelOnSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbUpdateSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbUpdateSensorControlerResponse;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Path(value="/{app}/sensorControler")
@Produces(value={"application/json"})
public class SensorControlerResource {
    private static Logger LOG = LoggerFactory.getLogger(SensorControlerResource.class);
    private SensorControler sensorControlerClient = null;
    private FileResource fileResource = null;
    private Map<QName, String> subscriptionIds = Collections.synchronizedMap(new HashMap());
    private AbstractNotifierClient notifier = null;
    private Configuration conf = null;

    public SensorControlerResource(Configuration conf, FileResource fileResource, AbstractNotifierClient notifier) throws Exception {
        this.sensorControlerClient = SensorControlerClient.createClient((String)((String)conf.getProperties().get("sensor-controler-server")));
        this.fileResource = fileResource;
        this.notifier = notifier;
        this.conf = conf;
    }

    @POST
    @Path(value="/getSensorControlers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetSensorControlersResponse getSensorControlers(@Auth DWUser user, GJaxbGetSensorControlers request) throws Exception {
        GJaxbGetSensorControlersResponse response = null;
        try {
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.sensorControlerClient.getSensorControlers(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/createSensorControler")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbCreateSensorControlerResponse createSensorControler(@Auth DWUser user, GJaxbCreateSensorControler request) throws Exception {
        GJaxbCreateSensorControlerResponse response = null;
        try {
            response = this.sensorControlerClient.createSensorControler(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/updateSensorControler")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUpdateSensorControlerResponse updateSensorControler(@Auth DWUser user, GJaxbUpdateSensorControler request) throws Exception {
        GJaxbUpdateSensorControlerResponse response = null;
        try {
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.sensorControlerClient.updateSensorControler(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/launchDataSetOnTopic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public synchronized GJaxbPlayDataSetOnTopicOfSensorControlerResponse launchDataSetOnTopic(@Auth DWUser user, GJaxbPlayDataSetOnTopicOfSensorControler req) throws Exception {
        LOG.debug("play dataset on topic: " + req.getDatasetHandler().getName());
        GJaxbPlayDataSetOnTopicOfSensorControlerResponse response = null;
        try {
            if (this.subscriptionIds.get(req.getDatasetHandler().getTopicToSubscribe()) == null) {
                String subscriptionIdRIOSEMIT = this.notifier.subscribeOn(req.getInternalUrl(), req.getDatasetHandler().getTopicToSubscribe());
                this.subscriptionIds.put(req.getDatasetHandler().getTopicToSubscribe(), subscriptionIdRIOSEMIT);
            }
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.sensorControlerClient.playDataSetOnTopicOfSensorControler(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/pauseDataSetOnTopic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbPauseDataSetOnTopicOfSensorControlerResponse pauseDataSetOnTopic(@Auth DWUser user, GJaxbPauseDataSetOnTopicOfSensorControler req) throws Exception {
        GJaxbPauseDataSetOnTopicOfSensorControlerResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.pauseDataSetOnTopicOfSensorControler(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/stopDataSetOnTopic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbStopDataSetOnTopicOfSensorControlerResponse stopDataSetOnTopic(@Auth DWUser user, GJaxbStopDataSetOnTopicOfSensorControler req) throws Exception {
        GJaxbStopDataSetOnTopicOfSensorControlerResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.stopDataSetOnTopicOfSensorControler(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/addBreakpoints")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbAddBreakpointsResponse addBreakpoints(@Auth DWUser user, GJaxbAddBreakpoints req) throws Exception {
        GJaxbAddBreakpointsResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.addBreakpoints(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/removeBreakpoints")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbRemoveBreakpointsResponse removeBreakpoints(@Auth DWUser user, GJaxbRemoveBreakpoints req) throws Exception {
        GJaxbRemoveBreakpointsResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.removeBreakpoints(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/getBreakpoints")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetBreakpointsResponse getBreakpoints(@Auth DWUser user, GJaxbGetBreakpoints req) throws Exception {
        GJaxbGetBreakpointsResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.getBreakpoints(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @GET
    @Path(value="/findSensorControlerByProtocol/{type}/{nature}/{gameScenarioId}/{collaborationName}/{knowledgeSpaceName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbFindSensorControlerByProtocolResponse findSensorControlerByProtocol(@Auth DWUser user, @PathParam(value="type") String type, @PathParam(value="nature") String nature, @PathParam(value="gameScenarioId") String gameScenarioId, @PathParam(value="collaborationName") String collaborationName, @PathParam(value="knowledgeSpaceName") String knowledgeSpaceName) throws Exception {
        GJaxbFindSensorControlerByProtocolResponse response = null;
        try {
            GJaxbFindSensorControlerByProtocol request = new GJaxbFindSensorControlerByProtocol();
            request.setGameScenarioId(gameScenarioId);
            request.setCollaborationName(collaborationName);
            request.setKnowledgeSpaceName(knowledgeSpaceName);
            request.getType().add(type);
            request.getNature().add(nature);
            response = this.sensorControlerClient.findSensorControlerByProtocol(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/sendEventToSensor")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbSendEventToSensorResponse sendEventToSensor(@Auth DWUser user, SendEventToProviderTO parameters) {
        GJaxbSendEventToSensorResponse res = null;
        try {
            GJaxbSendEventToSensor request = new GJaxbSendEventToSensor();
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            request.setDataSourceId(parameters.getDataSourceId());
            request.setGameScenarioId(parameters.getGameScenarioId());
            Document payload = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(parameters.getPayload().getBytes()));
            request.setPayload(new GJaxbSendEventToSensor.Payload());
            request.getPayload().setAny((Object)payload.getDocumentElement());
            request.setStatus(parameters.getStatus());
            request.getLabel().addAll(parameters.getLabel());
            res = this.sensorControlerClient.sendEventToSensor(request);
        }
        catch (Exception e) {
            throw new RestWebApplicationException((Throwable)e);
        }
        return res;
    }

    public static GJaxbDataset getDataset(FileResource fileResource, DWUser user, String datasetURL) throws Exception {
        GJaxbDataset dataset = null;
        if (datasetURL != null && !datasetURL.isBlank()) {
            String buffer = fileResource.download(user, datasetURL);
            if (buffer == null) {
                throw new Exception("EMPTY PATH to Dataset file");
            }
            Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(buffer.getBytes()));
            dataset = (GJaxbDataset)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbDataset.class);
        }
        return dataset;
    }

    @POST
    @Path(value="/addDatasetAndRefreshModelOnSensorControlerFromFile")
    @Consumes(value={"multipart/form-data"})
    public GJaxbAddDatasetAndRefreshModelOnSensorControlerResponse addDatasetAndRefreshModelOnSensorControler(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        GJaxbAddDatasetAndRefreshModelOnSensorControlerResponse res = null;
        LOG.debug("\n\n*************************** injectDataset *******************\n\n");
        try {
            Document doc = DOMUtil.getInstance().parse(is);
            GJaxbDataset dataset = (GJaxbDataset)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbDataset.class);
            JSONObject params = new JSONObject(data);
            LOG.debug("");
            GJaxbAddDatasetAndRefreshModelOnSensorControler request = new GJaxbAddDatasetAndRefreshModelOnSensorControler();
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            request.setDataset(dataset);
            String sensorId = params.getString("sensorId");
            request.setDataSourceId(sensorId);
            String gameScenarioId = params.getString("gameScenarioId");
            request.setGameScenarioId(gameScenarioId);
            res = this.sensorControlerClient.addDatasetAndRefreshModelOnSensorControler(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    @POST
    @Path(value="/updateDatasetOnSensorControlerFromFile")
    @Consumes(value={"multipart/form-data"})
    public GJaxbUpdateDatasetAndModelOnSensorControlerResponse updateDatasetOnSensorControler(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        GJaxbUpdateDatasetAndModelOnSensorControlerResponse res = null;
        LOG.debug("\n\n*************************** injectDataset *******************\n\n");
        try {
            Document doc = DOMUtil.getInstance().parse(is);
            GJaxbDataset dataset = (GJaxbDataset)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbDataset.class);
            JSONObject params = new JSONObject(data);
            LOG.debug("");
            GJaxbUpdateDatasetAndModelOnSensorControler request = new GJaxbUpdateDatasetAndModelOnSensorControler();
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            request.setDataset(dataset);
            String sensorId = params.getString("sensorId");
            request.setDataSourceId(sensorId);
            String gameScenarioId = params.getString("gameScenarioId");
            request.setGameScenarioId(gameScenarioId);
            res = this.sensorControlerClient.updateDatasetAndModelOnSensorControler(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    @POST
    @Path(value="/addDatasetAndRefreshModelOnSensorControlerFromJson")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbAddDatasetAndRefreshModelOnSensorControlerResponse addDatasetAndRefreshModelOnSensorControler(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbAddDatasetAndRefreshModelOnSensorControlerResponse res = null;
        LOG.debug("\n\n*************************** injectDataset *******************\n\n");
        try {
            GJaxbAddDatasetAndRefreshModelOnSensorControler request = (GJaxbAddDatasetAndRefreshModelOnSensorControler)JSONJAXBContext.getInstance().unmarshall("{ \"addDatasetOnSensorControler\":" + jsonRequest + "}", GJaxbAddDatasetAndRefreshModelOnSensorControler.class);
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            res = this.sensorControlerClient.addDatasetAndRefreshModelOnSensorControler(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    @POST
    @Path(value="/updateDatasetAndModelOnSensorControlerFromJson")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUpdateDatasetAndModelOnSensorControlerResponse updateDatasetAndModelOnSensorControler(@Auth DWUser user, String jsonRequest) throws Exception {
        GJaxbUpdateDatasetAndModelOnSensorControlerResponse res = null;
        LOG.debug("\n\n*************************** injectDataset *******************\n\n");
        try {
            GJaxbUpdateDatasetAndModelOnSensorControler request = (GJaxbUpdateDatasetAndModelOnSensorControler)JSONJAXBContext.getInstance().unmarshall("{ \"updateDatasetAndModelOnSensorControler\":" + jsonRequest + "}", GJaxbUpdateDatasetAndModelOnSensorControler.class);
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            res = this.sensorControlerClient.updateDatasetAndModelOnSensorControler(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    @POST
    @Path(value="/removeDatasetOnSensorControler")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbRemoveDatasetOnSensorControlerResponse removeDatasetOnSensorControler(@Auth DWUser user, GJaxbRemoveDatasetOnSensorControler req) throws Exception {
        GJaxbRemoveDatasetOnSensorControlerResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.removeDatasetOnSensorControler(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/getXMLDataOfDataset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetXMLDataOfDatasetResponse getDataOfDataset(@Auth DWUser user, GJaxbGetXMLDataOfDataset req) throws Exception {
        GJaxbGetXMLDataOfDatasetResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.getXMLDataOfDataset(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/updateDatasetAndModelConfiguration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUpdateDatasetAndModelConfigurationResponse updateDatasetAndModelConfiguration(@Auth DWUser user, GJaxbUpdateDatasetAndModelConfiguration req) throws Exception {
        GJaxbUpdateDatasetAndModelConfigurationResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorControlerClient.updateDatasetAndModelConfiguration(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }
}

