/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iosepe;

import fr.emac.gind.campaign.manager.client.CampaignManagerNotifierClient;
import fr.emac.gind.campaign.manager.server.CampaignManagerSubscriber;
import fr.emac.gind.campaign.manager.server.CampaignManagerWebService;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.eventtype.GJaxbAddCampaignSolutionEvent;
import fr.emac.gind.eventtype.GJaxbCreateCampaignEvent;
import fr.emac.gind.eventtype.GJaxbRemoveCampaignSolutionEvent;
import fr.emac.gind.eventtype.GJaxbUpdateCampaignEvent;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.r.ioda.RIODAService;
import fr.emac.gind.r.iosepe.RIOSEPEApplicationContext;
import fr.emac.gind.rio.dw.resources.ExcelResource;
import fr.emac.gind.rio.dw.resources.JsonResource;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOSEPEService
extends RIODAService {
    private CampaignManagerNotifierClient client = null;
    private static Logger LOG = LoggerFactory.getLogger((String)RIOSEPEService.class.getName());

    public RIOSEPEService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOSEPEService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-iosepe";
    }

    public String getRedirection() {
        return "/riosepe";
    }

    public RIOSEPEApplicationContext createApplicationContext() throws Exception {
        return new RIOSEPEApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        resourcesManager.addResource((Object)new ExcelResource(this.conf));
        resourcesManager.addResource((Object)new JsonResource(this.conf));
        String subscriberCampaignAddress = (String)this.conf.getProperties().get("campaign-manager");
        String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("riosepe-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOSEPENotifier");
        this.client = new CampaignManagerNotifierClient(this, URI.create(subscriberCampaignAddress).toURL(), URI.create(notifierClientAddress).toURL()){

            public void onCreateCampaignEvent(GJaxbCreateCampaignEvent event) {
                try {
                    GJaxbGetResult request = new GJaxbGetResult();
                    request.setWebsocketId("/riosepe/" + RegExpHelper.toRegexFriendlyName((String)event.getCollaborationName()).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)event.getKnowledgeSpaceName()).hashCode());
                    request.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)event));
                    WEB_SOCKET_COMMAND.getResult(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onUpdateCampaignEvent(GJaxbUpdateCampaignEvent event) {
                try {
                    GJaxbGetResult request = new GJaxbGetResult();
                    request.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)event));
                    request.setWebsocketId("/riosepe/" + RegExpHelper.toRegexFriendlyName((String)event.getCollaborationName()).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)event.getKnowledgeSpaceName()).hashCode());
                    WEB_SOCKET_COMMAND.getResult(request);
                    request.setWebsocketId("/riosepe/" + RegExpHelper.toRegexFriendlyName((String)event.getCollaborationName()).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)event.getKnowledgeSpaceName()).hashCode() + "/" + event.getCampaign().getCampaignId());
                    WEB_SOCKET_COMMAND.getResult(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onAddSolutionEvent(GJaxbAddCampaignSolutionEvent event) {
                try {
                    GJaxbGetResult request = new GJaxbGetResult();
                    request.setWebsocketId("/riosepe/" + RegExpHelper.toRegexFriendlyName((String)event.getCollaborationName()).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)event.getKnowledgeSpaceName()).hashCode() + "/" + event.getCampaignSolution().getCampaignId());
                    request.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)event));
                    WEB_SOCKET_COMMAND.getResult(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onRemoveSolutionEvent(GJaxbRemoveCampaignSolutionEvent event) {
                try {
                    GJaxbGetResult request = new GJaxbGetResult();
                    request.setWebsocketId("/riosepe/" + RegExpHelper.toRegexFriendlyName((String)event.getCollaborationName()).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)event.getKnowledgeSpaceName()).hashCode() + "/" + event.getCampaignSolution().getCampaignId());
                    request.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)event));
                    WEB_SOCKET_COMMAND.getResult(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.client.start();
        CampaignManagerWebService campaignManagerWebService = (CampaignManagerWebService)LocalRegistry.getInstance().findWS(CampaignManagerWebService.class);
        CampaignManagerSubscriber localTestCampaignSubscriber = (CampaignManagerSubscriber)campaignManagerWebService.getImplementation(CampaignManagerSubscriber.class);
        this.client.subscribeToCampaignManager((Object)localTestCampaignSubscriber);
    }

    public void stop() throws Exception {
        if (this.client != null) {
            this.client.stop();
        }
        super.stop();
    }
}

