/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.campaign.manager.CampaignManagerItf;
import fr.emac.gind.campaign.manager.client.CampaignManagerClient;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaignResponse;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaignSolution;
import fr.emac.gind.campaign.manager.data.model.GJaxbStatistic;
import fr.emac.gind.commons.utils.excel.ExcelProjectManager;
import fr.emac.gind.commons.utils.excel.ExcelSheet;
import fr.emac.gind.commons.utils.excel.ExcelTable;
import fr.emac.gind.commons.utils.excel.helpers.TableInfo;
import fr.emac.gind.commons.utils.maths.DoubleHelper;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.models.process.simulation.results.GJaxbIndicator;
import fr.emac.gind.workflow.AbstractProcessGenerator;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.poi.openxml4j.util.ZipSecureFile;

@Path(value="/{app}/r-iosepe/campaign/excel")
@Consumes(value={"application/json"})
public class ExcelResource {
    private CampaignManagerItf campaignClient = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd HH:mm");
    private SimpleDateFormat formatterLong2Time = new SimpleDateFormat("mm:ss");
    private List<AbstractProcessGenerator> processGenerators = new ArrayList<AbstractProcessGenerator>();

    public ExcelResource(Configuration conf) throws Exception {
        if (conf != null) {
            this.campaignClient = CampaignManagerClient.createClient((String)((String)conf.getProperties().get("campaign-manager")));
        }
        this.initProcessGenerator();
    }

    public void initProcessGenerator() {
        ServiceLoader<AbstractProcessGenerator> processGeneratorLoader = ServiceLoader.load(AbstractProcessGenerator.class);
        this.processGenerators.clear();
        processGeneratorLoader.reload();
        for (AbstractProcessGenerator processGenerator : processGeneratorLoader) {
            this.processGenerators.add(processGenerator);
        }
    }

    @POST
    @Path(value="/exportCampaign")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response exportAsExcel(@Auth DWUser user, String campaignId) throws Exception {
        Response res = null;
        try {
            GJaxbGetCampaign request = new GJaxbGetCampaign();
            request.setCampaignId(campaignId);
            GJaxbGetCampaignResponse response = this.campaignClient.getCampaign(request);
            GJaxbCampaign campaign = response.getCampaign();
            GJaxbGetSolutionsFromCampaign getParam = new GJaxbGetSolutionsFromCampaign();
            getParam.setCampaignId(campaign.getCampaignId());
            GJaxbGetSolutionsFromCampaignResponse responseGet = this.campaignClient.getSolutionsFromCampaign(getParam);
            ExcelProjectManager excel = new ExcelProjectManager();
            this.createAllSheets(campaign, responseGet.getCampaignSolution(), excel);
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            res = Response.ok((Object)excel.writeInByteArray().toByteArray(), (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    @POST
    @Path(value="/exportSolutions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response exportAsExcel(@Auth DWUser user, List<GJaxbCampaignSolution> scenarios) throws Exception {
        Response res = null;
        try {
            ExcelProjectManager excel = new ExcelProjectManager();
            this.createSheetSolutions(excel, scenarios);
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            res = Response.ok((Object)excel.writeInByteArray().toByteArray(), (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    public void createAllSheets(GJaxbCampaign campaign, List<GJaxbCampaignSolution> scenarios, ExcelProjectManager excel) throws Exception {
        this.createSheetCampaign(excel, campaign);
        this.createSheetSolutions(excel, scenarios);
        if (!scenarios.isEmpty()) {
            GJaxbCampaignSolution gJaxbCampaignSolution = scenarios.get(0);
        }
    }

    public void createSheetCampaign(ExcelProjectManager excel, GJaxbCampaign campaign) throws Exception {
        ExcelSheet sheet = excel.addSheet("Campaign Information");
        int currentRow = 2;
        int currentCol = 2;
        boolean maxWidth = false;
        TableInfo tableInfo = this.createBasicInformationCampaignTable(sheet, currentRow, currentCol, campaign);
        tableInfo = this.createNumericalMetricCampaignTable(sheet, currentRow, tableInfo.getTotalWidth() + 4, campaign);
    }

    public void createSheetSolutions(ExcelProjectManager excel, List<GJaxbCampaignSolution> scenario) throws Exception {
        ExcelSheet sheet = excel.addSheet("Solutions");
        int currentRow = 2;
        int currentCol = 2;
        boolean maxWidth = false;
        TableInfo tableInfo = this.createSolutionTable(sheet, currentRow, currentCol, scenario);
    }

    private TableInfo createSolutionTable(ExcelSheet sheet, int currentRow, int currentCol, List<GJaxbCampaignSolution> scenarios) throws Exception {
        Object[][] values = new Object[][]{};
        if (!scenarios.isEmpty()) {
            values = new Object[scenarios.size()][scenarios.get(0).getIndicator().size() + 1 + 3];
        }
        ArrayList<String> headerCols = new ArrayList<String>();
        int row = 0;
        for (GJaxbCampaignSolution scenario : scenarios) {
            values[row][0] = scenario.getName();
            if (row == 0) {
                headerCols.add("Name");
            }
            int col = 1;
            for (GJaxbIndicator impedance : scenario.getIndicator()) {
                values[row][col] = this.getImpedanceProcessValue(impedance);
                ++col;
                if (row != 0) continue;
                headerCols.add(impedance.getName());
            }
            values[row][col] = scenario.getRisksActivated();
            values[row][++col] = scenario.getPreventivesStrategiesActivated();
            values[row][++col] = scenario.getCorrectivesStrategiesActivated();
            ++col;
            ++row;
        }
        headerCols.add("Risks");
        headerCols.add("Preventives Strategies");
        headerCols.add("Correctives Strategies");
        ExcelTable table = sheet.addTable("Solutions:");
        return table.setValue(currentRow, currentCol, headerCols, Arrays.asList(new String[0]), values, null);
    }

    private Object getImpedanceProcessValue(GJaxbIndicator val) {
        if (val.getIndicatorValue().getSimulatedValue() != null) {
            return val.getIndicatorValue().getSimulatedValue();
        }
        return null;
    }

    private TableInfo createBasicInformationCampaignTable(ExcelSheet sheet, int currentRow, int currentCol, GJaxbCampaign campaign) throws Exception {
        Object[][] values = new Object[10][1];
        values[0][0] = campaign.getCampaignName();
        values[1][0] = this.formatter.format(campaign.getStartedAt().toGregorianCalendar().getTime());
        values[3][0] = campaign.getEndedAt() != null ? this.formatter.format(campaign.getEndedAt().toGregorianCalendar().getTime()) : "";
        values[4][0] = campaign.getStatus().toString();
        values[5][0] = campaign.getTime() != null ? this.formatterLong2Time.format(new Date(campaign.getTime())) : "";
        values[6][0] = campaign.getNumberOfSolution();
        values[7][0] = campaign.getNumberOfSolutionAchieved();
        values[8][0] = campaign.getNumberOfSuccessfulSolution();
        values[9][0] = campaign.getNumberOfFailureSolution();
        ExcelTable table = sheet.addTable("Basic Information:");
        return table.setValue(currentRow, currentCol, Arrays.asList("Value"), Arrays.asList("Name", "Created At", "Started At", "Ended At", "Status", "Duration", "Number of Solutions", "Number of Solutions Achieved", "Number of Successful Solutions", "Number of Failure Solutions"), values, null);
    }

    private TableInfo createNumericalMetricCampaignTable(ExcelSheet sheet, int currentRow, int currentCol, GJaxbCampaign campaign) throws Exception {
        Object[][] values = new Object[campaign.getStatistic().getStatisticMetric().size()][3];
        ArrayList<String> headerRows = new ArrayList<String>();
        int row = 0;
        for (GJaxbStatistic.StatisticMetric numVal : campaign.getStatistic().getStatisticMetric()) {
            headerRows.add(numVal.getName());
            values[row][0] = numVal.getMin();
            values[row][1] = numVal.getMax();
            values[row][2] = DoubleHelper.formatWith3Decimal((Double)Double.valueOf(numVal.getAverage().floatValue() / (float)campaign.getNumberOfSolutionAchieved().intValue()));
            ++row;
        }
        ExcelTable table = sheet.addTable("Statistics:");
        return table.setValue(currentRow, currentCol, Arrays.asList("Min", "Max", "Average"), headerRows, values, null);
    }
}

