/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iota;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbReflexEvent;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIOTAIOTReflexNotifierClient
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOTAIOTReflexNotifierClient.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;
    private String name = null;
    private CoreResource coreResource = null;
    private ModelsResource modelsResource = null;

    public RIOTAIOTReflexNotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND, String name, CoreResource coreResource, ModelsResource modelsResource) throws Exception {
        super(address);
        this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
        this.name = name;
        this.coreResource = coreResource;
        this.modelsResource = modelsResource;
    }

    public void notify(GJaxbNotify notify) {
        try {
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            String json = null;
            String collaborationName = null;
            String knowledgeName = null;
            if (doc.getDocumentElement().getLocalName().equals("reflexEvent")) {
                GJaxbReflexEvent event = (GJaxbReflexEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbReflexEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else {
                LOG.warn("Event not take into a charge: " + doc.getDocumentElement().getLocalName());
            }
            if (json != null && collaborationName != null && knowledgeName != null) {
                String cleanJson = json.replace("##application_name##", this.name);
                Map mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
                JSONObject jsonResult = new JSONObject();
                jsonResult.put("reflexEvent", (Object)cleanJson);
                jsonResult.put("createAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "createAt"))).getTextContent());
                jsonResult.put("sendAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt"))).getTextContent());
                GJaxbGetResult request = new GJaxbGetResult();
                request.setWebsocketId("/riota/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode());
                request.setJsonResult(jsonResult.toString());
                this.WEB_SOCKET_COMMAND.getResult(request);
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

