/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.monitoring.detection.Detection;
import fr.emac.gind.monitoring.detection.GJaxbDetect;
import fr.emac.gind.monitoring.detection.GJaxbDetectResponse;
import fr.emac.gind.monitoring.detection.client.DetectionClient;
import fr.emac.gind.monitoring.detectionReport.GJaxbModelsComparison;
import fr.emac.gind.r.iota.RIOTAApplicationContext;
import fr.emac.gind.rio.dw.resources.FileResource;
import fr.emac.gind.rio.dw.resources.gov.ProjectResource;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/r-iota/detection")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DetectionResource {
    private static final Logger LOG = LoggerFactory.getLogger((String)DetectionResource.class.getName());
    private Configuration conf = null;
    private CoreGov coreClient = null;
    private Detection detectionClient = null;
    private ProjectResource projectResource = null;
    private FileResource fileResource = null;

    public DetectionResource(Configuration conf, RIOTAApplicationContext context, ProjectResource projectResource, FileResource fileResource) throws Exception {
        this.conf = conf;
        this.coreClient = CoreGovClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovCore"));
        this.detectionClient = DetectionClient.createClient((String)((String)this.conf.getProperties().get("detection-server")));
        this.projectResource = projectResource;
        this.fileResource = fileResource;
    }

    @POST
    @Path(value="/detect")
    public GJaxbDetectResponse detect(@Auth DWUser user, GJaxbDetect request) throws Exception {
        request.setCurrentCollaborationName(user.getCurrentCollaborationName());
        request.setCurrentKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
        String expected_labels = "EXPECTED_FREEZE:`" + request.getSolutionId() + "`";
        GJaxbGenericModel expectedModel = CoreGovClient.singleQuery((CoreGov)this.coreClient, (String)("match (n:instance:" + expected_labels + ") optional match (n:instance:" + expected_labels + ")-[r]-(n1:instance:" + expected_labels + ") where not n:" + Neo4JReqConstant.system((String)"User") + " and not n:" + Neo4JReqConstant.system((String)"Collaboration") + " and not n:" + Neo4JReqConstant.project((String)"Project") + " and not n1:" + Neo4JReqConstant.system((String)"User") + "  and not n1:" + Neo4JReqConstant.system((String)"Collaboration") + " and not n1:" + Neo4JReqConstant.project((String)"Project") + " return distinct n, n1, r"), (String)user.getCurrentCollaborationName(), (String)user.getCurrentKnowledgeSpaceName());
        GJaxbGenericModel activeModel = CoreGovClient.singleQuery((CoreGov)this.coreClient, (String)("match (n:instance:ACTIVE) optional match (n:instance:ACTIVE)-[r]-(n1:instance:ACTIVE) where not n:" + Neo4JReqConstant.system((String)"User") + "  and not n:" + Neo4JReqConstant.system((String)"Collaboration") + " and not n:" + Neo4JReqConstant.project((String)"Project") + " and not n1:" + Neo4JReqConstant.system((String)"User") + "  and not n1:" + Neo4JReqConstant.system((String)"Collaboration") + " and not n1:" + Neo4JReqConstant.project((String)"Project") + " return distinct n, n1, r"), (String)user.getCurrentCollaborationName(), (String)user.getCurrentKnowledgeSpaceName());
        if (expectedModel != null) {
            expectedModel.getNode().forEach(n -> {
                try {
                    GJaxbNode parent;
                    if (n.getId().lastIndexOf("##") >= 0) {
                        n.setId(n.getId().substring(n.getId().lastIndexOf("##") + "##".length()));
                    }
                    if ((parent = GenericModelHelper.findFirstParent((GJaxbNode)n, (GJaxbGenericModel)expectedModel)) != null && parent.getId().lastIndexOf("##") >= 0) {
                        parent.setId(parent.getId().substring(parent.getId().lastIndexOf("##") + "##".length()));
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
            });
            expectedModel.getEdge().forEach(e -> {
                e.setId(e.getId().substring(e.getId().lastIndexOf("##") + "##".length()));
                if (e.isSetSource() && e.getSource().getId().lastIndexOf("##") >= 0) {
                    e.getSource().setId(e.getSource().getId().substring(e.getSource().getId().lastIndexOf("##") + "##".length()));
                }
                if (e.isSetTarget() && e.getTarget().getId().lastIndexOf("##") >= 0) {
                    e.getTarget().setId(e.getTarget().getId().substring(e.getTarget().getId().lastIndexOf("##") + "##".length()));
                }
            });
        }
        if (request.getDetectionGeneratorInstance().getName().toLowerCase().equals("D3Strategy detection".toLowerCase())) {
            GJaxbNode project = this.projectResource.getProjectByNameInCollaboration(user, user.getCurrentKnowledgeSpaceName(), user.getCurrentCollaborationName());
            GJaxbProperty d3MatrixProp = GenericModelHelper.findProperty((String)"d3 matrix", (List)project.getProperty());
            String matrixBuffer = this.fileResource.download(user, d3MatrixProp.getValue());
            request.setInputData(new GJaxbDetect.InputData());
            GJaxbProperty entry = new GJaxbProperty();
            entry.setName("conceptsMatrix");
            entry.setValue(matrixBuffer);
            request.getInputData().getProperty().add(entry);
        }
        GJaxbModelsComparison compare = new GJaxbModelsComparison();
        compare.setExpectedModel(new GJaxbModelsComparison.ExpectedModel());
        compare.getExpectedModel().setGenericModel(expectedModel);
        compare.setFieldModel(new GJaxbModelsComparison.FieldModel());
        compare.getFieldModel().setGenericModel(activeModel);
        compare.setCategory(null);
        request.getModelsComparison().add(compare);
        GJaxbDetectResponse detectResponse = this.detectionClient.detect(request);
        return detectResponse;
    }
}

