/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.sockjs;

import fr.emac.gind.generic.application.websocket.sockjs.SockjsEndpoint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;

public class EndpointHandler {
    private static EndpointHandler instance_;
    private Map<String, SockjsEndpoint> endpoints_ = new ConcurrentHashMap<String, SockjsEndpoint>();

    public static EndpointHandler getInstance() {
        return instance_;
    }

    public void register(SockjsEndpoint endpoint) {
        this.endpoints_.put(String.valueOf(endpoint.hashCode()), endpoint);
    }

    public SockjsEndpoint remove(String sessionId) {
        return this.endpoints_.remove(sessionId);
    }

    public SockjsEndpoint removeByInstance(SockjsEndpoint endpoint) {
        return this.remove(String.valueOf(endpoint.hashCode()));
    }

    public SockjsEndpoint get(String sessionId) {
        return this.endpoints_.get(sessionId);
    }

    public void broadcastMessage(String message) {
        this.endpoints_.values().forEach(p -> {
            Session s = p.getSession();
            if (s != null && s.isOpen()) {
                s.sendText(message, Callback.from(() -> {}, x -> x.printStackTrace()));
            }
        });
    }

    public static class EndpointHandlerBuilder {
        public static void buildEndpointHandler() {
            instance_ = new EndpointHandler();
        }
    }
}

