/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.impedances.plugin;

import fr.emac.gind.impedances.GJaxbMetaImpedance;
import fr.emac.gind.impedances.plugin.AbstractImpedancePlugin;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.metamodel.GJaxbFormtypeType;
import fr.emac.gind.models.generic.modeler.GenericModelHelper;
import fr.emac.gind.workflow.engine.Execution;
import fr.emac.gind.workflow.engine.Node;
import fr.emac.gind.workflow.engine.behaviours.ScopeBehaviour;
import fr.gind.emac.defaultprocess.GJaxbMetric;
import fr.gind.emac.defaultprocess.GJaxbRunSync;
import fr.gind.emac.defaultprocess.GJaxbRunSyncResponse;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImpedanceDistance
extends AbstractImpedancePlugin {
    public void initialize() throws Exception {
        this.metaImpedance = (GJaxbMetaImpedance)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("impedances/meta_impedance_distance.xml"), GJaxbMetaImpedance.class);
    }

    public void initializeProcessVariable(ScopeBehaviour behaviour, Execution execution) throws Exception {
        execution.getContext().put("process_" + this.metaImpedance.getName(), new Double(0.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateImpedanceOnTask(Node node, Execution execution, Map<String, Object> additionalData) throws Exception {
        Double currentDistance;
        Double numberOfLotToProduce = (Double)additionalData.get("numberOfLotToProduce");
        JSONObject formHumanTask = (JSONObject)additionalData.get("formHumanTask");
        Map riskImpactsOnTask = (Map)additionalData.get("riskImpactsOnTask");
        JSONObject riskImpactDurationOnTask = (JSONObject)additionalData.get("duration");
        Double d = currentDistance = (Double)execution.getTopParent().getContext().get("process_" + this.metaImpedance.getName());
        synchronized (d) {
            Double taskDistance = 0.0;
            Object category = null;
            if (GenericModelHelper.findProperty((String)"distance", (List)((GJaxbNode)node.getModel()).getProperty()) != null) {
                String distanceProp = GenericModelHelper.findProperty((String)"distance", (List)((GJaxbNode)node.getModel()).getProperty()).getValue();
                JSONArray distancePropArray = new JSONArray(distanceProp);
                JSONObject distancePropObj = distancePropArray.getJSONObject(0);
                taskDistance = Double.parseDouble(distancePropObj.get("value").toString());
            }
            if (numberOfLotToProduce != null && numberOfLotToProduce > 0.0) {
                taskDistance = taskDistance * numberOfLotToProduce;
            }
            JSONObject riskImpactDistanceOnTask = (JSONObject)riskImpactsOnTask.get(this.metaImpedance.getName());
            double taskDistanceWithImpact = 0.0;
            if (riskImpactDistanceOnTask.getString("operator").equals("+")) {
                taskDistanceWithImpact = taskDistance + riskImpactDistanceOnTask.getDouble("value");
            } else if (riskImpactDistanceOnTask.getString("operator").equals("-")) {
                taskDistanceWithImpact = taskDistance - riskImpactDistanceOnTask.getDouble("value");
            } else if (riskImpactDistanceOnTask.getString("operator").equals("/")) {
                if (riskImpactDistanceOnTask.getDouble("value") == 0.0) {
                    throw new Exception("the value of impact cannot be null with / operator");
                }
                taskDistanceWithImpact = taskDistance / riskImpactDistanceOnTask.getDouble("value");
            } else if (riskImpactDistanceOnTask.getString("operator").equals("*")) {
                taskDistanceWithImpact = taskDistance * riskImpactDistanceOnTask.getDouble("value");
            }
            Double newDistance = currentDistance + taskDistanceWithImpact;
            execution.getTopParent().getContext().put("process_" + this.metaImpedance.getName(), newDistance);
            formHumanTask.put("current distance", (Object)newDistance);
        }
    }

    public void setMetricAtEndOfProcess(Execution execution, GJaxbRunSync request, GJaxbRunSyncResponse response, GJaxbGenericModel riskModel) throws Exception {
        GJaxbMetric distance = new GJaxbMetric();
        distance.setName(this.metaImpedance.getName());
        distance.setValue(execution.getContext().get("process_" + this.metaImpedance.getName()).toString());
        distance.setMetaModel(new GJaxbMetric.MetaModel());
        distance.getMetaModel().setName(this.metaImpedance.getName());
        distance.getMetaModel().setType(GJaxbFormtypeType.NUMBER.value());
        distance.getMetaModel().setReadonly(true);
        distance.getMetaModel().setCategory("Impedances");
        response.getMetric().add(distance);
    }
}

