package fr.emac.gind.ioda;

/*
 * #%L
 * dw-ioga
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.List;
import java.util.UUID;

import javax.xml.namespace.QName;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.JSONArray;
import org.json.JSONObject;

import fr.emac.gind.commons.utils.jaxb.JSONJAXBContext;
import fr.emac.gind.gov.collaboration_gov.GJaxbCollaboration;
import fr.emac.gind.ioda.IodaCoreModelPopulateInterceptor;
import fr.emac.gind.marshaller.SOAJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.models.generic.modeler.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.GenericModelManager;
import fr.emac.gind.users.model.GJaxbUser;

/**
 *
 *
 * @author: Nicolas Salatge (nicolas.salatge@mines-albi.fr)
 */
public class IodaCrisisPartnersPopulateInterceptor extends IodaCoreModelPopulateInterceptor {


  public IodaCrisisPartnersPopulateInterceptor(fr.emac.gind.launcher.Configuration conf) {
    super(conf);
  }

  @Override
  public QName usedForMetaModel() {
    return new QName("http://fr.emac.gind/crisis_partners", "CrisisPartners");
  }

  @Override
  protected GJaxbGenericModel addCachedConcepts(GJaxbGenericModel model)
      throws Exception {
    model = super.addCachedConcepts(model);
    GenericModelManager manager = new GenericModelManager(model);
    List<GJaxbNode> service_nodes = manager.getNodesByType(new QName("http://fr.emac.gind/crisis_partners", "Service"));
    service_nodes.addAll(manager.getNodesByType(new QName("http://fr.emac.gind/crisis_partners", "Actor service")));
    service_nodes.addAll(manager.getNodesByType(new QName("http://fr.emac.gind/crisis_partners", "Mediator service")));
    for(GJaxbNode service_node: service_nodes) {
      GJaxbProperty prop = GenericModelHelper.findProperty("objectives satisfied", service_node.getProperty());
      String value = prop.getValue();

      System.out.println("json value: " + value);
      if(value != null && value.trim().length() > 0) {
        JSONArray json = new JSONArray(value);

        for(int i = 0; i < json.length(); i++) {
          JSONObject obj = json.getJSONObject(i);
          GJaxbNode cachedObjective = new GJaxbNode();
          String id = obj.getString("id");
          System.out.println("id = " + id);
          cachedObjective.setId(id);
 //         cachedObjective.setType(new QName("http://fr.emac.gind/crisis_objectives", "Mission"));
          cachedObjective.getRole().add("objective");
  //        cachedObjective.getRole().add("mission");
          cachedObjective.getProperty().add(GenericModelHelper.createProperty("name", obj.getString("name")));
          model.getNode().add(cachedObjective);

          GJaxbEdge cachedEdge = new GJaxbEdge();
          cachedEdge.setId("cached_edge_" + service_node.getId().toString() + "_" + UUID.randomUUID());
          cachedEdge.setType(new QName("http://fr.emac.gind/core-model", "Satisfies"));
          cachedEdge.getProperty().add(GenericModelHelper.createProperty("coverage", String.valueOf(obj.getDouble("coverage"))));
          cachedEdge.setSource(service_node);
          cachedEdge.setTarget(cachedObjective);
          model.getEdge().add(cachedEdge);
        }
      }
    }



    return model;
  }



}
