package fr.emac.gind.ioda;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import fr.emac.gind.commons.gov.resources.CollaborationResource;
import fr.emac.gind.commons.gov.resources.CoreResource;
import fr.emac.gind.commons.gov.resources.DeductionRulesResource;
import fr.emac.gind.commons.gov.resources.ModelsResource;
import fr.emac.gind.commons.utils.crypt.AES;
import fr.emac.gind.commons.utils.crypt.MD5;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.ioda.resource.ServiceResource;
import fr.emac.gind.ioda.resources.CoreModelResource;
import fr.emac.gind.modeler.GenericModelerService;
import fr.emac.gind.process.generator.manager.ProcessGeneratorManagerResource;
import fr.emac.gind.users.model.GJaxbUser;

/*
 * #%L
 * dw-ioda-crisis-crisis-partners
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */



import io.dropwizard.Configuration;
import io.dropwizard.setup.Environment;

/**
 *
 *
 * @author: Nicolas Salatge (nicolas.salatge@mines-albi.fr)
 */
public class IodaCrisisPartnersService extends GenericModelerService {

  private static Logger LOG = Logger.getLogger(IodaCrisisPartnersService.class.getName());

  public IodaCrisisPartnersService() throws Exception {
    this(new HashMap<String, Object> ());
  }

  public IodaCrisisPartnersService(Map<String, Object> context) throws Exception {
    super(context);
  }
  
  @Override
  public String getName() {
    return "crisis_partners";
  }
  
  @Override
  public String getShortPath() {
    return "/webjars/gind/ioda/crisis_partners/crisis_partners.html";
  }


  @Override
  public void boot(fr.emac.gind.launcher.Configuration conf) throws Exception {
    super.boot(conf);
  }

  @Override
  public void doRun(Configuration configuration,
      Environment environment, RestResourceManager resourceManager) throws Exception {
    super.doRun(configuration, environment, resourceManager);
    
    resourceManager.addResource(new CoreModelResource(this.conf));
    resourceManager.addResource(new CollaborationResource(this.conf, this.context));
    resourceManager.addResource(new CoreResource(this.conf));
    resourceManager.addResource(new DeductionRulesResource(this.conf));
    resourceManager.addResource(new ProcessGeneratorManagerResource(this.conf, this.context));
    resourceManager.addResource(new ServiceResource());
    
//    boolean hasModelResource = CommonsGovService.hasAlreadyModelResource(environment);
//    if(!hasModelResource) {
//      LOG.info("No models ressource found. Set the default models resources: " + ModelsResource.class.getName());
    if(resourceManager.findResource(ModelsResource.class) == null) {
      resourceManager.addResource(new ModelsResource(conf, new IodaCrisisPartnersPopulateInterceptor(this.conf)));
    } else {
      resourceManager.findResource(ModelsResource.class).addInterceptors(new IodaCrisisPartnersPopulateInterceptor(this.conf));
    }


  }

  
  public static IodaCrisisPartnersService create(GJaxbUser user, URL config) throws Exception {
    File parentDir = new File(config.toURI()).getParentFile();
    Map<String, Object> context = new HashMap<String, Object>();
    context.put("currentToken", new AES().encrypt(user.getEmail() + ":" + MD5.cryptWithMD5(user.getPassword())));
    context.put("currentUser", user);
    
 

    IodaCrisisPartnersService modelerCrisisCrisisPartnersService = new IodaCrisisPartnersService(context);
    modelerCrisisCrisisPartnersService.boot(new fr.emac.gind.launcher.Configuration(config));
    modelerCrisisCrisisPartnersService.run(new String[]{ "server", modelerCrisisCrisisPartnersService.getYmlConfig().toString() });    
    return modelerCrisisCrisisPartnersService;
  }
  
}
