package fr.emac.gind.ioda.resource;

/*
 * #%L
 * dw-ioda-crisis-partners
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.SOAJAXBContext;
import fr.emac.gind.schema10.XSD2XML;
import fr.emac.gind.transport.protocol.soap.binding.SOAPBindingHelper;
import fr.emac.gind.transport.protocol.soap.binding.SOAPBindingHelper.Style;
import fr.emac.gind.users.model.GJaxbUser;
import fr.emac.gind.wsdl11.WSDLDefinitionsManager;
import gind.org.w3._2001.xmlschema.GJaxbElement;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTBinding;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTBindingOperation;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTDefinitions;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTMessage;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTOperation;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTParam;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPart;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPort;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPortType;
import io.dropwizard.auth.Auth;

import java.net.URL;
import java.util.Map;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;

/**
 *
 *
 * @author: Nicolas Salatge (nicolas.salatge@mines-albi.fr)
 */
@Path("/{genericApplication}/services/")
@Produces(MediaType.APPLICATION_JSON)
public class ServiceResource {


  @POST @Path("/addWsdl")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public String addWsdl(@Auth(required = true) GJaxbUser user, Map<String, Object> jsonObject) throws Exception {
    System.out.println("ZZZZZZZZZZZZZZZZZZZ addWsdl");
    String response = null;
    assert user != null && user.getPassword() != null;
    try {

      String wsdlUrl = (String) jsonObject.get("wsdlUrl");

      System.out.println("\n***************************Add wsdl\n*******************************");
      GJaxbTDefinitions wsdl = SOAJAXBContext.getInstance().unmarshallDocument(new URL(wsdlUrl), GJaxbTDefinitions.class);
      WSDLDefinitionsManager manager = new WSDLDefinitionsManager(wsdl);
      
      

      JSONArray itfsJson = new JSONArray();
      for(GJaxbTBinding binding: manager.getBindings()) {
        
        Style style = SOAPBindingHelper.getBindingStyle(binding);
        if(style == Style.DOCUMENT) {
        
          GJaxbTPort[] ports = manager.getPortsUsingBinding(binding);
          assert ports.length <= 1 : "Several endpoints found for same bindings";
          
          if(ports.length > 0) {
            JSONObject itfJson = new JSONObject();
            GJaxbTPort endpoint = ports[0];
            
            String endpointAddress = SOAPBindingHelper.getSOAPAddress(endpoint);
            
            
            
            GJaxbTPortType itf = manager.getPortType(binding.getType());
        
            itfJson.put("interfaceName", itf.getName());
            JSONArray opsJson = new JSONArray();
            itfJson.put("operations", opsJson);
            
            for(GJaxbTBindingOperation bop: binding.getOperation()) {
              JSONObject opJson = new JSONObject();
              String soapAction = SOAPBindingHelper.getSOAPAction(bop);
              
              GJaxbTOperation op = manager.getOperationOfInterface(bop.getName(), binding.getType());
              opsJson.put(opJson);
              
              GJaxbTParam input = manager.getInputOfOperation(op);
              GJaxbTMessage message = manager.getMessage(input.getMessage());
              GJaxbTPart part = message.getPart().get(0);
              GJaxbElement elmt = manager.getXSDSchemaManager().getElement(part.getElement());
              
              Element elmtDOM = XSD2XML.newInstance().generateElement(elmt, "???", null, manager.getXSDSchemaManager());
              opJson.put("soapAction", soapAction);
              opJson.put("wsdlUrl", wsdlUrl);
              opJson.put("input", XMLPrettyPrinter.print(elmtDOM));
              opJson.put("endpointAddress", endpointAddress);
              opJson.put("operationName", bop.getName());
              opJson.put("interfaceName", itf.getName());
            }
            itfsJson.put(itfJson);
            
          }
        }
      }

      
      response = itfsJson.toString();
    } catch(Exception e) {
      e.printStackTrace();
      throw e;
    }
    return response;
  }


}
